! Code Aspects, version 2.0.
! Michel Fioc, 2014-4-15. 

module mod_files
  
  private
  public :: new_unit, skip_comments

contains
  
  function new_unit()

! Find a new unit for input/output.
    implicit none
    integer :: new_unit
!......................................................................
!!! Local variables:
    integer :: i
    integer, parameter :: unit_min = 10, unit_max = 99
    logical :: opened
!______________________________________________________________________
    
    new_unit = -1
    do i = unit_min, unit_max
       inquire(unit = i, opened = opened)
       if (.not. opened) then
          new_unit = i
          exit
       endif
    enddo
    if (new_unit == (-1)) then
       write(*,*) "Error in function ""new_unit"": all possible units are &
            &already used."
       stop
    endif

  end function new_unit

!!!======================================================================

  subroutine skip_comments(unit)

! Skip comment lines (i.e. blank lines and lines where the first non-blank
! character is a "!").
    integer, intent(in) :: unit
!......................................................................
! Local variables:
    character(len=132) :: line, file_name
    integer :: ios
!______________________________________________________________________

    do
       read(unit,"(a)",iostat=ios) line
       if (ios /= 0) then
          inquire(unit=unit, name=file_name)
          file_name = adjustl(file_name)
          write(*,"(3a/)") "Problem while reading file """, trim(file_name), &
          """. Stopped."
       endif
       line = adjustl(line)
       if (line /= "" .and. line(1:1) /= "!") then ! Not a comment line.
          backspace(unit)
          exit
       endif
    enddo

  end subroutine skip_comments

end module mod_files
