!/*-----------------------------------------------------------------*/
!/*! 
!  \file f2003multiple.f
!  \brief Check RM computation with zeta != 0
!
!  \author  G. Boue
!           EXOEarths, Centro de Astrofisica, Universidade do Porto.
!
!   Copyright (C) 2012, CAUP
!   email of the author : gwenael.boue@astro.up.pt
!
!   This work has been supported by the European Research Council/European
!   Community under the FP7 through Starting Grant agreement number 239953, as
!   well as from Fundacao para a Ciencia e a Tecnologia (FCT) through program
!   Ciencia 2007 funded by FCT/MCTES (Portugal) and POPH/FSE (EC), and in the
!   form of grants reference PTDC/CTE-AST/098528/2008, SFRH/BPD/71230/2010, and
!   SFRH/BPD/81084/2011.
!
!  History:                                                                
!*/
!/*-----------------------------------------------------------------*/

!/*----------------------------------------------------------------*/
!/* License of the file :
!
!    This program is free software: you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by
!    the Free Software Foundation, either version 3 of the License, or
!    (at your option) any later version.
!
!    This program is distributed in the hope that it will be useful,
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with this program.  If not, see <http://www.gnu.org/licenses/>.
!*/
!/*----------------------------------------------------------------*/

       program main
       use module_arome

       implicit none
       real(8) :: v1, v2, v3
       type(C_PTR) :: arome
       integer :: nerror

       nerror = 0

       
       call arome_set_exit_on_error()

       !/* allocation of the ARoME structure */
       arome = arome_alloc_quad(0.6d0,0.0d0)
       
       !/* set the line profile (beta0, Vsini, sigma0, zeta, kmax) */
       nerror = arome_set_lineprofile(3.0d0,10.0d0,8.0d0,2.0d0,4,       &
     &                                arome)

       !/* set the planet parameters (Rp) */
       nerror = arome_set_planet( 0.1d0, arome)

       !/* initialization of the RM calculations */
       nerror = arome_init_CCF(arome)
       nerror = arome_init_iodine(arome)

       !/* computation at a given postion of the planet */
       nerror = arome_calc_fvpbetap(0.1d0,0.2d0,1.0d0,arome)

       !/* get the results */
       v1 = arome_get_RM_CCF(arome)
       v2 = arome_get_RM_iodine(arome)
       v3 = arome_get_RM_mean(arome)
       
       !/* release memory */
       call arome_free(arome)
       
       end program
