!/*-----------------------------------------------------------------*/
!/*! 
!  \file f2003multiple.f
!  \brief Check that functions fail normally
!
!  \author  G. Boue
!           EXOEarths, Centro de Astrofisica, Universidade do Porto.
!
!   Copyright (C) 2012, CAUP
!   email of the author : gwenael.boue@astro.up.pt
!
!   This work has been supported by the European Research Council/European
!   Community under the FP7 through Starting Grant agreement number 239953, as
!   well as from Fundacao para a Ciencia e a Tecnologia (FCT) through program
!   Ciencia 2007 funded by FCT/MCTES (Portugal) and POPH/FSE (EC), and in the
!   form of grants reference PTDC/CTE-AST/098528/2008, SFRH/BPD/71230/2010, and
!   SFRH/BPD/81084/2011.
!
!  History:                                                                
!*/
!/*-----------------------------------------------------------------*/

!/*----------------------------------------------------------------*/
!/* License of the file :
!
!    This program is free software: you can redistribute it and/or modify
!    it under the terms of the GNU General Public License as published by
!    the Free Software Foundation, either version 3 of the License, or
!    (at your option) any later version.
!
!    This program is distributed in the hope that it will be useful,
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with this program.  If not, see <http://www.gnu.org/licenses/>.
!*/
!/*----------------------------------------------------------------*/

       program main
       use module_arome

       implicit none
       real(8) :: x
       type(C_PTR) :: arome = C_NULL_PTR
       integer :: nerror = 0

       if (arome_set_lineprofile(3.0d0,10.0d0,8.0d0,0.0d0,4,arome)      &
     &     .eq. 0) then
         print *, "arome_set_lineprofile dhould have failed."
         stop 1
       endif

       if (arome_set_planet(0.1d0,arome) .eq. 0) then
         print *, "arome_set_planet should have failed."
         stop 1
       endif

       !/* allocation of the ARoME structure */
       arome = arome_alloc_quad(0.6d0,0.0d0)

       if (arome_init_CCF(arome) .eq. 0) then
         print *, "arome_init_CCF should have failed."
         stop 1
       endif

       if (arome_init_iodine(arome) .eq. 0) then
         print *, "arome_init_iodine should have failed."
         stop 1
       endif

       if (arome_calc_fvpbetap(0.0d0,0.0d0,1.0d0,arome) .eq. 0) then
         print *, "arome_calc_fvpbetap should have failed."
         stop 1
       endif

       if (arome_set_lineprofile(3.0d0,10.0d0,8.0d0,0.0d0,4,arome)      &
     &     .ne. 0) then
         stop 1
       endif

       if (arome_set_planet(0.1d0,arome) .ne. 0) then
         stop 1
       endif

       x = arome_get_flux(arome)
       if (x .eq. x) then
         print *, "arome_get_flux should have failed."
         stop 1
       endif

       x = arome_get_vp(arome)
       if (x .eq. x) then
         print *, "arome_get_vp should have failed."
         stop 1
       endif

       x = arome_get_betapR(arome)
       if (x .eq. x) then
         print *, "arome_get_betapR should have failed."
         stop 1
       endif

       x = arome_get_betapT(arome)
       if (x .eq. x) then
         print *, "arome_get_betapT should have failed."
         stop 1
       endif

       !/* release memory */
       call arome_free(arome)
       
       end program
