/*-----------------------------------------------------------------*/
/*! 
  \file cmset.c 
  \brief Check RM computation with zeta != 0

  \author  G. Boue
           EXOEarths, Centro de Astrofisica, Universidade do Porto.

   Copyright (C) 2012, CAUP
   email of the author : gwenael.boue@astro.up.pt

   This work has been supported by the European Research Council/European
   Community under the FP7 through Starting Grant agreement number 239953, as
   well as from Fundacao para a Ciencia e a Tecnologia (FCT) through program
   Ciencia 2007 funded by FCT/MCTES (Portugal) and POPH/FSE (EC), and in the
   form of grants reference PTDC/CTE-AST/098528/2008, SFRH/BPD/71230/2010, and
   SFRH/BPD/81084/2011.


  History:                                                                
*/
/*-----------------------------------------------------------------*/

/*----------------------------------------------------------------*/
/* License of the file :

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
/*----------------------------------------------------------------*/
#include <stdio.h>
#include "arome.h"


/*************************/
/* main routine          */
/* just a test           */
/*************************/
int main(int argc, char **argv)
{
   const int ncoord = 20;
   double v1, v2, v3;
   t_arome *parome;
   int status = 0;
   
   arome_set_exit_on_error();
   
   /* allocation of the ARoME structure */
   parome = arome_alloc_quad(0.6,0.0);
   
   /* set the line profile */
   status += arome_set_lineprofile(
          3.0   /* beta0 */,
          10.0  /* Vsini */,
          8.0   /* sigma0 */,
          2.0   /* zeta */,
          4     /* kmax */,
          parome);
   
   /* set the planet parameters */
   status += arome_set_planet( 0.1 /* Rp */, parome);
   
   /* initialization of the RM calculations */
   status += arome_init_CCF(parome);
   status += arome_init_iodine(parome);
   
   /* computation at a given postion of the planet */
   status += arome_calc_fvpbetap(0.1,0.2,1.0,parome);
   
   /* get the results */
   v1 = arome_get_RM_CCF(parome);
   v2 = arome_get_RM_iodine(parome);
   v3 = arome_get_RM_mean(parome);
   
   /* release memory */
   arome_free(parome);
   
   return status;
}
