!# This source file is distributed with code Pégase.3.0.1 (2019-02-21).
!# Copyright: Michel Fioc (Michel.Fioc@iap.fr), Sorbonne université, 
!# Institut d'astrophysique de Paris/CNRS, France.
!# 
!# Pégase.3.0.1 is governed by the CeCILL license under French law and abides 
!# by the rules of distribution of free software. You can use, modify and/or 
!# redistribute this software under the terms of the CeCILL license as circulated 
!# by CEA, CNRS and INRIA at "http://www.cecill.info". The text of this license
!# is also available in French and in English in directory "doc_dir/" of this
!# code.
!# 
!# As a counterpart to the access to the source code and to the rights to copy,
!# modify and redistribute it granted by the license, users are provided only
!# with a limited warranty, and the software's author, the holder of the
!# economic rights, and the successive licensors have only limited
!# liability. 
!# 
!# The fact that you are presently reading this means that you have had
!# knowledge of the CeCILL license and that you accept its terms.
!#====================================================================== 

module mod_types

  implicit none
  public

  integer, parameter :: std_int = kind(0)
  integer, parameter :: long_int = selected_int_kind(9)
  integer, parameter :: std_string = 72
  integer, parameter :: long_string = 132
  integer, parameter :: SPR = selected_real_kind(6, 37) !# Usual "single \
!# precision" real.
  integer, parameter :: DPR = selected_real_kind(15, 307) !# Usual "double \
!# precision" real.
  integer, parameter :: CDR = DPR !# Code's default real. Set to `DPR` for \
!# accuracy, but may be switched to `SPR` if memory is missing.

  type :: irreg_array_int
     integer :: dim = 0
     integer, dimension(:), pointer :: val => null()
  end type irreg_array_int

  type :: irreg_array_CDR
     integer :: dim = 0
     real(CDR), dimension(:), pointer :: val => null()
  end type irreg_array_CDR

  type :: irreg_array_DPR
     integer :: dim = 0
     real(DPR), dimension(:), pointer :: val => null()
  end type irreg_array_DPR

end module mod_types
