!# This source file is distributed with code Pégase.3.0.1 (2019-02-21).
!# Copyright: Michel Fioc (Michel.Fioc@iap.fr), Sorbonne université, 
!# Institut d'astrophysique de Paris/CNRS, France.
!# 
!# Pégase.3.0.1 is governed by the CeCILL license under French law and abides 
!# by the rules of distribution of free software. You can use, modify and/or 
!# redistribute this software under the terms of the CeCILL license as circulated 
!# by CEA, CNRS and INRIA at "http://www.cecill.info". The text of this license
!# is also available in French and in English in directory "doc_dir/" of this
!# code.
!# 
!# As a counterpart to the access to the source code and to the rights to copy,
!# modify and redistribute it granted by the license, users are provided only
!# with a limited warranty, and the software's author, the holder of the
!# economic rights, and the successive licensors have only limited
!# liability. 
!# 
!# The fact that you are presently reading this means that you have had
!# knowledge of the CeCILL license and that you accept its terms.
!#====================================================================== 

module mod_read_file_list

  implicit none
  private
  public :: read_file_list

contains

!#======================================================================
  
  subroutine read_file_list(dir, list, file, n_files, exist_warning, back)

!# Reads from file `list` a list of file names, `file(1)`, ..., `file(n_files)`;
!# all these files must be in directory `dir`.

    use mod_types
    use mod_linked_list
    use mod_file_access, only : open_file, skip_comment_lines, close_file, &
         path_file
    use mod_remove_duplicates, only : remove_duplicates
    
    implicit none
    character(len=*), intent(in) :: dir
    character(len=*), intent(in) :: list
    character(len=*), dimension(:), pointer :: file
    integer, intent(out) :: n_files
    logical, intent(in), optional :: exist_warning
    logical, intent(in), optional :: back
!#......................................................................
    integer :: unit, error
    logical :: exist, exist_warning_eff, back_eff
    character(len=std_string) :: string
    type(lk_lst_std_string) :: head_node
    type(lk_lst_std_string), pointer :: current_node
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    if (present(exist_warning)) then
       exist_warning_eff = exist_warning
    else
       exist_warning_eff = .false.
    endif

    if (present(back)) then
       back_eff = back
    else
       back_eff = .false.
    endif

!    call open_file(unit, dir // list)
    call open_file(unit, path_file(dir, list))
    n_files = 0
    call lk_lst_initialize(head_node)
    do
       read(unit, *, iostat = error) string
       if (error /= 0) exit
       string = adjustl(string)
       if (string == "" .or. string(1:1) == "!") cycle
!       inquire(file = dir // string, exist = exist)
       inquire(file = path_file(dir, string), exist = exist)
       if (exist) then
          n_files = n_files+1
          call lk_lst_new_node(head_node, current_node)
          current_node % val = string
       else
          if (exist_warning_eff) write(*, "(a)") "Warning: file """ // &
               trim(string) // """ listed in """ // trim(list) // """ does not exist."
       endif
    enddo
    call close_file(unit)

    call lk_lst_to_array(head_node, file, n_files)

    call remove_duplicates(file, n_files, back = back_eff)

  end subroutine read_file_list

end module mod_read_file_list
