!# This source file is distributed with code Pégase.3.0.1 (2019-02-21).
!# Copyright: Michel Fioc (Michel.Fioc@iap.fr), Sorbonne université, 
!# Institut d'astrophysique de Paris/CNRS, France.
!# 
!# Pégase.3.0.1 is governed by the CeCILL license under French law and abides 
!# by the rules of distribution of free software. You can use, modify and/or 
!# redistribute this software under the terms of the CeCILL license as circulated 
!# by CEA, CNRS and INRIA at "http://www.cecill.info". The text of this license
!# is also available in French and in English in directory "doc_dir/" of this
!# code.
!# 
!# As a counterpart to the access to the source code and to the rights to copy,
!# modify and redistribute it granted by the license, users are provided only
!# with a limited warranty, and the software's author, the holder of the
!# economic rights, and the successive licensors have only limited
!# liability. 
!# 
!# The fact that you are presently reading this means that you have had
!# knowledge of the CeCILL license and that you accept its terms.
!#====================================================================== 

module mod_interm_grid

  implicit none
  private

  interface interm_grid
     module procedure interm_grid_s, interm_grid_d
  end interface interm_grid

  public :: interm_grid
  
contains

!#======================================================================
  
  subroutine interm_grid_s(n, x, x_interm)
    
    use mod_types
    
    implicit none
    integer, intent(in) :: n
    real(SPR), dimension(:) :: x
    real(SPR), dimension(:), pointer :: x_interm
!#......................................................................
    integer :: i
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    if (associated(x_interm)) deallocate(x_interm)
    allocate(x_interm(n+1))
    x_interm(1) = x(1)*sqrt(x(1)/x(2))
    do i = 2, n
       x_interm(i) = sqrt(real(x(i-1), DPR)*real(x(i), DPR)) !# `real(., DPR)` \
!# to avoid over- and underflows.
    enddo
    x_interm(n+1) = x(n)*sqrt(x(n)/x(n-1))

  end subroutine interm_grid_s

!#======================================================================
  
  subroutine interm_grid_d(n, x, x_interm)
    
    use mod_types
    
    implicit none
    integer, intent(in) :: n
    real(DPR), dimension(:) :: x
    real(DPR), dimension(:), pointer :: x_interm
!#......................................................................
    integer :: i
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    if (associated(x_interm)) deallocate(x_interm)
    allocate(x_interm(n+1))
    x_interm(1) = x(1)*sqrt(x(1)/x(2))
    do i = 2, n
       x_interm(i) = sqrt(x(i-1)*x(i))
    enddo
    x_interm(n+1) = x(n)*sqrt(x(n)/x(n-1))

  end subroutine interm_grid_d

end module mod_interm_grid
