!# This source file is distributed with code Pégase.3.0.1 (2019-02-21).
!# Copyright: Michel Fioc (Michel.Fioc@iap.fr), Sorbonne université, 
!# Institut d'astrophysique de Paris/CNRS, France.
!# 
!# Pégase.3.0.1 is governed by the CeCILL license under French law and abides 
!# by the rules of distribution of free software. You can use, modify and/or 
!# redistribute this software under the terms of the CeCILL license as circulated 
!# by CEA, CNRS and INRIA at "http://www.cecill.info". The text of this license
!# is also available in French and in English in directory "doc_dir/" of this
!# code.
!# 
!# As a counterpart to the access to the source code and to the rights to copy,
!# modify and redistribute it granted by the license, users are provided only
!# with a limited warranty, and the software's author, the holder of the
!# economic rights, and the successive licensors have only limited
!# liability. 
!# 
!# The fact that you are presently reading this means that you have had
!# knowledge of the CeCILL license and that you accept its terms.
!#====================================================================== 

module mod_file_name_decomposition

  implicit none
  private
  public :: file_name_decomposition, path_file

contains

!#======================================================================
  
  subroutine file_name_decomposition(full_name, dir_name, stem, &
       extension, base_name, dir_sep, ext_sep, absolute_path)

!# `full_name` = `dir_name` + `base_name`.
!# `base_name` = `stem` + `extension`.
!# If not void, the last non blank character of `dir_name` is `dir_sep_eff` 
!# (`/` in Unix).
!# If not void, the first character of `extension` is `ext_sep_eff`
!# (`.` normally).

    implicit none
    character(len=*), intent(in) :: full_name    
    character(len=1), intent(in), optional :: dir_sep, ext_sep
    character(len=len(full_name)), intent(out), optional :: &
         dir_name, stem, extension, base_name
    logical, intent(out), optional :: absolute_path
!#......................................................................
    character(len=1), parameter :: dir_sep_def = "/"
    character(len=1) :: dir_sep_eff
    character(len=1), parameter :: ext_sep_def = "."
    character(len=1) :: ext_sep_eff
    character(len=len(full_name)) :: dir_name_eff, stem_eff, &
         extension_eff, base_name_eff
    integer :: pos
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    if (present(dir_sep)) then
       dir_sep_eff = dir_sep
    else
       dir_sep_eff = dir_sep_def
    endif

    pos = index(full_name, dir_sep_eff, back = .true.)
    dir_name_eff = adjustl(full_name(:pos))
    base_name_eff = adjustl(full_name(pos+1:))

    if (present(ext_sep)) then
       ext_sep_eff = ext_sep
    else
       ext_sep_eff = ext_sep_def
    endif

    pos = index(base_name_eff, ext_sep_eff, back = .true.)
    if (pos > 1) then !# "> 1" and not "> 0", so that hidden files (beginning
!# with a dot) will not be considered as extension if there is no other dot.
       stem_eff = base_name_eff(:pos-1)
       extension_eff = base_name_eff(pos:)
    else
       stem_eff = base_name_eff
       extension_eff = ""
    endif
    if (present(dir_name)) dir_name = dir_name_eff
    if (present(stem)) stem = stem_eff
    if (present(extension)) extension = extension_eff
    if (present(base_name)) base_name = base_name_eff
    if (present(absolute_path)) then
       if (dir_name_eff(1:1) == dir_sep_eff .or. dir_name_eff(1:1) == "~") then
          absolute_path = .true.
       else
          absolute_path = .false.
       endif
    endif

  end subroutine file_name_decomposition

!#======================================================================

  function path_file(dir_name, file_name)

    use mod_types
    implicit none
    character(len=*), intent(in) :: dir_name, file_name
    character(len=len_trim(dir_name)+len_trim(file_name)) :: path_file
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    path_file = trim(dir_name) // trim(file_name)

  end function path_file

end module mod_file_name_decomposition
