!# This source file is part of code Pégase.3.0.1 (2019-02-21).
!# Copyright: Michel Fioc (Michel.Fioc@iap.fr), Sorbonne université, 
!# Institut d'astrophysique de Paris/CNRS, France.
!# 
!# Pégase.3.0.1 is governed by the CeCILL license under French law and abides 
!# by the rules of distribution of free software. You can use, modify and/or 
!# redistribute this software under the terms of the CeCILL license as circulated 
!# by CEA, CNRS and INRIA at "http://www.cecill.info". The text of this license
!# is also available in French and in English in directory "doc_dir/" of this
!# code.
!# 
!# As a counterpart to the access to the source code and to the rights to copy,
!# modify and redistribute it granted by the license, users are provided only
!# with a limited warranty, and the software's author, the holder of the
!# economic rights, and the successive licensors have only limited
!# liability. 
!# 
!# The fact that you are presently reading this means that you have had
!# knowledge of the CeCILL license and that you accept its terms.
!#====================================================================== 

program plot_grain_temp

  use mod_read_grain_temp
  use mod_types
  use mod_directories, only : grain_temp_dir
  use mod_select_file, only : select_single_file
  use mod_constants, only : grain_temp_list
  use mod_strings, only : quote_string

  implicit none
!#......................................................................
  character(len=std_string) :: file_name
  type(struct_grain_temp) :: data
  integer :: i_age, i_species, i_region, i_radius, dim_temp
  real :: x_min, x_max, y_min, y_max, delta_x
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

  call select_single_file(dir = grain_temp_dir, list = grain_temp_list, &
       selected_file = file_name, &
       object = "file of grain temperatures", &
       objects = "files of grain temperatures", back = .true.)

  write(*,*) "Reading file..."
  call read_grain_temp(file_name, data)

  call pgbegin(0, "?", 1, 1)
  call pgask(.false.)
  call pgscf(2)
  do i_age = 1, data % dim_age_grains
     write(*,*) "age/(1 Myr)  = ", data % age_grains(i_age)
     do i_region = 1, data % dim_region
        write(*,*) "region = ", quote_string(data % region(i_region) % id)
        if (data % region(i_region) % stoch_heating) then
           do i_species = 1, data % region(i_region) % dim_species
           write(*,*) "species = ", quote_string(data % region(i_region) &
                % species(i_species) % id)
              do i_radius = 1, data % region(i_region) % species(i_species) &
                   % dim_radius
                 write(*,*) "radius/(1 um) = ", data % region(i_region) &
                      % species(i_species) % radius(i_radius)
                 dim_temp = data % region(i_region) % species(i_species) &
                      % state(i_age, i_radius) % dim_temp
                 x_min = log10(data % region(i_region) % species(i_species) &
                      % state(i_age, i_radius) % temp(1))
                 x_max = log10(data % region(i_region) % species(i_species) &
                      % state(i_age, i_radius) % temp(dim_temp))
                 y_min = minval(data % region(i_region) % species(i_species) &
                      % state(i_age, i_radius) % prob(:))
                 y_max = maxval(data % region(i_region) % species(i_species) &
                      % state(i_age, i_radius) % prob(:))
                 delta_x = x_max - x_min
                 x_min = x_min - 0.1*delta_x
                 x_max = x_max + 0.1*delta_x
                 y_max = y_max + 0.1*(y_max - y_min)
                 call pgenv(x_min, x_max, y_min, y_max, 0, 10)
                 call pglabel("\fiT\fr/(1 K)", "d\fiP\fr/d(log\d10\u \fiT\fr)", &
                      "Grain temperature probability")
                 call pgsci(2)
                 call pgline(dim_temp, &
                      real(log10(data % region(i_region) % species(i_species) &
                      % state(i_age, i_radius) % temp(:))), &
                      real(data % region(i_region) % species(i_species) &
                      % state(i_age, i_radius) % prob(:)))
                 call pgsci(1)
                 write(*,*) "Press the <RETURN>/<ENTER> key to proceed."
                 read(*,*)
              enddo
           enddo
        end if
     enddo
  enddo
  call pgend

end program plot_grain_temp
