!# This source file is part of code Pégase.3.0.1 (2019-02-21).
!# Copyright: Michel Fioc (Michel.Fioc@iap.fr), Sorbonne université, 
!# Institut d'astrophysique de Paris/CNRS, France.
!# 
!# Pégase.3.0.1 is governed by the CeCILL license under French law and abides 
!# by the rules of distribution of free software. You can use, modify and/or 
!# redistribute this software under the terms of the CeCILL license as circulated 
!# by CEA, CNRS and INRIA at "http://www.cecill.info". The text of this license
!# is also available in French and in English in directory "doc_dir/" of this
!# code.
!# 
!# As a counterpart to the access to the source code and to the rights to copy,
!# modify and redistribute it granted by the license, users are provided only
!# with a limited warranty, and the software's author, the holder of the
!# economic rights, and the successive licensors have only limited
!# liability. 
!# 
!# The fact that you are presently reading this means that you have had
!# knowledge of the CeCILL license and that you accept its terms.
!#====================================================================== 

program plot_grain_SED

  use mod_read_grain_SED
  use mod_types
  use mod_directories, only : grain_SED_dir
  use mod_select_file, only : select_single_file
  use mod_constants, only : grain_SED_list
  use mod_strings, only : quote_string

  implicit none
!#......................................................................
  character(len=std_string) :: file_name
  type(struct_grain_SED) :: data
  integer :: i_age, i_species, i_region, i_radius, dim_lambda
  real :: x_min, x_max, y_min, y_max, delta_x
  real(CDR) :: eps
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

  call select_single_file(dir = grain_SED_dir, list = grain_SED_list, &
       selected_file = file_name, &
       object = "file of grain SEDs", &
       objects = "files of grain SEDs", back = .true.)
  
  write(*,*) "Reading file..."
  call read_grain_SED(file_name, data)

  call pgbegin(0, "?", 1, 1)
  call pgask(.false.)
  call pgscf(2)
  do i_age = 1, data % dim_age_grains
     write(*,*) "age/(1 Myr)  = ", data % age_grains(i_age)
     do i_region = 1, data % dim_region
        write(*,*) "region = ", quote_string(data % region(i_region) % id)
        do i_species = 1, data % region(i_region) % dim_species
           dim_lambda = data % region(i_region) % species(i_species) % dim_lambda
           write(*,*) "species = ", quote_string(data % region(i_region) &
                % species(i_species) % id)
           do i_radius = 1, data % region(i_region) % species(i_species) &
                % dim_radius
              write(*,*) "radius/(1 um) = ", data % region(i_region) &
                   % species(i_species) % radius(i_radius)
              x_min = log10(data % region(i_region) % species(i_species) &
                   % lambda(1))
              x_max = log10(data % region(i_region) % species(i_species) &
                   % lambda(dim_lambda))
              y_min = minval(data % region(i_region) % species(i_species) &
                   % lambda(:) * data % region(i_region) % species(i_species) &
                   % lum_eq(i_age, i_radius, :))
              y_max = maxval(data % region(i_region) % species(i_species) &
                   % lambda(:) * data % region(i_region) % species(i_species) &
                   % lum_eq(i_age, i_radius, :))
              if (data % region(i_region) % stoch_heating) then
                 y_min = min(y_min, &
                      real(minval(data % region(i_region) % species(i_species) &
                      % lambda(:) * data % region(i_region) % species(i_species) &
                      % lum_stoch(i_age, i_radius, :))))
                 y_max = max(y_max, &
                      real(maxval(data % region(i_region) % species(i_species) &
                      % lambda(:) * data % region(i_region) % species(i_species) &
                      % lum_stoch(i_age, i_radius, :))))
              endif
              y_min = max(y_min, y_max/1.e10)
              eps = y_min
              delta_x = x_max - x_min
              x_min = x_min - 0.1*delta_x
              x_max = x_max + 0.1*delta_x
              y_min = log10(y_min)
              y_max = log10(y_max)
              y_max = y_max + 0.1*(y_max - y_min)
              call pgenv(x_min, x_max, y_min, y_max, 0, 30)
              call pglabel("\gl/(1 \A)", "\gl \fiL\fr\d\gl\u", &
                   "Grain emission spectrum")
              if (data % region(i_region) % stoch_heating) then
                 call pgsci(2)
                 call pgtext(x_min+0.05*(x_max-x_min), &
                      y_max-0.1*(y_max-y_min), "With stochastic heating.")
                 call pgline(dim_lambda, &
                      real(log10(data % region(i_region) % species(i_species) &
                      % lambda(:))), &
                      real(log10(max(data % region(i_region) % species(i_species) &
                      % lambda(:) * data % region(i_region) % species(i_species) &
                      % lum_stoch(i_age, i_radius, :), eps))))
              end if
              call pgsci(3)
              call pgtext(x_min+0.05*(x_max-x_min), &
                   y_max-0.05*(y_max-y_min), "Without stochastic heating.")
              call pgline(dim_lambda, &
                   real(log10(data % region(i_region) % species(i_species) &
                   % lambda(:))), &
                   real(log10(max(data % region(i_region) % species(i_species) &
                   % lambda(:) * data % region(i_region) % species(i_species) &
                   % lum_eq(i_age, i_radius, :), eps))))
              call pgsci(1)
              write(*,*) "Press the <RETURN>/<ENTER> key to proceed."
              read(*,*)
           enddo
        enddo
     enddo
  enddo
  call pgend

end program plot_grain_SED
