!# This source file is part of code Pégase.3.0.1 (2019-02-21).
!# Copyright: Michel Fioc (Michel.Fioc@iap.fr), Sorbonne université, 
!# Institut d'astrophysique de Paris/CNRS, France.
!# 
!# Pégase.3.0.1 is governed by the CeCILL license under French law and abides 
!# by the rules of distribution of free software. You can use, modify and/or 
!# redistribute this software under the terms of the CeCILL license as circulated 
!# by CEA, CNRS and INRIA at "http://www.cecill.info". The text of this license
!# is also available in French and in English in directory "doc_dir/" of this
!# code.
!# 
!# As a counterpart to the access to the source code and to the rights to copy,
!# modify and redistribute it granted by the license, users are provided only
!# with a limited warranty, and the software's author, the holder of the
!# economic rights, and the successive licensors have only limited
!# liability. 
!# 
!# The fact that you are presently reading this means that you have had
!# knowledge of the CeCILL license and that you accept its terms.
!#====================================================================== 

module mod_spectra_def_param

  use mod_types
  implicit none
  public


!# Maximal age in Myr:
  real(CDR), parameter, public :: max_age = 20001._CDR

!#**********************************************************************
!# Default values of parameters used in "mod_read_SF_param.f90":
  real(CDR), parameter :: SF_begin_time_def = 0._CDR
  real(CDR), parameter :: SF_end_time_def = max_age
  character(len=std_string), parameter :: SF_type_def = "none"
  real(CDR), parameter :: SF_inst_mass_def = 1._CDR
  real(CDR), parameter :: SF_const_mass_def = 1._CDR
  real(CDR), parameter :: SF_expo_mass_def = 1._CDR
  real(CDR), parameter :: SF_peaked_mass_def = 1._CDR
  real(CDR), parameter :: SF_ISM_power_def = 1._CDR
  real(CDR), parameter :: SF_ISM_threshold_def = 0._CDR
  real(CDR), parameter :: SF_infall_factor_def = 1._CDR
  logical, parameter :: SF_stochastic_def = .false.
  character(len=std_string), parameter :: SF_Z_type_def = "consistent"
  real(CDR), parameter :: SF_inert_frac_def = 0._CDR

!#**********************************************************************
!# Default values of parameters used in "mod_read_dust_evol_param.f90":

  character(len=std_string), parameter :: dust_evolution_def = "basic"
  real(CDR), parameter :: O_sil_ratio_def = 1._CDR
  real(CDR), parameter :: ISM_carb_deplet_def = 1._CDR/3
  real(CDR), parameter :: ISM_sil_deplet_def = 1._CDR
  real(CDR), parameter :: CCSN_carb_deplet_def = 0.5_CDR
  real(CDR), parameter :: SNIa_carb_deplet_def = 0.5_CDR
  real(CDR), parameter :: HMW_carb_deplet_def = 1._CDR
  real(CDR), parameter :: LMW_carb_deplet_def = 1._CDR
  real(CDR), parameter :: CCSN_sil_deplet_def = 0.8_CDR
  real(CDR), parameter :: SNIa_sil_deplet_def = 0.8_CDR
  real(CDR), parameter :: HMW_sil_deplet_def = 1._CDR
  real(CDR), parameter :: LMW_sil_deplet_def = 1._CDR
  real(CDR), parameter :: SN_swept_mass_def = 400._CDR !# \
!# ~= <m_d>_MW/Z_{d, MW}. See Dwek & Cherchneff 2011, ApJ 727, 63, just after Eq. (9).
  real(CDR), parameter :: carb_accr_timescale_def = 250._CDR !# See McKinnon \
!# et al. 2015, arXiv:1505.04792, Sect. 3.2.
  real(CDR), parameter :: sil_accr_timescale_def = 250._CDR !# Idem.

!#**********************************************************************
!# Default values of parameters used in "mod_read_dust_transfer_param.f90":

  logical, parameter :: extinction_def = .false., &
       extinction_SFC_def = extinction_def, &
       extinction_DISM_def = extinction_def
  real(CDR), parameter :: bulge_tot_ratio_def = 1._CDR/7
  real(CDR), parameter :: M_sys_spiral_def = 7.e10_CDR
  real(CDR), parameter :: expo_radius_def = 3.5e3_CDR
  real(CDR), parameter :: M_sys_spher_def = 2.79e11_CDR
  real(CDR), parameter :: core_radius_def = 192._CDR
  real(CDR), parameter :: slab_factor_def = 6.8e21_CDR
!# Laor, A. & Draine, B. T., 1993; ApJ, 402, 441; Sec. 2.3, p. 448, 3rd paragraph:
  real(CDR), parameter :: carb_sublim_temp_def = 1750._CDR
  real(CDR), parameter :: carb_sublim_temp_SFC_def = carb_sublim_temp_def
  real(CDR), parameter :: carb_sublim_temp_DISM_def = carb_sublim_temp_def
  real(CDR), parameter :: sil_sublim_temp_def = 1400._CDR
  real(CDR), parameter :: sil_sublim_temp_SFC_def = sil_sublim_temp_def
  real(CDR), parameter :: sil_sublim_temp_DISM_def = sil_sublim_temp_def
  character(len=std_string), parameter :: geometry_def = "spiral"
  logical, parameter :: dust_emission_def = .false.
  logical, parameter :: dust_emission_SFC_def = dust_emission_def
  logical, parameter :: dust_emission_DISM_def = dust_emission_def
  real(CDR), parameter :: self_abs_power_def = 0._CDR
  real(CDR), parameter :: self_abs_power_SFC_def = self_abs_power_def
  real(CDR), parameter :: self_abs_power_DISM_def = self_abs_power_def
  logical, parameter :: stoch_heating_def = .true.
  logical, parameter :: stoch_heating_SFC_def = stoch_heating_def
  logical, parameter :: stoch_heating_DISM_def = stoch_heating_def
  logical, parameter :: inclin_averaged_def = .true.
  real(CDR), parameter :: inclination_def = 0._CDR
  character(len=std_string), parameter :: grains_file_def = &
       "ZDA.txt"
  character(len=std_string), parameter :: &
       grains_file_SFC_def = grains_file_def, &
       grains_file_DISM_def = grains_file_def

!#**********************************************************************
!# Default values of parameters used in "mod_read_cloud_neb_param.f90":

  logical, parameter :: nebular_emission_def = .false., &
       nebular_emission_SFC_def = nebular_emission_def, &
       nebular_emission_DISM_def = nebular_emission_def
  character(len=std_string), parameter :: neb_emis_type_def = "automatic", &
       neb_emis_type_SFC_def = neb_emis_type_def, &
       neb_emis_type_DISM_def = neb_emis_type_def
  real(CDR), parameter :: neb_emis_const_frac_def = 0.7_CDR, &
       neb_emis_const_frac_SFC_def = neb_emis_const_frac_def, &
       neb_emis_const_frac_DISM_def = neb_emis_const_frac_def
!# Log10(typical value of ionization parameter in the diffuse ISM):
  real(CDR), parameter, public :: l10_mean_U_DISM_def = -3.5_CDR
!# (From Flores-Fajardo et al. 2011, MNRAS 415, 2182.)
  real(CDR), parameter :: cluster_stel_mass_def = 1.e4_CDR
  real(CDR), parameter :: cloud_init_frac_def = 1._CDR
  real(CDR), parameter :: cloud_power_def = 1._CDR
  real(CDR), parameter :: cloud_duration_def = 10._CDR

!#**********************************************************************
!# Default values of parameters used in "mod_read_other_param.f90":

  logical, parameter :: check_only_def = .false.
  real(CDR), parameter :: ISM_init_Z_def = 0
  real(CDR), parameter :: close_bin_frac_def = 0.05_CDR
  integer, parameter :: verbosity_def = 0

!#**********************************************************************
!# Default values of parameters used in "mod_read_output_param.f90":

  character(len=std_string), parameter :: spectra_output_def = "basic"
  logical, parameter :: RF_output_def = .false.
  logical, parameter :: sublim_output_def = .false.
  character(len=std_string), parameter :: &
       ages_file_def = "spectra_ages.txt"
  character(len=std_string), parameter :: prefix_def = ""
  logical, parameter :: stamp_time_def = .false.
  logical, parameter :: overwrite_def = .false.
  logical, parameter :: grain_temp_output_def = .false.
  logical, parameter :: grain_SED_output_def = .false.
  logical, parameter :: grain_output_SFC_def = .true.
  logical, parameter :: grain_output_DISM_def = .true.
  real(CDR), parameter :: grain_output_min_age_def = 0, &
       grain_output_max_age_def = huge(1._CDR)
  real(CDR), parameter :: grain_output_min_size_def = 0, &
       grain_output_max_size_def = huge(1._CDR)

!#**********************************************************************
!# Default values of parameters used in "mod_read_outflow_param.f90":

  character(len=std_string), parameter :: outflow_type_def = "none"
  real(CDR), parameter :: outflow_begin_time_def = 0._CDR
  real(CDR), parameter :: outflow_end_time_def = max_age
  real(CDR), parameter :: outflow_SF_power_def = 0._CDR
  real(CDR), parameter :: outflow_SN_power_def = 0._CDR
  real(CDR), parameter :: outflow_CCSN_power_def = 0._CDR
  real(CDR), parameter :: outflow_SNIa_power_def = 0._CDR
  real(CDR), parameter :: outflow_ejec_factor_def = 1._CDR

!#**********************************************************************
!# Default values of parameters used in "mod_read_reserv_infall_param.f90":

  real(CDR), parameter :: reserv_init_mass_def = 0._CDR
  real(CDR), parameter :: reserv_Z_def = 0._CDR
  character(len=std_string), parameter :: infall_type_def = "none"
  real(CDR), parameter :: infall_inst_mass_def = 1._CDR
  real(CDR), parameter :: infall_const_mass_def = 1._CDR
  real(CDR), parameter :: infall_expo_mass_def = 1._CDR
  real(CDR), parameter :: infall_reserv_power_def = 1._CDR
  real(CDR), parameter :: infall_begin_time_def = 0._CDR
  real(CDR), parameter :: infall_end_time_def = max_age

!#**********************************************************************
!# Default values of parameters used in "mod_read_cosmo_param.f90":

  real(CDR), parameter :: Omega_m_def = 0.308_CDR !# Planck 2015 results. XIII. Cosmological parameters, \
  real(CDR), parameter :: H_0_def = 67.8_CDR       !# A&A 594, A13.

  real(CDR), parameter :: form_redshift_def = 10._CDR
  logical, parameter :: CBR_def = .false.

end module mod_spectra_def_param
