!# This source file is part of code Pégase.3.0.1 (2019-02-21).
!# Copyright: Michel Fioc (Michel.Fioc@iap.fr), Sorbonne université, 
!# Institut d'astrophysique de Paris/CNRS, France.
!# 
!# Pégase.3.0.1 is governed by the CeCILL license under French law and abides 
!# by the rules of distribution of free software. You can use, modify and/or 
!# redistribute this software under the terms of the CeCILL license as circulated 
!# by CEA, CNRS and INRIA at "http://www.cecill.info". The text of this license
!# is also available in French and in English in directory "doc_dir/" of this
!# code.
!# 
!# As a counterpart to the access to the source code and to the rights to copy,
!# modify and redistribute it granted by the license, users are provided only
!# with a limited warranty, and the software's author, the holder of the
!# economic rights, and the successive licensors have only limited
!# liability. 
!# 
!# The fact that you are presently reading this means that you have had
!# knowledge of the CeCILL license and that you accept its terms.
!#====================================================================== 

module mod_spectra_constants

  use mod_types

  implicit none
  private

!# Indicative value of the bin size in log10(radius) used for grains:
  real(CDR), parameter, public :: d_l10_rad0 = 0.01_CDR
  
!# Initial  number of temperatures used in the computation of temperature stochastic fluctuations:
  integer, parameter, public :: dim_temp = 201

!# Default minimal and maximal grain temperatures used in the computation of temperature 
!# stochastic fluctuations:
  real(CDR), parameter, public :: T_min_def = 1._CDR, &
       T_max_def = 1.e5_CDR

!# Minimal relative difference of wavelengths used in subroutine `intersperse` (called in 
!# "spectra.f90") when combining two sets of wavelengths:
  real(CDR), parameter, public :: eps_lambda = 1.e-4_CDR

!# Maximal numbers of reservoirs and of infall, star formation and outflow episodes:
  integer, parameter, public :: max_dim_reserv = 10
  integer, parameter, public :: max_dim_infall_epis = 10
  integer, parameter, public :: max_dim_SF_epis = 10
  integer, parameter, public :: max_dim_outflow_epis = 10

!# Redshift 0 temperature of the cosmic background radiation.
  real(CDR), parameter, public :: T_CBR0 = 2.7260_CDR !# Fixsen (2009), \
!# ApJ 707, 916.

!# Factor converting, for spheroidals, the dust mass to the total column 
!# density through the center, from side to side.
  real(CDR), parameter, public :: King_factor = 7.587e-5_CDR

!# Maximal age for an HII region. Stars producing Lyman continuum photons
!# but older than this age (post-AGB, hot horizontal branch stars) are not
!# considered when computing the nebular emission:
  real(CDR), parameter, public :: HII_max_age = 50._CDR

!# Approximate wavelength of the $V$ band in micrometers:
  real(CDR), parameter, public :: lambda_V = 5500.e-4_CDR

  character(len=std_string), parameter, public :: &
       scenarios_list = "list_scenarios.txt"

end module mod_spectra_constants
