!# This source file is part of code Pégase.3.0.1 (2019-02-21).
!# Copyright: Michel Fioc (Michel.Fioc@iap.fr), Sorbonne université, 
!# Institut d'astrophysique de Paris/CNRS, France.
!# 
!# Pégase.3.0.1 is governed by the CeCILL license under French law and abides 
!# by the rules of distribution of free software. You can use, modify and/or 
!# redistribute this software under the terms of the CeCILL license as circulated 
!# by CEA, CNRS and INRIA at "http://www.cecill.info". The text of this license
!# is also available in French and in English in directory "doc_dir/" of this
!# code.
!# 
!# As a counterpart to the access to the source code and to the rights to copy,
!# modify and redistribute it granted by the license, users are provided only
!# with a limited warranty, and the software's author, the holder of the
!# economic rights, and the successive licensors have only limited
!# liability. 
!# 
!# The fact that you are presently reading this means that you have had
!# knowledge of the CeCILL license and that you accept its terms.
!#====================================================================== 

module mod_spectra_ages

  private
  public :: read_spectra_ages

contains
  
!#======================================================================
  
  subroutine read_spectra_ages(ages_file, dim_output_age, output_age)

    use mod_types
    use mod_linked_list
    use mod_directories, only : ages_dir
    use mod_file_access, only : open_file, skip_comment_lines, close_file, &
         path_file

    implicit none
    character(len=*), intent(in) :: ages_file
    integer, intent(out) :: dim_output_age
    real(CDR), dimension(:), pointer :: output_age
!#......................................................................
    integer :: ios, unit
    type(lk_lst_CDR) :: head_node
    type(lk_lst_CDR), pointer :: current_node
    real(CDR) :: x
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call open_file(unit, path_file(ages_dir, ages_file))
    dim_output_age = 0
    call lk_lst_initialize(head_node)
    do
       read(unit,*,iostat=ios) x
       if (ios /= 0) exit
       dim_output_age = dim_output_age+1
       call lk_lst_new_node(head_node, current_node)
       current_node % val = x
    enddo
    call close_file(unit)

    call lk_lst_to_array(head_node, output_age, dim_output_age)

  end subroutine read_spectra_ages
  
end module mod_spectra_ages
