!# This source file is part of code Pégase.3.0.1 (2019-02-21).
!# Copyright: Michel Fioc (Michel.Fioc@iap.fr), Sorbonne université, 
!# Institut d'astrophysique de Paris/CNRS, France.
!# 
!# Pégase.3.0.1 is governed by the CeCILL license under French law and abides 
!# by the rules of distribution of free software. You can use, modify and/or 
!# redistribute this software under the terms of the CeCILL license as circulated 
!# by CEA, CNRS and INRIA at "http://www.cecill.info". The text of this license
!# is also available in French and in English in directory "doc_dir/" of this
!# code.
!# 
!# As a counterpart to the access to the source code and to the rights to copy,
!# modify and redistribute it granted by the license, users are provided only
!# with a limited warranty, and the software's author, the holder of the
!# economic rights, and the successive licensors have only limited
!# liability. 
!# 
!# The fact that you are presently reading this means that you have had
!# knowledge of the CeCILL license and that you accept its terms.
!#====================================================================== 

module mod_read_other_param
  
  use mod_types
  use mod_linked_list
  use mod_analyze_statement, only : get_val, error_message
  use mod_parse_file, only : len_max_statement
  use mod_random, only : dim_seed, seed

  implicit none
  public
  character(len=std_string), save :: SSPs_set
  real(CDR), save :: ISM_init_Z
  real(CDR), save :: close_bin_frac
  integer, save :: verbosity

  logical, save :: new_statement
  logical, save :: check_only
  character(len=std_string), save :: scenarios_file = ""

!# Variables for which no default value exists.

  logical, private :: SSPs_set_set

contains

!#======================================================================
  
  subroutine reset_others !# ??? And for `seed`?

    use mod_spectra_def_param
    implicit none
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    SSPs_set_set = .false.
    check_only = check_only_def
    ISM_init_Z = ISM_init_Z_def
    close_bin_frac = close_bin_frac_def
    verbosity = verbosity_def

  end subroutine reset_others
  
!#======================================================================

  subroutine read_other_param_check

    implicit none

    if (.not. SSPs_set_set) then
       write(*, "(a,i0,a)") "Value of `SSPs_set` is unknown. Stopped."
       stop
    endif

  end subroutine read_other_param_check

!#======================================================================

  subroutine read_SSPs_set_name(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
    
    call get_val(SSPs_set, rhs)
    SSPs_set_set = .true.

  end subroutine read_SSPs_set_name

!#======================================================================

  subroutine read_ISM_init_Z(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
    
    call get_val(ISM_init_Z, rhs)

  end subroutine read_ISM_init_Z

!#======================================================================

  subroutine read_close_bin_frac(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
    
    call get_val(close_bin_frac, rhs)

  end subroutine read_close_bin_frac

!#======================================================================
  
  subroutine read_verbosity(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
    
    call get_val(verbosity, rhs)
    
  end subroutine read_verbosity

!#======================================================================

  subroutine read_seed(rhs, indices_string)

    implicit none
    character(len=*), intent(in) :: rhs
    character(len=*), intent(inout) :: indices_string
!#......................................................................
    logical, dimension(dim_seed) :: index_present
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
    
    call get_val(seed, rhs, indices_string, index_present) 
    if (.not.all(index_present)) then
       call error_message("The assignment to `seed` must be provided as &
            &`seed(1:^dim_seed^) = [^seeds^]`, where &
            &(1) ^dim_seed^ is the size of the array `seed` and &
            &(2) ^seeds^ is the full list of the elements of `seed`, separated by commas. &
            &All these values are integer literals.")
    endif
    call random_seed(put = seed)
    
  end subroutine read_seed

end module mod_read_other_param
