!# This source file is part of code Pégase.3.0.1 (2019-02-21).
!# Copyright: Michel Fioc (Michel.Fioc@iap.fr), Sorbonne université, 
!# Institut d'astrophysique de Paris/CNRS, France.
!# 
!# Pégase.3.0.1 is governed by the CeCILL license under French law and abides 
!# by the rules of distribution of free software. You can use, modify and/or 
!# redistribute this software under the terms of the CeCILL license as circulated 
!# by CEA, CNRS and INRIA at "http://www.cecill.info". The text of this license
!# is also available in French and in English in directory "doc_dir/" of this
!# code.
!# 
!# As a counterpart to the access to the source code and to the rights to copy,
!# modify and redistribute it granted by the license, users are provided only
!# with a limited warranty, and the software's author, the holder of the
!# economic rights, and the successive licensors have only limited
!# liability. 
!# 
!# The fact that you are presently reading this means that you have had
!# knowledge of the CeCILL license and that you accept its terms.
!#====================================================================== 

module mod_read_dust_evol_param

  use mod_types
  use mod_analyze_statement, only : get_val, file_name, line_number, &
       error_message, warning_message

  implicit none
  public
  real(CDR), save :: ISM_carb_deplet, ISM_sil_deplet, &
       CCSN_carb_deplet, HMW_carb_deplet, LMW_carb_deplet, &
       CCSN_sil_deplet, HMW_sil_deplet, LMW_sil_deplet, &
       SN_swept_mass, SNIa_carb_deplet, SNIa_sil_deplet, &
       carb_accr_timescale, sil_accr_timescale, O_sil_ratio

  character(len=std_string), save :: dust_evolution

contains

!#======================================================================

  subroutine reset_dust_evol

    use mod_spectra_def_param
    implicit none
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    dust_evolution = dust_evolution_def

    O_sil_ratio = O_sil_ratio_def

    ISM_carb_deplet = ISM_carb_deplet_def
    ISM_sil_deplet = ISM_sil_deplet_def

    CCSN_carb_deplet = CCSN_carb_deplet_def
    SNIa_carb_deplet = SNIa_carb_deplet_def
    HMW_carb_deplet = HMW_carb_deplet_def
    LMW_carb_deplet = LMW_carb_deplet_def
    CCSN_sil_deplet = CCSN_sil_deplet_def
    SNIa_sil_deplet = SNIa_sil_deplet_def
    HMW_sil_deplet = HMW_sil_deplet_def
    LMW_sil_deplet = LMW_sil_deplet_def
    SN_swept_mass = SN_swept_mass_def
    carb_accr_timescale = carb_accr_timescale_def
    sil_accr_timescale = sil_accr_timescale_def

  end subroutine reset_dust_evol

!#======================================================================

  subroutine dust_evol_check
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

  end subroutine dust_evol_check

!#======================================================================

  subroutine read_dust_evolution(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(dust_evolution, rhs)
    if (all(dust_evolution /= (/ &
         "basic", &
         "Dwek "/))) &
         call error_message("The value of `dust_evolution` should be &
         &""basic"" or ""Dwek"".")

  end subroutine read_dust_evolution

!#======================================================================

  subroutine read_O_sil_ratio(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(O_sil_ratio, rhs)

  end subroutine read_O_sil_ratio

!#======================================================================

  subroutine read_ISM_carb_deplet(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(ISM_carb_deplet, rhs)
    call set_dust_evolution("basic")

  end subroutine read_ISM_carb_deplet

!#======================================================================

  subroutine read_ISM_sil_deplet(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(ISM_sil_deplet, rhs)
    call set_dust_evolution("basic")

  end subroutine read_ISM_sil_deplet

!#======================================================================

  subroutine read_CCSN_carb_deplet(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(CCSN_carb_deplet, rhs)
    call set_dust_evolution("Dwek")

  end subroutine read_CCSN_carb_deplet

!#======================================================================

  subroutine read_SNIa_carb_deplet(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(SNIa_carb_deplet, rhs)
    call set_dust_evolution("Dwek")

  end subroutine read_SNIa_carb_deplet

!#======================================================================

  subroutine read_HMW_carb_deplet(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(HMW_carb_deplet, rhs)
    call set_dust_evolution("Dwek")

  end subroutine read_HMW_carb_deplet

!#======================================================================

  subroutine read_LMW_carb_deplet(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(LMW_carb_deplet, rhs)
    call set_dust_evolution("Dwek")

  end subroutine read_LMW_carb_deplet

!#======================================================================

  subroutine read_CCSN_sil_deplet(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(CCSN_sil_deplet, rhs)
    call set_dust_evolution("Dwek")

  end subroutine read_CCSN_sil_deplet

!#======================================================================

  subroutine read_SNIa_sil_deplet(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(SNIa_sil_deplet, rhs)
    call set_dust_evolution("Dwek")

  end subroutine read_SNIa_sil_deplet

!#======================================================================

  subroutine read_HMW_sil_deplet(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(HMW_sil_deplet, rhs)
    call set_dust_evolution("Dwek")

  end subroutine read_HMW_sil_deplet

!#======================================================================

  subroutine read_LMW_sil_deplet(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(LMW_sil_deplet, rhs)
    call set_dust_evolution("Dwek")

  end subroutine read_LMW_sil_deplet

!#======================================================================

  subroutine read_SN_swept_mass(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(SN_swept_mass, rhs)
    call set_dust_evolution("Dwek")

  end subroutine read_SN_swept_mass

!#======================================================================

  subroutine read_carb_accr_timescale(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(carb_accr_timescale, rhs)
    call set_dust_evolution("Dwek")

  end subroutine read_carb_accr_timescale

!#======================================================================

  subroutine read_sil_accr_timescale(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(sil_accr_timescale, rhs)
    call set_dust_evolution("Dwek")

  end subroutine read_sil_accr_timescale

!#======================================================================

  subroutine set_dust_evolution(val_dust_evolution)

    implicit none
    character(len=*), intent(in) :: val_dust_evolution
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    dust_evolution = val_dust_evolution

  end subroutine set_dust_evolution

end module mod_read_dust_evol_param
