!# This source file is part of code Pégase.3.0.1 (2019-02-21).
!# Copyright: Michel Fioc (Michel.Fioc@iap.fr), Sorbonne université, 
!# Institut d'astrophysique de Paris/CNRS, France.
!# 
!# Pégase.3.0.1 is governed by the CeCILL license under French law and abides 
!# by the rules of distribution of free software. You can use, modify and/or 
!# redistribute this software under the terms of the CeCILL license as circulated 
!# by CEA, CNRS and INRIA at "http://www.cecill.info". The text of this license
!# is also available in French and in English in directory "doc_dir/" of this
!# code.
!# 
!# As a counterpart to the access to the source code and to the rights to copy,
!# modify and redistribute it granted by the license, users are provided only
!# with a limited warranty, and the software's author, the holder of the
!# economic rights, and the successive licensors have only limited
!# liability. 
!# 
!# The fact that you are presently reading this means that you have had
!# knowledge of the CeCILL license and that you accept its terms.
!#====================================================================== 

module mod_read_columns

  use mod_types

  implicit none
  private
  public :: read_columns

contains

!#======================================================================
  
  subroutine read_columns(file, dim_array, array1, array2)

!# Read a file containing two arrays of reals, `array1` and `array2`, in columns 1 and 2 respectively.
!# Computes their size, `dim_array`, and allocates the arrays.
!# Comment lines (blank lines or lines beginning with "!") at the beginning of the file are skipped.

    use mod_types
    use mod_linked_list
    use mod_file_access, only : open_file, skip_comment_lines, close_file

    implicit none
    character(len=*), intent(in) :: file
    integer, intent(out) :: dim_array
    real(CDR), dimension(:), pointer :: array1, array2
!#......................................................................
    integer :: unit, ios
    real(CDR) :: tmp1, tmp2
    type(lk_lst_CDR) :: head_node1, head_node2
    type(lk_lst_CDR), pointer :: current_node1, current_node2
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call open_file(unit, file)
    dim_array = 0
    call lk_lst_initialize(head_node1)
    call lk_lst_initialize(head_node2)
    do
       read(unit,*,iostat=ios) tmp1, tmp2
       if (ios /= 0) exit
       dim_array = dim_array + 1
       call lk_lst_new_node(head_node1, current_node1)
       call lk_lst_new_node(head_node2, current_node2)
       current_node1 % val = tmp1
       current_node2 % val = tmp2
    enddo
    call close_file(unit)
    
    call lk_lst_to_array(head_node1, array1, dim_array)
    call lk_lst_to_array(head_node2, array2, dim_array)

  end subroutine read_columns

end module mod_read_columns
