!# This source file is part of code Pégase.3.0.1 (2019-02-21).
!# Copyright: Michel Fioc (Michel.Fioc@iap.fr), Sorbonne université, 
!# Institut d'astrophysique de Paris/CNRS, France.
!# 
!# Pégase.3.0.1 is governed by the CeCILL license under French law and abides 
!# by the rules of distribution of free software. You can use, modify and/or 
!# redistribute this software under the terms of the CeCILL license as circulated 
!# by CEA, CNRS and INRIA at "http://www.cecill.info". The text of this license
!# is also available in French and in English in directory "doc_dir/" of this
!# code.
!# 
!# As a counterpart to the access to the source code and to the rights to copy,
!# modify and redistribute it granted by the license, users are provided only
!# with a limited warranty, and the software's author, the holder of the
!# economic rights, and the successive licensors have only limited
!# liability. 
!# 
!# The fact that you are presently reading this means that you have had
!# knowledge of the CeCILL license and that you accept its terms.
!#====================================================================== 

module mod_read_cloud_neb_param

  use mod_types
  use mod_analyze_statement, only : get_val, file_name, line_number, &
       error_message, warning_message

  implicit none
  public
  logical, save :: nebular_emission, nebular_emission_SFC, nebular_emission_DISM
  character(len=std_string), save :: neb_emis_type, neb_emis_type_SFC, neb_emis_type_DISM
  real(CDR), save :: cluster_stel_mass, cloud_init_frac, cloud_power, &
       cloud_duration, neb_emis_const_frac, neb_emis_const_frac_SFC, neb_emis_const_frac_DISM, l10_mean_U_DISM

  private :: nebular_emission, neb_emis_type, neb_emis_const_frac

contains

!#======================================================================
  
  subroutine reset_cloud_neb

    use mod_spectra_def_param
    implicit none
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
    
    nebular_emission_SFC = nebular_emission_SFC_def
    nebular_emission_DISM = nebular_emission_DISM_def
    neb_emis_type_SFC = neb_emis_type_SFC_def
    neb_emis_const_frac_SFC = neb_emis_const_frac_SFC_def
    neb_emis_type_DISM = neb_emis_type_DISM_def
    neb_emis_const_frac_DISM = neb_emis_const_frac_DISM_def
    l10_mean_U_DISM = l10_mean_U_DISM_def
    cluster_stel_mass = cluster_stel_mass_def
    cloud_init_frac = cloud_init_frac_def
    cloud_power = cloud_power_def
    cloud_duration = cloud_duration_def

  end subroutine reset_cloud_neb

!#======================================================================

  subroutine cloud_neb_check

    implicit none
!# ???
  end subroutine cloud_neb_check

!#======================================================================

  subroutine read_nebular_emission(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(nebular_emission, rhs)
    nebular_emission_SFC = nebular_emission
    nebular_emission_DISM = nebular_emission

  end subroutine read_nebular_emission

!#======================================================================

  subroutine read_nebular_emission_SFC(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(nebular_emission_SFC, rhs)

  end subroutine read_nebular_emission_SFC
!#======================================================================

  subroutine read_nebular_emission_DISM(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(nebular_emission_DISM, rhs)

  end subroutine read_nebular_emission_DISM

!#======================================================================

  subroutine read_neb_emis_type(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(neb_emis_type, rhs)

    if (all(neb_emis_type /= (/ &
         "automatic", &
         "constant "/))) then
       call error_message("The value of `neb_emis_type` should be &
            &""automatic"" or ""constant"".")
    else
       neb_emis_type_SFC = neb_emis_type
       neb_emis_type_DISM = neb_emis_type
       call set_nebular_emission_SFC(.true.)
       call set_nebular_emission_DISM(.true.)
    endif

  end subroutine read_neb_emis_type

!#======================================================================

  subroutine read_neb_emis_type_SFC(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(neb_emis_type_SFC, rhs)

    if (all(neb_emis_type_SFC /= (/ &
         "automatic", &
         "constant "/))) then
       call error_message("The value of `neb_emis_type_SFC` should be &
            &""automatic"" or ""constant"".")
    else
       call set_nebular_emission_SFC(.true.)
    endif

  end subroutine read_neb_emis_type_SFC

!#======================================================================

  subroutine read_neb_emis_type_DISM(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(neb_emis_type_DISM, rhs)

    if (all(neb_emis_type_DISM /= (/ &
         "automatic", &
         "constant "/))) then
       call error_message("The value of `neb_emis_type_DISM` should be &
            &""automatic"" or ""constant"".")
    else
       call set_nebular_emission_DISM(.true.)
    endif

  end subroutine read_neb_emis_type_DISM

!#======================================================================

  subroutine read_neb_emis_const_frac(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(neb_emis_const_frac, rhs)
    neb_emis_const_frac_SFC = neb_emis_const_frac
    neb_emis_const_frac_DISM = neb_emis_const_frac    
    call set_neb_emis_type_SFC("constant")
    call set_neb_emis_type_DISM("constant")

  end subroutine read_neb_emis_const_frac

!#======================================================================

  subroutine read_neb_emis_const_frac_SFC(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(neb_emis_const_frac_SFC, rhs)
    call set_neb_emis_type_SFC("constant")

  end subroutine read_neb_emis_const_frac_SFC

!#======================================================================

  subroutine read_neb_emis_const_frac_DISM(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(neb_emis_const_frac_DISM, rhs)
    call set_neb_emis_type_DISM("constant")

  end subroutine read_neb_emis_const_frac_DISM

!#======================================================================

  subroutine read_l10_mean_U_DISM(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call get_val(l10_mean_U_DISM, rhs)

  end subroutine read_l10_mean_U_DISM

!#======================================================================

  subroutine set_nebular_emission_SFC(val_nebular_emission)

    implicit none
    logical, intent(in) :: val_nebular_emission
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    nebular_emission_SFC = val_nebular_emission

  end subroutine set_nebular_emission_SFC

!#======================================================================

  subroutine set_nebular_emission_DISM(val_nebular_emission)

    implicit none
    logical, intent(in) :: val_nebular_emission
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    nebular_emission_DISM = val_nebular_emission

  end subroutine set_nebular_emission_DISM

!#======================================================================

  subroutine set_neb_emis_type_SFC(val_neb_emis_type)

    implicit none
    character(len=*), intent(in) :: val_neb_emis_type
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    neb_emis_type_SFC = val_neb_emis_type
    call set_nebular_emission_SFC(.true.)

  end subroutine set_neb_emis_type_SFC

!#======================================================================

  subroutine set_neb_emis_type_DISM(val_neb_emis_type)

    implicit none
    character(len=*), intent(in) :: val_neb_emis_type
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    neb_emis_type_DISM = val_neb_emis_type
    call set_nebular_emission_DISM(.true.)

  end subroutine set_neb_emis_type_DISM

!#======================================================================

  subroutine read_cluster_stel_mass(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
    
    call get_val(cluster_stel_mass, rhs)

  end subroutine read_cluster_stel_mass

!#======================================================================

  subroutine read_cloud_init_frac(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
    
    call get_val(cloud_init_frac, rhs)

  end subroutine read_cloud_init_frac

!#======================================================================

  subroutine read_cloud_power(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
    
    call get_val(cloud_power, rhs)

  end subroutine read_cloud_power

!#======================================================================

  subroutine read_cloud_duration(rhs)

    implicit none
    character(len=*), intent(in) :: rhs
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
    
    call get_val(cloud_duration, rhs)

  end subroutine read_cloud_duration

end module mod_read_cloud_neb_param
