!# This source file is part of code Pégase.3.0.1 (2019-02-21).
!# Copyright: Michel Fioc (Michel.Fioc@iap.fr), Sorbonne université, 
!# Institut d'astrophysique de Paris/CNRS, France.
!# 
!# Pégase.3.0.1 is governed by the CeCILL license under French law and abides 
!# by the rules of distribution of free software. You can use, modify and/or 
!# redistribute this software under the terms of the CeCILL license as circulated 
!# by CEA, CNRS and INRIA at "http://www.cecill.info". The text of this license
!# is also available in French and in English in directory "doc_dir/" of this
!# code.
!# 
!# As a counterpart to the access to the source code and to the rights to copy,
!# modify and redistribute it granted by the license, users are provided only
!# with a limited warranty, and the software's author, the holder of the
!# economic rights, and the successive licensors have only limited
!# liability. 
!# 
!# The fact that you are presently reading this means that you have had
!# knowledge of the CeCILL license and that you accept its terms.
!#====================================================================== 

module mod_read_abundances

  private
  public :: read_abundances

contains

!#======================================================================
  
  subroutine read_abundances(file, dim_elem, abund, elem_id)
    
    use mod_types
    use mod_linked_list
    use mod_file_access, only : open_file, skip_comment_lines, close_file

    implicit none
    character(len=*), intent(in) :: file
    integer, intent(out) :: dim_elem
    real(DPR), dimension(:), pointer :: abund
    character(len=std_string), dimension(:), pointer :: elem_id
!#......................................................................
    integer :: unit, ios
    real(DPR) :: tmp_abund
    character(len=std_string) :: tmp_elem
    type(lk_lst_DPR) :: head_node_abund
    type(lk_lst_DPR), pointer :: current_node_abund
    type(lk_lst_std_string) :: head_node_elem
    type(lk_lst_std_string), pointer :: current_node_elem
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    call open_file(unit, file)
    dim_elem = 0
    call lk_lst_initialize(head_node_abund)
    call lk_lst_initialize(head_node_elem)
    do 
       read(unit,*,iostat=ios) tmp_abund, tmp_elem
       if (ios /= 0) exit
       dim_elem = dim_elem+1
       call lk_lst_new_node(head_node_abund, current_node_abund)
       call lk_lst_new_node(head_node_elem, current_node_elem)
       current_node_abund % val = tmp_abund
       current_node_elem % val = adjustl(tmp_elem)
    enddo
    call close_file(unit)

    call lk_lst_to_array(head_node_abund, abund, dim_elem)
    call lk_lst_to_array(head_node_elem, elem_id, dim_elem)

  end subroutine read_abundances

end module mod_read_abundances
