!# This source file is part of code Pégase.3.0.1 (2019-02-21).
!# Copyright: Michel Fioc (Michel.Fioc@iap.fr), Sorbonne université, 
!# Institut d'astrophysique de Paris/CNRS, France.
!# 
!# Pégase.3.0.1 is governed by the CeCILL license under French law and abides 
!# by the rules of distribution of free software. You can use, modify and/or 
!# redistribute this software under the terms of the CeCILL license as circulated 
!# by CEA, CNRS and INRIA at "http://www.cecill.info". The text of this license
!# is also available in French and in English in directory "doc_dir/" of this
!# code.
!# 
!# As a counterpart to the access to the source code and to the rights to copy,
!# modify and redistribute it granted by the license, users are provided only
!# with a limited warranty, and the software's author, the holder of the
!# economic rights, and the successive licensors have only limited
!# liability. 
!# 
!# The fact that you are presently reading this means that you have had
!# knowledge of the CeCILL license and that you accept its terms.
!#====================================================================== 

module mod_process_file_name

  implicit none
  private
  public :: process_file_name, process_file_name_aux

contains

!#======================================================================

  subroutine process_file_name(full_name, prefix, default_dir, file_type, &
       time_stamp_value, stamp_time, ordinal, verbosity, time_stamp_used, overwrite)

    use mod_file_access, only : file_name_decomposition, path_file
    use mod_strings, only : quote_string
    use mod_convert_type

    implicit none
    character(len=*), intent(inout) :: full_name
    character(len=*), intent(in) :: prefix, default_dir, file_type, time_stamp_value
    logical, intent(in) :: stamp_time
    integer, intent(in) :: verbosity
    integer, intent(in) :: ordinal
    logical, intent(in) :: overwrite
    logical, intent(inout) :: time_stamp_used
!#......................................................................
    logical :: exist
    character(len=len(full_name)) :: dir_name, stem, extension, base_name
    integer :: number
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    if (.not.time_stamp_used) then
       if (stamp_time) then
          time_stamp_used = .true.
       endif
    endif
    call file_name_decomposition(full_name, dir_name = dir_name, &
         stem = stem, extension = extension, base_name = base_name)
    if (stem == "") then
       if (extension == "") then
          extension = ".txt"
       endif
       if (prefix == "") then
          full_name = trim(dir_name) // trim(time_stamp_value) // "_" // &
               trim(file_type) // to_string(ordinal) // extension
          time_stamp_used = .true.
       else !# `prefix /= ""`.
          if (stamp_time) then
             full_name = trim(dir_name) // trim(prefix) // "_" // &
                  trim(time_stamp_value) // "_" // trim(file_type) // &
                  to_string(ordinal) // extension
          else
             full_name = trim(dir_name) // trim(prefix) // "_" // &
                  trim(file_type) // to_string(ordinal) // extension
          endif
       endif
    else !# `stem /= ""`.
       if (prefix == "") then
          if (stamp_time) then
             full_name = trim(dir_name) // trim(time_stamp_value) // "_" //  base_name
          else
             full_name = trim(dir_name) // base_name
          endif
       else !# `prefix /= ""`.
          if (stamp_time) then
             full_name = trim(dir_name) // trim(prefix) // "_" // &
                  trim(time_stamp_value) // "_" // base_name
          else
             full_name = trim(dir_name) // trim(prefix) // "_" // base_name
          endif
       endif
    endif

    inquire(file = path_file(default_dir, full_name), exist = exist)
    if (exist .and. .not.overwrite) then
       if (verbosity >= 0) write(*, "(a)") "File " // &
            quote_string(full_name) // " already existed in " // &
            quote_string(default_dir) // "."
!# Add `time_stamp_value` as a prefix, unless it already has been used previously;
!# if so, write a number before the extension.
!# (Excessively unlikely that it will be needed since `time_stamp_value` is derived
!# from the time at the beginning of the run, from the year up to the second.)
       if (.not.time_stamp_used) then
          call file_name_decomposition(full_name, dir_name = dir_name, &
               stem = stem, extension = extension, &
               base_name = base_name)
          full_name = trim(dir_name) // trim(time_stamp_value) // "_" // &
               trim(stem) // extension
       end if

       inquire(file = path_file(default_dir, full_name), exist = exist)
       if (exist) then
          call file_name_decomposition(full_name, dir_name = dir_name, &
               stem = stem, extension = extension, &
               base_name = base_name)
          number = 0
          do
             number = number + 1
             full_name = trim(dir_name) // trim(stem) // "_" // &
                  to_string(number) // extension
             inquire(file = path_file(default_dir, full_name), exist = exist)
             if (.not.exist) exit
          enddo
       endif
       if (verbosity >= 0) write(*, "(a/)") "A new file named " // &
            quote_string(full_name) // " will be created instead."
    endif

  end subroutine process_file_name

!#======================================================================

  subroutine process_file_name_aux(full_name_aux, full_name_main, prefix, default_dir, file_type, &
       time_stamp_value, stamp_time, ordinal, verbosity, time_stamp_used_main, overwrite)

    use mod_file_access, only : file_name_decomposition
    use mod_strings, only : quote_string
    use mod_convert_type

    implicit none
    character(len=*), intent(inout) :: full_name_aux
    character(len=*), intent(in) :: full_name_main, prefix, default_dir, file_type, time_stamp_value
    logical, intent(in) :: stamp_time
    integer, intent(in) :: verbosity
    integer, intent(in) :: ordinal
    logical, intent(in) :: time_stamp_used_main
    logical, intent(in) :: overwrite
!#......................................................................
    character(len=max(len(full_name_aux),len(full_name_main))) :: dir_name, base_name
    logical :: time_stamp_used_aux
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    if (full_name_aux /= "") then
       time_stamp_used_aux = .false.
       call process_file_name(full_name_aux, prefix, default_dir, &
            file_type, time_stamp_value, stamp_time, ordinal, verbosity, &
            time_stamp_used_aux, overwrite)
    else !# No name provided for the auxiliary file. Create one based on that \
!# of the main file.
       call file_name_decomposition(full_name_main, dir_name = dir_name, &
            base_name = base_name)
       if (prefix /= "" .and. index(base_name,trim(prefix)) == 1) &
            then !# Prefix found at the beginning of `base_name`.
          if (time_stamp_used_main) then
             full_name_aux = trim(dir_name) // trim(prefix) // "_" // &
                  trim(time_stamp_value) // "_" // trim(file_type) // "_" // &
                  base_name(len_trim(prefix)+len_trim(time_stamp_value)+3:)
          else
             full_name_aux = trim(dir_name) // trim(prefix) // "_" // &
                  trim(file_type) // "_" // base_name(len_trim(prefix)+2:)
          endif
       else !# No prefix found.
          if (time_stamp_used_main) then
             full_name_aux = trim(dir_name) // trim(time_stamp_value) // "_" // &
                  trim(file_type) // "_" // base_name(len_trim(time_stamp_value)+2:)  
        else
             full_name_aux = trim(dir_name) // trim(file_type) // "_" // base_name
          endif
       endif
       time_stamp_used_aux = time_stamp_used_main
       call process_file_name(full_name_aux, "", default_dir, "", &
            time_stamp_value, stamp_time, ordinal, verbosity, time_stamp_used_aux, &
            overwrite)
    endif

  end subroutine process_file_name_aux

end module mod_process_file_name
