!# This source file is part of code Pégase.3.0.1 (2019-02-21).
!# Copyright: Michel Fioc (Michel.Fioc@iap.fr), Sorbonne université, 
!# Institut d'astrophysique de Paris/CNRS, France.
!# 
!# Pégase.3.0.1 is governed by the CeCILL license under French law and abides 
!# by the rules of distribution of free software. You can use, modify and/or 
!# redistribute this software under the terms of the CeCILL license as circulated 
!# by CEA, CNRS and INRIA at "http://www.cecill.info". The text of this license
!# is also available in French and in English in directory "doc_dir/" of this
!# code.
!# 
!# As a counterpart to the access to the source code and to the rights to copy,
!# modify and redistribute it granted by the license, users are provided only
!# with a limited warranty, and the software's author, the holder of the
!# economic rights, and the successive licensors have only limited
!# liability. 
!# 
!# The fact that you are presently reading this means that you have had
!# knowledge of the CeCILL license and that you accept its terms.
!#====================================================================== 

module mod_filters_constants

  use mod_types

  implicit none
  private
  
  character(len=*), parameter :: filters_list = "list_filters.txt"

!# Value used in "calib.f90" and "colors.f90" for undefined magnitudes and colors.
  real(DPR), parameter :: undefined_mag = 99.999_DPR

!# Minimal resolution for filter passbands:
  real(DPR), parameter :: filter_min_resol = 300._DPR

!# Standard magnitude of Vega:
  real(DPR), parameter :: std_Vega_def = 0.03_DPR

!# SED used for Vega:
  character(len=*), parameter :: Vega_SED_file = "Vega_BaSeL_SED.txt" !# From the BaSeL library.

!# SED used for the Sun:
  character(len=*), parameter :: Sun_SED_file = "Sun_BaSeL_SED.txt" !# From the BaSeL library.

!# SED of the faint subdwarf BD+17°4708 used to calibrate the Thuan & Gunn photometric system:
  character(len=*), parameter :: TG_SED_file = "BD+17d4708_SED.txt"

!# Bolometric magnitude of the Sun:
  real(DPR), parameter :: M_bol_Sun = 4.74_DPR
!# (Resolution B2 of the 29th general assembly of the International Astronomical Union.)

  public :: filters_list, undefined_mag, filter_min_resol, std_Vega_def, &
       Vega_SED_file, Sun_SED_file, TG_SED_file, M_bol_Sun

end module mod_filters_constants
