!# This source file is part of code Pégase.3.0.1 (2019-02-21).
!# Copyright: Michel Fioc (Michel.Fioc@iap.fr), Sorbonne université, 
!# Institut d'astrophysique de Paris/CNRS, France.
!# 
!# Pégase.3.0.1 is governed by the CeCILL license under French law and abides 
!# by the rules of distribution of free software. You can use, modify and/or 
!# redistribute this software under the terms of the CeCILL license as circulated 
!# by CEA, CNRS and INRIA at "http://www.cecill.info". The text of this license
!# is also available in French and in English in directory "doc_dir/" of this
!# code.
!# 
!# As a counterpart to the access to the source code and to the rights to copy,
!# modify and redistribute it granted by the license, users are provided only
!# with a limited warranty, and the software's author, the holder of the
!# economic rights, and the successive licensors have only limited
!# liability. 
!# 
!# The fact that you are presently reading this means that you have had
!# knowledge of the CeCILL license and that you accept its terms.
!#====================================================================== 

module mod_directories

  use mod_dir_access, only : dir_sep
  implicit none
  private

  character(len=*), parameter, public :: PEGASE3_dir = ".." // dir_sep
  character(len=*), parameter, public :: doc_dir = PEGASE3_dir // "doc_dir" // dir_sep
  character(len=*), parameter, public :: IMFs_dir = PEGASE3_dir // "IMFs_dir" // dir_sep
  character(len=*), parameter, public :: stel_lib_dir = PEGASE3_dir // "stel_lib_dir" // dir_sep
  character(len=*), parameter, public :: tracks_dir = PEGASE3_dir // "tracks_dir" // dir_sep
  character(len=*), parameter, public :: yields_dir = PEGASE3_dir // "yields_dir" // dir_sep
  character(len=*), parameter, public :: SSPs_dir = PEGASE3_dir // "SSPs_dir" // dir_sep
  character(len=*), parameter, public :: spectra_dir = PEGASE3_dir // "spectra_dir" // dir_sep
  character(len=*), parameter, public :: grain_temp_dir = PEGASE3_dir // "grain_temp_dir" // dir_sep
  character(len=*), parameter, public :: grain_SED_dir = PEGASE3_dir // "grain_SED_dir" // dir_sep
  character(len=*), parameter, public :: scenarios_dir = PEGASE3_dir // "scenarios_dir" // dir_sep
  character(len=*), parameter, public :: ages_dir = PEGASE3_dir // "ages_dir" // dir_sep
  character(len=*), parameter, public :: RT_dir = PEGASE3_dir // "RT_dir" // dir_sep
  character(len=*), parameter, public :: dust_dir = PEGASE3_dir // "dust_dir" // dir_sep
  character(len=*), parameter, public :: calib_dir = PEGASE3_dir // "calib_dir" // dir_sep
  character(len=*), parameter, public :: colors_dir = PEGASE3_dir // "colors_dir" // dir_sep
  character(len=*), parameter, public :: bin_dir = PEGASE3_dir // "bin_dir" // dir_sep
  character(len=*), parameter, public :: Cloudy_dir = PEGASE3_dir // "Cloudy_dir" // dir_sep
  character(len=*), parameter, public :: log_spectra_dir = bin_dir // "log_spectra_dir" // dir_sep

end module mod_directories
