!# This source file is part of code Pégase.3.0.1 (2019-02-21).
!# Copyright: Michel Fioc (Michel.Fioc@iap.fr), Sorbonne université, 
!# Institut d'astrophysique de Paris/CNRS, France.
!# 
!# Pégase.3.0.1 is governed by the CeCILL license under French law and abides 
!# by the rules of distribution of free software. You can use, modify and/or 
!# redistribute this software under the terms of the CeCILL license as circulated 
!# by CEA, CNRS and INRIA at "http://www.cecill.info". The text of this license
!# is also available in French and in English in directory "doc_dir/" of this
!# code.
!# 
!# As a counterpart to the access to the source code and to the rights to copy,
!# modify and redistribute it granted by the license, users are provided only
!# with a limited warranty, and the software's author, the holder of the
!# economic rights, and the successive licensors have only limited
!# liability. 
!# 
!# The fact that you are presently reading this means that you have had
!# knowledge of the CeCILL license and that you accept its terms.
!#====================================================================== 

module mod_compute_various

  private
  public :: compute_various

contains

!#======================================================================
  
  subroutine compute_various(i_time, convol_time, beta, inv_time, L_bol_SSP, SF_live_d_mass, &
       SSP_Z_weight, &
       L_dust, L_bol, dust_bol_ratio, stel_Z_bol_avrg, &
       stel_age_bol_avrg, &
       mass_stars_SSP, live_stars_mass, stel_Z_mass_avrg, stel_age_mass_avrg, &
       Lyman_cont_rate, Lyman_cont_gas_abs, Lyman_cont_dust_abs)

    use mod_types
    use mod_constants, only : L_sol
    
    implicit none
    integer, intent(in) :: i_time
    real(CDR), dimension(:), intent(in) :: convol_time
    real(CDR), dimension(:), intent(in) :: beta
    integer, dimension(:), intent(in) :: inv_time
    real(CDR), dimension(:, :), intent(in) :: L_bol_SSP, mass_stars_SSP
    real(CDR), dimension(:,:), intent(in) :: SSP_Z_weight
    real(DPR), dimension(:,:), intent(in) :: SF_live_d_mass
    real(CDR), intent(in) :: L_dust
    real(CDR), intent(out) :: L_bol, stel_age_bol_avrg, stel_Z_bol_avrg, &
         live_stars_mass, stel_Z_mass_avrg, stel_age_mass_avrg, dust_bol_ratio
    real(CDR), intent(in) :: Lyman_cont_rate
    real(CDR), intent(inout) :: Lyman_cont_gas_abs, Lyman_cont_dust_abs
!#......................................................................
    integer :: i_convol1, i_convol2
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    L_bol = 0
    stel_Z_bol_avrg = 0
    stel_age_bol_avrg = 0
    live_stars_mass = 0
    stel_Z_mass_avrg = 0
    stel_age_mass_avrg = 0
    do i_convol1 = 1, i_time
       i_convol2 = i_time+1-i_convol1
       L_bol = L_bol + beta(i_convol2)*sum(SF_live_d_mass(:,i_convol1)*L_bol_SSP(:,inv_time(i_convol2))) &
            + (1-beta(i_convol2))*sum(SF_live_d_mass(:,i_convol1)*L_bol_SSP(:,inv_time(i_convol2)+1))

       stel_Z_bol_avrg = stel_Z_bol_avrg + (beta(i_convol2) * &
            sum(SF_live_d_mass(:,i_convol1)*SSP_Z_weight(:,i_convol1)*L_bol_SSP(:,inv_time(i_convol2))) &
            + (1-beta(i_convol2)) * &
            sum(SF_live_d_mass(:,i_convol1)*SSP_Z_weight(:,i_convol1)*L_bol_SSP(:,inv_time(i_convol2)+1)))

       stel_age_bol_avrg = stel_age_bol_avrg + (convol_time(i_time)-convol_time(i_convol1)) * &
            (beta(i_convol2)*sum(SF_live_d_mass(:,i_convol1)*L_bol_SSP(:,inv_time(i_convol2))) &
            + (1-beta(i_convol2))*sum(SF_live_d_mass(:,i_convol1)*L_bol_SSP(:,inv_time(i_convol2)+1)))

!# "Stars" = luminous, evolving stars, not dark and unevolving (inert) objects from the outset.

       live_stars_mass = live_stars_mass + sum(SF_live_d_mass(:,i_convol1)*mass_stars_SSP(:, i_convol2))

       stel_Z_mass_avrg = stel_Z_mass_avrg + &
            sum(SF_live_d_mass(:,i_convol1)*SSP_Z_weight(:,i_convol1)*mass_stars_SSP(:, i_convol2))

       stel_age_mass_avrg = stel_age_mass_avrg &
            + (convol_time(i_time)-convol_time(i_convol1)) &
            * sum(SF_live_d_mass(:,i_convol1)*mass_stars_SSP(:, i_convol2))
    end do

    if (live_stars_mass > 0) then
       stel_age_mass_avrg = stel_age_mass_avrg/live_stars_mass
       stel_Z_mass_avrg = stel_Z_mass_avrg/live_stars_mass
    else
       stel_age_mass_avrg = 0
       stel_Z_mass_avrg = 0
    end if

    if (L_bol > 0) then
       dust_bol_ratio = L_dust/L_bol/L_sol
       stel_Z_bol_avrg = stel_Z_bol_avrg/L_bol
       stel_age_bol_avrg = stel_age_bol_avrg/L_bol
    else
       dust_bol_ratio = 0
       stel_Z_bol_avrg = 0
       stel_age_bol_avrg = 0
    end if

    if (Lyman_cont_rate > 0) then
       Lyman_cont_gas_abs = Lyman_cont_gas_abs/Lyman_cont_rate
       Lyman_cont_dust_abs = Lyman_cont_dust_abs/Lyman_cont_rate
    else
       Lyman_cont_gas_abs = 0
       Lyman_cont_dust_abs = 0
    endif

  end subroutine compute_various

end module mod_compute_various
