!# This source file is part of code Pégase.3.0.1 (2019-02-21).
!# Copyright: Michel Fioc (Michel.Fioc@iap.fr), Sorbonne université, 
!# Institut d'astrophysique de Paris/CNRS, France.
!# 
!# Pégase.3.0.1 is governed by the CeCILL license under French law and abides 
!# by the rules of distribution of free software. You can use, modify and/or 
!# redistribute this software under the terms of the CeCILL license as circulated 
!# by CEA, CNRS and INRIA at "http://www.cecill.info". The text of this license
!# is also available in French and in English in directory "doc_dir/" of this
!# code.
!# 
!# As a counterpart to the access to the source code and to the rights to copy,
!# modify and redistribute it granted by the license, users are provided only
!# with a limited warranty, and the software's author, the holder of the
!# economic rights, and the successive licensors have only limited
!# liability. 
!# 
!# The fact that you are presently reading this means that you have had
!# knowledge of the CeCILL license and that you accept its terms.
!#====================================================================== 

module mod_calib

  implicit none
  private
  integer, save :: dim_col = 0
  integer, save :: unit_calib
  integer, parameter :: format_max_length = 300
  character(len=format_max_length), save :: fmt
  public :: format_output, unit_calib, fmt

contains

!#======================================================================

  subroutine format_output(column_heading, fmt_col)

    use mod_types
    use mod_convert_type, only : to_string

    implicit none
    character(len=*) :: column_heading
    character(len=*), optional :: fmt_col
!#......................................................................
    character(std_string) :: fmt_col_eff, fmt_col_def = "f8.3"
    integer :: heading_width, content_width, pos_digit, pos_point, format_length
    character(std_string) :: left, right
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
    
!# Set the content width.
    if (present(fmt_col)) then
       fmt_col_eff = fmt_col
    else
       fmt_col_eff = fmt_col_def
    endif
    pos_digit = scan(fmt_col_eff, "0123456789")
    pos_point = index(fmt_col_eff, ".")
    if (pos_point == 0) then !# For integer and string formats.
       read(fmt_col_eff(pos_digit:),*) content_width
    else !# For reals.
       read(fmt_col_eff(pos_digit:pos_point-1),*) content_width
    endif

!# Format and write the column heading.
    heading_width = len_trim(adjustl(column_heading))
    if (max(content_width-heading_width,0)/2 > 0) then
       left = "tr" // to_string(max(content_width-heading_width,0)/2) // ","
    else
       left = ""
    endif

    if (max(content_width-heading_width,0)-max(content_width-heading_width,0)/2 > 0) then
       right = ",tr" // to_string(max(content_width-heading_width,0)- &
            max(content_width-heading_width,0)/2)
    else
       right = ""
    endif

    write(unit_calib, &
         "(" // trim(left) // "a" // trim(right) // ",tr1)", &
         advance="no") adjustl(column_heading)

!# Format the column content (written in the main program).
    dim_col = dim_col+1
    if (max(heading_width-content_width,0)/2 > 0) then
       left = "tr" // to_string(max(heading_width-content_width,0)/2) // ","
    else
       left = ""
    endif
    if (max(heading_width-content_width,0)-max(heading_width-content_width,0)/2 > 0) then
       right = ",tr" // to_string(max(heading_width-content_width,0)- &
            max(heading_width-content_width,0)/2)
    else
       right = ""
    endif

    if (dim_col == 1) then
       format_length = len_trim(left) + len_trim(fmt_col_eff) + len_trim(right)
       if (format_length > format_max_length) then
          write(*, "(a,i0,a)") "Execution of ""calib"" failed: &
               &the length of string `fmt` is longer than `format_max_length`. &
               &Set the value of the latter in ""mod_calib.f90"" to ", &
               format_length, " or more, and recompile. Stopped."
          stop
       endif
       fmt = trim(left) // trim(fmt_col_eff) // trim(right)
    else
       format_length = len_trim(fmt) + len(",tr1,") + len_trim(left) + &
            len_trim(fmt_col_eff) + len_trim(right)
       if (format_length > format_max_length) then
          write(*, "(a,i0,a)") "Execution of ""calib"" failed: &
               &the length of string `fmt` is longer than `format_max_length`. &
               &Set the value of the latter in ""mod_calib.f90"" to ", &
               format_length, " or more, and recompile. Stopped."
          stop
       endif
       fmt = trim(fmt) // ",tr1," // trim(left) // &
            trim(fmt_col_eff) // trim(right)
    endif

  end subroutine format_output

end module mod_calib
