!# This source file is part of code Pégase.3.0.1 (2019-02-21).
!# Copyright: Michel Fioc (Michel.Fioc@iap.fr), Sorbonne université, 
!# Institut d'astrophysique de Paris/CNRS, France.
!# 
!# Pégase.3.0.1 is governed by the CeCILL license under French law and abides 
!# by the rules of distribution of free software. You can use, modify and/or 
!# redistribute this software under the terms of the CeCILL license as circulated 
!# by CEA, CNRS and INRIA at "http://www.cecill.info". The text of this license
!# is also available in French and in English in directory "doc_dir/" of this
!# code.
!# 
!# As a counterpart to the access to the source code and to the rights to copy,
!# modify and redistribute it granted by the license, users are provided only
!# with a limited warranty, and the software's author, the holder of the
!# economic rights, and the successive licensors have only limited
!# liability. 
!# 
!# The fact that you are presently reading this means that you have had
!# knowledge of the CeCILL license and that you accept its terms.
!#====================================================================== 

module mod_black_body
  
  private
  public :: pi_B_lambda
  
contains

!#======================================================================
  elemental function pi_B_lambda(T, lambda) 
!# `pi_B_lambda` in erg.s-1.um-1.cm-2 (um-1 for the wavelength, cm-2 for the surface).
!# `lambda` in um. `T` in kelvins.
    
    use mod_types
    use mod_constants, only : h_Planck, c_um, kB, pi, per_um_to_per_cm

    implicit none
    real(CDR), intent(in) :: T, lambda
    real(CDR) :: pi_B_lambda
!#......................................................................
    real(CDR) :: x, x_max
!#::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    x_max = log(huge(1._CDR))
    
    x = h_Planck*c_um/lambda/kB/T
    if (x < x_max) then
       pi_B_lambda = 2*pi*h_Planck*c_um**2/lambda**5/(exp(x)-1) &
            * per_um_to_per_cm**2
    else
       pi_B_lambda = 0
    endif
    
  end function pi_B_lambda
  
end module mod_black_body
