!# This source file is part of code Pégase.3.0.1 (2019-02-21).
!# Copyright: Michel Fioc (Michel.Fioc@iap.fr), Sorbonne université, 
!# Institut d'astrophysique de Paris/CNRS, France.
!# 
!# Pégase.3.0.1 is governed by the CeCILL license under French law and abides 
!# by the rules of distribution of free software. You can use, modify and/or 
!# redistribute this software under the terms of the CeCILL license as circulated 
!# by CEA, CNRS and INRIA at "http://www.cecill.info". The text of this license
!# is also available in French and in English in directory "doc_dir/" of this
!# code.
!# 
!# As a counterpart to the access to the source code and to the rights to copy,
!# modify and redistribute it granted by the license, users are provided only
!# with a limited warranty, and the software's author, the holder of the
!# economic rights, and the successive licensors have only limited
!# liability. 
!# 
!# The fact that you are presently reading this means that you have had
!# knowledge of the CeCILL license and that you accept its terms.
!#====================================================================== 

module mod_SSPs_constants

  use mod_types
  
  implicit none
  private

  character(len=std_string), parameter, public :: &
       tracks_sets_list = "list_tracks_sets.txt", &
       SSPs_ages_list = "list_SSPs_ages.txt", &
       yields_list = "list_yields.txt"

!# Bin size, in log10 of the stellar mass, used to compute the ejecta of SSPs.
  real(DPR), parameter, public :: d_l10_m_ejec = 0.01_DPR

!# Bin sizes in log10 of the {stellar mass / effective temperature / bolometric
!# luminosity} used to subdivide the isochrones.
  real(DPR), parameter, public :: d_l10_m_isoch = 0.01_DPR, &
       d_T_isoch = 0.01_DPR, d_L_isoch = 0.01_DPR

!# Minimal mass (primary + secundary) a close binary system must have to produce 
!# an SNIa (Matteucci & Greggio 86).
  real(DPR), parameter, public :: min_mass_SNIa = 3._DPR

!# Exponent of the mass-ratio function of close binary stars (MG86).
  real(DPR), parameter, public :: close_bin_gamma = 2._DPR

!# Indicative value of the bin size in `mu` used for the mass ratio of binary stars:
  real(DPR), parameter, public :: d_mu0 = 1.e-3_DPR

!# Default lower and upper values of the initial stellar mass (in solar masses):
  real(DPR), parameter, public :: default_IMF_mass_min = 0.08_DPR
  real(DPR), parameter, public :: default_IMF_mass_max = 120._DPR

!# Default values of `LN_C1` and `LN_C2` used for the log-normal IMF:
  real(DPR), parameter, public :: default_LN_C1 = 1.09_DPR
  real(DPR), parameter, public :: default_LN_C2 = -1.02_DPR

!# Indicative value of the bin size in log10(stellar mass) used for the IMF:
  real(DPR), parameter, public :: d_l10_mass0 = 1.e-3_DPR

!# Parameter used to exclude stars with too different a temperature when interpolating
!# the library of stellar spectra:
  real(DPR), parameter, public :: d_T_max_SL = 0.1_DPR

!# Relative importance of surface gravity to effective temperature when looking for
!# the nearest neighbors in the library of stellar spectra:
  real(DPR), parameter, public :: kappa_SL = 0.1_DPR

  character(len=std_string), parameter, public :: &
       SSPs_sets_list = "list_SSPs_sets.txt", stel_lib_sets_list = "list_stel_lib_sets.txt"

!#----------------------------------------------------------------------
!# Relation used to convert between the mass fraction of metals $Z$ used in stellar
!# evolutionary tracks and the parameter $[M/H]$ (more accurately, $[Fe/H]$) 
!# characterizing the metallicity of libraries of stellar spectra: {

  logical, parameter, public :: P2_metal_conv = .false. !# `.false.` = default in Pégase.3; \
!# set `P2_metal_conv` to `.true.` to recover Pégase.2's results.
  
  real(DPR), parameter, public :: P2_Z_Sun = 0.02_DPR !# Solar metallicity used in Pégase.2.

!# Explanations:
!# With `P2_metal_conv = .false.`, the track's mass fraction `Z_track` of metals 
!# is converted to $[M/H]$ through the relation
!#
!#     $[M/H] = `log10((Z_track/X_track)/(Z_Sun/X_Sun))`$,
!#
!# where `X_track = 1 - Y_track - Z_track` is the mass fraction of hydrogen,
!# and `Y_track` is the mass fraction of helium (provided with the stellar evolutionary tracks);
!# `Z_Sun` and `X_Sun` are the solar abundances used everywhere in the code.
!# The track's value of $[M/H]$ is then used to interpolate between the libraries of 
!# stellar spectra (which actually provide $[Fe/H]$).
!#
!# On the other hand, version 2 of Pégase converted the $[M/H]$ of the spectra to $Z$ 
!# through the relation
!#
!#     `Z = P2_Z_Sun * 10.**($[M/H]$)`,
!#
!# where `P2_Z_Sun` is the value of the solar metallicity hard-coded in Pégase.2.
!# This formula does not take into account the helium abundance and is incorrect.
!# To use it nonetheless, set `P2_metal_conv = .true`.

end module mod_SSPs_constants
