!# This source file is part of code Pégase.3.0.1 (2019-02-21).
!# Copyright: Michel Fioc (Michel.Fioc@iap.fr), Sorbonne université, 
!# Institut d'astrophysique de Paris/CNRS, France.
!# 
!# Pégase.3.0.1 is governed by the CeCILL license under French law and abides 
!# by the rules of distribution of free software. You can use, modify and/or 
!# redistribute this software under the terms of the CeCILL license as circulated 
!# by CEA, CNRS and INRIA at "http://www.cecill.info". The text of this license
!# is also available in French and in English in directory "doc_dir/" of this
!# code.
!# 
!# As a counterpart to the access to the source code and to the rights to copy,
!# modify and redistribute it granted by the license, users are provided only
!# with a limited warranty, and the software's author, the holder of the
!# economic rights, and the successive licensors have only limited
!# liability. 
!# 
!# The fact that you are presently reading this means that you have had
!# knowledge of the CeCILL license and that you accept its terms.
!#====================================================================== 

!# This file is included in "colors.f90". To change the output of code "colors",
!# edit the present file as explained in the comments below, and compile the 
!# code in "bin_dir/" with the `Make` command.
!#
!# Notations:
!# -- `xxx`: code segment;
!# -- ^yyy^: metasyntactic variable (= placeholder: ^yyy^ must be replaced by an actual quantity).
!#
!# The output consists in a series of tables written in the output file. 
!# Each table provides several quantities, one per column, as a function of 
!# the age (in Myr; automatically written at the beginning of each line).
!# You may add other quantities to any table; you may also create a new table.
!# 
!# For each quantity (except the age), the subroutine `add_column` must be called like this:
!#
!#   `call add_column(^column_heading^, ^column^, ^fmt_col^)`,
!#
!# where the string ^column_heading^ is the heading which will be
!# automatically written at the top of each column,
!# ^column^ is an array of reals containing the quantity,
!# and the optional string ^fmt_col^ is the Fortran-style format of the quantity for this column.
!#
!# Once a table is complete, the statement 
!#
!#   `call write_table`
!#
!# writes the table in the output file.
!#
!# The quantities `data % ^quantity^` are directly read from the input file 
!# produced by "spectra". 
!#
!# To write absolute magnitudes in a given filter, type
!#
!#   `call add_column(^column_heading^, magnit(^filter_id^), ^fmt_col^)`,
!#
!# where the string ^filter_id^ is the name of the filter.
!#
!# To write the intrisic luminosity through this filter, replace `magnit` by `lum_band`.
!# For the intrisic luminosity normalized to the solar luminosity in the same filter,
!# use `lum_band_rel_Sun` instead.
!#
!# To write the color `magnit(^filter1_id^) - magnit(^filter2_id^)`, type
!#
!#   `call add_column(^column_heading^, color(^filter1_id^, ^filter2_id^), ^fmt_col^)`.
!#
!# To write the luminosity of a given emission line, type
!#
!#   `call add_column(^column_heading^, L_line(^line_id^), ^fmt_col^)`,
!#
!# where the string ^line_id^ is the name of the line.
!#
!# To write the equivalent width of this line, replace `L_line` by `eq_width`.
!#
!# The functions `magnit`, etc., produce an array containing the quantity for all ages.
!# To get the quantity at the `i_output_age`-th age, type
!#
!#   `magnit(i_output_age, ^filter_id^)`, 
!#   `color(i_output_age, ^filter1_id^, ^filter2_id^)`, 
!#
!# etc.

  call add_column("M_gal", data % galaxy_mass, "es8.2")
  call add_column("M_*", data % live_stars_mass, "es8.2")
  call add_column("M_WD", data % WD_mass, "es8.2")
  call add_column("M_BHNS", data % BHNS_mass, "es8.2")
  call add_column("M_inert", data % inert_mass, "es8.2")
  call add_column("M_ISM", data % ISM_mass, "es8.2")
  call add_column("Z_ISM", data % ISM_Z, "es8.2")
  call add_column("<Z*>_mass", data % stel_Z_mass_avrg, "es8.2")
  call add_column("<Z*>_bol", data % stel_Z_bol_avrg, "es8.2")
  call write_table

  call add_column("He", ISM_abund("He"), "es8.2")
  call add_column("O", ISM_abund("O"), "es8.2")
  call add_column("Fe", ISM_abund("Fe"), "es8.2")
  call add_column("C", ISM_abund("C"), "es8.2")
  call add_column("N", ISM_abund("N"), "es8.2")
  call add_column("alpha\O", ISM_abund("Ne")+ISM_abund("Mg")+ISM_abund("Si") &
       +ISM_abund("S")+ISM_abund("Ca"), "es8.2")
  call write_table

  call add_column("L_bol", data % L_bol, "es8.2")
  call add_column("tau_V", data % tau_V, "es8.2")
  call add_column("L_dust/L_bol", data % L_dust, "es8.2")
  call add_column("SFR", data % SF_rate, "es8.2")
  call add_column("CCSN rate", data % CCSN_rate, "es8.2")
  call add_column("SNIa rate", data % SNIa_rate, "es8.2")
  call add_column("<t*>_mass", data % stel_age_mass_avrg, "es8.2")
  call add_column("<t*>_bol", data % stel_age_bol_avrg, "es8.2")
  call add_column("M*/L_K", data % live_stars_mass / lum_band_rel_Sun("K"), "es8.2")
  call write_table

  call add_column("LC rate", data % Lyman_cont_rate, "es8.2")
  call add_column("L(H_alpha)", L_line("H_I__6564.62_A"), "es8.2")
  call add_column("EW(H_alpha)", eq_width("H_I__6564.62_A"), "es8.2")
  call add_column("L(H_beta)", L_line("H_I__4862.69_A"), "es8.2")
  call add_column("EW(H_beta)", eq_width("H_I__4862.69_A"), "es8.2")
  call add_column("L_V/L_V(Sun)", lum_band_rel_Sun("V_BK78"), "es8.2")
  call add_column("L_B/L_B(Sun)", lum_band_rel_Sun("B3_BK78"), "es8.2")
  call add_column("D4000", D4000, "es8.2")
  call add_column("Dn4000", Dn4000, "es8.2")
  call write_table

  call add_column("M_bol", M_bol, "f7.3")
  call add_column("V", magnit("V_BK78"), "f7.3")
  call add_column("U-B", color("U3_BK78", "B2_BK78"), "f7.3")
  call add_column("B-V", color("B3_BK78", "V_BK78"), "f7.3")
  call add_column("V-K", color("V_BK78", "K"), "f7.3")
  call add_column("V-R_C", color("V_BK78", "RC"), "f7.3")
  call add_column("V-I_C", color("V_BK78", "IC"), "f7.3")
  call add_column("J-H", color("J", "H"), "f7.3")
  call add_column("H-K", color("H", "K"), "f7.3")
  call write_table

  call add_column("K-L", color("K", "L"), "f7.3")
  call add_column("L-M", color("L", "M"), "f7.3")
  call add_column("V-R_J", color("V_BK78", "RJ"), "f7.3")
  call add_column("V-I_J", color("V_BK78", "IJ"), "f7.3")
  call add_column("JK-V", color("JK", "V_BK78"), "f7.3")
  call add_column("U_K-J_K", color("UK", "JK"), "f7.3")
  call add_column("J_K-F_K", color("JK", "FK"), "f7.3")
  call add_column("F_K-N_K", color("FK", "NK"), "f7.3")
  call add_column("2000-V", color("2000", "V_BK78"), "f7.3")
  call write_table

  call add_column("V-I_D", color("V_BK78", "ID"), "f7.3")
  call add_column("I_D-J_D", color("ID", "JD"), "f7.3")
  call add_column("J_D-K_D", color("JD", "KD"), "f7.3")
  call add_column("B_J-V", color("BJ", "V_BK78"), "f7.3")
  call add_column("B_J-R_F", color("BJ", "RF"), "f7.3")
  call add_column("V-606", color("V_BK78", "606"), "f7.3")
  call add_column("300-450", color("300", "450"), "f7.3")
  call add_column("450-606", color("450", "606"), "f7.3")
  call add_column("606-814", color("606", "814"), "f7.3")
  call write_table

  call add_column("u'-g'", color("u'", "g'"), "f7.3")
  call add_column("g'-r'", color("g'", "r'"), "f7.3")
  call add_column("V-r'", color("V_BK78", "r'"), "f7.3")
  call add_column("r'-i'", color("r'", "i'"), "f7.3")
  call add_column("i'-z'", color("i'", "z'"), "f7.3")
  call add_column("u-v", color("u", "v"), "f7.3")
  call add_column("v-g", color("v", "g"), "f7.3")
  call add_column("g-V", color("g", "V_BK78"), "f7.3")
  call add_column("g-r", color("g", "r"), "f7.3")
  call write_table

  call add_column("1650-B", color("1650", "B3_BK78"), "f7.3")
  call add_column("1650-2500", color("1650", "2500"), "f7.3")
  call add_column("3150-B", color("3150", "B3_BK78"), "f7.3")
  call add_column("log_10(12/25)", log10(lum_band("IRAS12")/lum_band("IRAS25")), "f7.3")
  call add_column("log_10(25/60)", log10(lum_band("IRAS25")/lum_band("IRAS60")), "f7.3")
  call add_column("log_10(60/100)", log10(lum_band("IRAS60")/lum_band("IRAS100")), "f7.3")
  call write_table

  call add_column("(u-g)_SDSS", color("u_SDSS", "g_SDSS"), "f7.3")
  call add_column("(g-r)_SDSS", color("g_SDSS", "r_SDSS"), "f7.3")
  call add_column("(r-i)_SDSS", color("r_SDSS", "i_SDSS"), "f7.3")
  call add_column("(g-r)_SDSS", color("i_SDSS", "z_SDSS"), "f7.3")
  call write_table
