!# With "example_read_spectra.f90" in "source_dir/", type for instance
!# ''gfortran -o example_read_spectra ../util_dir/mod_types.f90 ../util_dir/mod_dir_access.f90 ../util_dir/mod_file_access.f90 ../util_dir/mod_strings.f90 ../source_dir/mod_directories.f90 ../source_dir/mod_read_spectra_output.f90 ../source_dir/example_read_spectra.f90''
!# (without quotation marks!) to compile it from within "bin_dir/" 
!# with `gfortran`.

program example_read_spectra

  use mod_read_spectra_output
  implicit none
  type(struct_spectra_output), dimension(2) :: data
  integer :: i, j, k

  call read_spectra_output("example_spectra1.txt", data(1))
  call read_spectra_output("spectra2.txt", data(2))
  do j = 1, data(1) % dim_output_age
     write(*,*) "Wavelength, monochromatic luminosities in &
          &''example_spectra1.txt'' and ''example_spectra2.txt'' &
          &at age = ", data(1) % output_age(j), ":"
     do k = 1, data(1) % dim_cont
        write(*,*) data(1) % lambda_cont(k), (data(i) % lum_cont(j, k), i = 1, 2)
     enddo
  enddo

end program example_read_spectra
