#!/usr/bin/env python
# -*- coding: utf-8 -*-
##********************************************************************************************************************************************************
##
##
##  Script for testing the new myXCLASS functions for CASA
##  Copyright (C) 2012 - 2016  Thomas Moeller
##
##  I. Physikalisches Institut, University of Cologne
##
##
##
##  Versions of the program:
##
##  Who           When         What
##
##  T. Moeller    29.03.2014   initial version
##  T. Moeller    14.07.2015   improved version
##
##
##
##  License:
##
##    GNU GENERAL PUBLIC LICENSE
##    Version 3, 29 June 2007
##    (Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>)
##
##
##    This program is free software: you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation, either version 3 of the License, or
##    (at your option) any later version.
##
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with this program.  If not, see <http://www.gnu.org/licenses/>.
##
##********************************************************************************************************************************************************


##--------------------------------------------------------------------------------------------------------------------------------------------------------
import os                                                                                   ## import os package
import sys                                                                                  ## import sys package
import numpy                                                                                ## import numpy package
##--------------------------------------------------------------------------------------------------------------------------------------------------------


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## define complexity of tests
CheckFunctionalityFlag = True
DoCompleteCheckFlag = True


##========================================================================================================================================================
## do functionality check
if (CheckFunctionalityFlag):


    ##----------------------------------------------------------------------------------------------------------------------------------------------------
    ## test DatabaseQuery function
    print "\n\n\nTesting DatabaseQuery function:\n\n\n"
    QueryString = "select PF_Name from Partitionfunctions"
    Contents = DatabaseQuery()


    ##----------------------------------------------------------------------------------------------------------------------------------------------------
    ## test ListDatabase function
    print "##############################################################################################################################################"
    print "##############################################################################################################################################"
    print "\n\n\nTesting ListDatabase function:\n\n\n"
    print "\n\n\n\nExample 1:"
    print "----------"
    FreqMin = 20000.0
    FreqMax = 20100.0
    ElowMin = 100.0
    ElowMax = 1000.0
    SelectMolecule = "demo/ListDatabase/molecules.txt"
    OutputDevice = ""
    Contents = ListDatabase()


    print "\n\n\n\nExample 2:"
    print "----------"
    FreqMin = 20000.0
    FreqMax = 20100.0
    ElowMin = 100.0
    ElowMax = 2000.0
    SelectMolecule = []
    OutputDevice = ""
    Contents = ListDatabase()


    ##----------------------------------------------------------------------------------------------------------------------------------------------------
    ## test MAGIX function
    print "##############################################################################################################################################"
    print "##############################################################################################################################################"
    print "\n\n\nTesting function MAGIX:\n\n\n"
    MAGIXExpXML = "demo/MAGIX/TwoOscillators_RefFit_R.xml"
    MAGIXInstanceXML = "demo/MAGIX/parameters.xml"
    MAGIXFitXML = "demo/MAGIX/Levenberg-Marquardt_Parameters.xml"
    MAGIXRegXML = "Fit-Functions/Drude-Lorentz_conv/xml/Conventional_Drude-Lorentz.xml"
    MAGIXOption = ""
    JobDir = MAGIX()


    ##----------------------------------------------------------------------------------------------------------------------------------------------------
    ## test myXCLASS function
    print "##############################################################################################################################################"
    print "##############################################################################################################################################"
    print "\n\n\nTesting function myXCLASS:\n\n\n"
    FreqMin = 580102.0
    FreqMax = 580546.5
    FreqStep = 5.0000000000E-01
    MolfitsFileName = "demo/myXCLASS/CH3OH__pure.molfit"
    TelescopeSize = 3.5
    Inter_Flag = F
    t_back_flag = T
    tBack = 1.1
    tslope = 0.0000000000E+00
    nH_flag = T
    N_H = 3.0000000000E+24
    N_H = 0.0
    beta_dust = 2.0
    kappa_1300 = 0.02
    iso_flag = F
    IsoTableFileName = ""
    RestFreq = 0.0
    vLSR = 0.0
    modeldata, log, TransEnergies, IntOptical, JobDir = myXCLASS()

    FileName = "demo/myXCLASS/band1b.dat"
    NumHeaderLines = 0
    expdata = LoadASCIIFile()

    MinTransEnergy = 0.0
    xLowerLimit = 578000.5
    xUpperLimit = 582000.5
    yLowerLimit = 0.8
    yUpperLimit = 2.5
    PlotTitle = "Example for myXCLASSPlot function"
    LegendFlag = T
    SaveFigureFile = ""
    # myXCLASSPlot()


    ##----------------------------------------------------------------------------------------------------------------------------------------------------
    ## test myXCLASSFit function
    print "##############################################################################################################################################"
    print "##############################################################################################################################################"
    print "\n\n\nTesting function myXCLASSFit:\n\n\n"


    ##----------------------------------------------------------------------------------------------------------------------------------------------------
    ## test myXCLASSFit function
    print "\n\n\n\nExample using a molfit file in the old format and an ASCII file containing the experimental data:"
    print "-------------------------------------------------------------------------------------------------"

    NumberIteration = 10
    AlgorithmXMLFile = ""
    MolfitsFileName = "demo/myXCLASSFit/CH3OH__old.molfit"
    experimentalData = "demo/myXCLASSFit/band1b.dat"
    TelescopeSize = 3.5
    Inter_Flag = F
    t_back_flag = T
    tBack = 1.1
    tslope = 0.0000000000E+00
    nH_flag = T
    N_H = 3.0000000000E+24
    beta_dust = 2.0
    kappa_1300 = 0.02
    iso_flag = F
    IsoTableFileName = ""
    RestFreq = 0.0
    vLSR = 0.0
    newmolfit, modeldata, JobDir = myXCLASSFit()


    print "\n\n\n\nExample with MAGIX xml files (old format):"
    print "-------------------------------------------------"

    NumberIteration = 10
    MolfitsFileName = "demo/myXCLASSFit/CH3OH__old.molfit"
    experimentalData = "demo/myXCLASSFit/observation.xml"
    newmolfit, modeldata, JobDir = myXCLASSFit()


    print "\n\n\n\nExample with MAGIX xml files (new format):"
    print "-------------------------------------------------"

    NumberIteration = 10
    MolfitsFileName = "demo/myXCLASSFit/CH3OH__new.molfit"
    experimentalData = "demo/myXCLASSFit/observation.xml"
    newmolfit, modeldata, JobDir = myXCLASSFit()


    print "\n\n\n\nExample with MAGIX xml files (other algorithm):"
    print "------------------------------------------------------"

    MolfitsFileName = "demo/myXCLASSFit/CH3OH__new.molfit"
    experimentalData = "demo/myXCLASSFit/observation.xml"
    AlgorithmXMLFile = "demo/myXCLASSFit/algorithm-settings.xml"
    newmolfit, modeldata, JobDir = myXCLASSFit()


    ##----------------------------------------------------------------------------------------------------------------------------------------------------
    ## test myXCLASSMapFit function
    print "##############################################################################################################################################"
    print "##############################################################################################################################################"
    print "\n\n\n\n\n\n\nTesting function myXCLASSMapFit:\n\n\n"
    NumberIteration = 15
    AlgorithmXMLFile = "demo/myXCLASSMapFit/algorithm-settings.xml"
    MolfitsFileName = "demo/myXCLASSMapFit/CH3OH__new.molfit"
    experimentalData = "demo/myXCLASSMapFit/Orion.methanol.cbc.contsub.image.fits"
    regionFileName = "demo/myXCLASSMapFit/ds9_phys.reg"

    FreqMin = 0.0
    FreqMax = 0.0
    TelescopeSize = 3.5
    Inter_Flag = F
    t_back_flag = T
    tBack = 9.5000000000E-01
    tslope = 0.0000000000E+00
    nH_flag = T
    N_H = 3.0000000000E+24
    beta_dust = 1.4
    kappa_1300 = 0.02
    iso_flag = F
    IsoTableFileName = ""
    RestFreq = 0.0
    vLSR = 0.0
    Threshold = 0.0
    UsePreviousResults = F
    clusterdef = "demo/myXCLASSMapFit/clusterdef.txt"
    JobDir = myXCLASSMapFit()


##========================================================================================================================================================
## do complete test
if (DoCompleteCheckFlag):


    ##----------------------------------------------------------------------------------------------------------------------------------------------------
    ## Check MAGIX function


    ## define list of paths and scripts for MAGIX tests
    MAGIXTestsPathLists = ["real-fits/test-functions/MAGIX/test__MAGIX____demo/", "real-fits/test-functions/MAGIX/test__MAGIX____gDL/"]
    MAGIXTestsScriptLists = ["test__MAGIX____demo.py", "test__MAGIX____gDL.py"]


    ## do MAGIX checks
    print "\n\n"
    for i in xrange(len(MAGIXTestsPathLists)):
        testCase = MAGIXTestsScriptLists[i].replace(".py", "")
        print "\tDo MAGIX check " + testCase + " ..",
        sys.stdout.flush()
        cmdString = "cd " + MAGIXTestsPathLists[i] + "; "
        cmdString += "python " + MAGIXTestsScriptLists[i] + " > screen.out"
        os.system(cmdString)


        ## are results identical with previous results?
        if (os.path.isfile("comparison.txt")):
            print "done.  Results are  N O T  identical to previous results."
        else:
            print "done.  Results are  I D E N T I C A L  to previous results."


        ## remove log file    
        cmdString = "cd " + MAGIXTestsPathLists[i] + "; rm -rf comparison.txt screen.out *.log *.last; cd ../../../../"
        os.system(cmdString)


    ##----------------------------------------------------------------------------------------------------------------------------------------------------
    ## Check myXCLASS function


    ## define list of paths and scripts for myXCLASS tests
    myXCLASSTestsPathLists = ["real-fits/test-functions/myXCLASS/test___ArH+_check/", "real-fits/test-functions/myXCLASS/test___demo-from-manual/", \
                              "real-fits/test-functions/myXCLASS/test___different_molfit-formats/", \
                              "real-fits/test-functions/myXCLASS/test___multiple_molecule_definitions/", \
                              "real-fits/test-functions/myXCLASS/test___no-iso_and_with-iso/"]
    myXCLASSTestsScriptLists = ["test__myXCLASS____ArH+_check.py", "test__myXCLASS____demo-from-manual.py", \
                                "test__myXCLASS____different_molfit-formats.py", "test__myXCLASS____multiple_molecule_definitions.py", \
                                "test__myXCLASS____no-iso_and_with-iso.py"]


    ## do myXCLASS checks
    print "\n\n"
    for i in xrange(len(myXCLASSTestsPathLists)):
        testCase = myXCLASSTestsScriptLists[i].replace(".py", "")
        print "\tDo myXCLASS check " + testCase + " ..",
        sys.stdout.flush()
        cmdString = "cd " + myXCLASSTestsPathLists[i] + "; "
        cmdString += "python " + myXCLASSTestsScriptLists[i] + " > screen.out"
        os.system(cmdString)


        ## are results identical with previous results?
        if (os.path.isfile("comparison.txt")):
            print "done.  Results are  N O T  identical to previous results."
        else:
            print "done.  Results are  I D E N T I C A L  to previous results."


        ## remove log file    
        cmdString = "cd " + myXCLASSTestsPathLists[i] + "; rm -rf comparison.txt screen.out *.log *.last; cd ../../../../"
        os.system(cmdString)


    ##----------------------------------------------------------------------------------------------------------------------------------------------------
    ## Check myXCLASSFit function


    ## define list of paths and scripts for myXCLASSFit tests
    myXCLASSFitTestsPathLists = ["real-fits/test-functions/myXCLASSFit/test___ArH+_fit/", \
                                 "real-fits/test-functions/myXCLASSFit/test___demo-from-manual/", \
                                 "real-fits/test-functions/myXCLASSFit/test___demo-from-manual___SA/", \
                                 "real-fits/test-functions/myXCLASSFit/test___dust-continuum-fit", \
                                 "real-fits/test-functions/myXCLASSFit/test___myXCLASS+myXCLASSFit____Compare"]
    myXCLASSFitTestsScriptLists = ["test__myXCLASSFit____ArH+_fit.py", "test__myXCLASSFit____demo-from-manual.py", \
                                   "test__myXCLASSFit____demo-from-manual__SA.py", "test__myXCLASSFit____dust-continuum-fit.py",
                                   "test___myXCLASS+myXCLASSFit____Compare.py"]


    ## do myXCLASSFit checks
    print "\n\n"
    for i in xrange(len(myXCLASSFitTestsPathLists)):
        testCase = myXCLASSFitTestsScriptLists[i].replace(".py", "")
        print "\tDo myXCLASSFit check " + testCase + " ..",
        sys.stdout.flush()
        cmdString = "cd " + myXCLASSFitTestsPathLists[i] + "; "
        cmdString += "python " + myXCLASSFitTestsScriptLists[i] + " > screen.out"
        os.system(cmdString)


        ## are results identical with previous results?
        if (os.path.isfile("comparison.txt")):
            print "done.  Results are  N O T  identical to previous results."
        else:
            print "done.  Results are  I D E N T I C A L  to previous results."


        ## remove log file    
        cmdString = "cd " + myXCLASSFitTestsPathLists[i] + "; rm -rf comparison.txt screen.out *.log *.last; cd ../../../../"
        os.system(cmdString)


    ##----------------------------------------------------------------------------------------------------------------------------------------------------
    ## Check myXCLASSMapFit function


    ## define list of paths and scripts for myXCLASSMapFit tests
    myXCLASSMapFitTestsPathLists = ["real-fits/test-functions/myXCLASSMapFit/test__myXCLASSMapFit____demo/"]
    myXCLASSMapFitTestsScriptLists = ["test__myXCLASSMapFit____demo.py"]


    ## do myXCLASSMapFit checks
    print "\n\n"
    for i in xrange(len(myXCLASSMapFitTestsPathLists)):
        testCase = myXCLASSMapFitTestsScriptLists[i].replace(".py", "")
        print "\tDo myXCLASSMapFit check " + testCase + " ..",
        sys.stdout.flush()
        cmdString = "cd " + myXCLASSMapFitTestsPathLists[i] + "; "
        cmdString += "python " + myXCLASSMapFitTestsScriptLists[i] + " > screen.out"
        os.system(cmdString)


        ## are results identical with previous results?
        if (os.path.isfile("comparison.txt")):
            print "done.  Results are  N O T  identical to previous results."
        else:
            print "done.  Results are  I D E N T I C A L  to previous results."


        ## remove log file    
        cmdString = "cd " + myXCLASSMapFitTestsPathLists[i] + "; rm -rf comparison.txt screen.out *.log *.last; cd ../../../../"
        os.system(cmdString)


    ##----------------------------------------------------------------------------------------------------------------------------------------------------
    ## Check LineID function


    ## define list of paths and scripts for LineID tests
    LineIDTestsPathLists = ["real-fits/test-functions/LineIdentification/test__LineIdentification____demo/"]

    LineIDTestsScriptLists = ["test__LineIdentification____demo.py"]


    ## do LineID checks
    print "\n\n"
    for i in xrange(len(LineIDTestsPathLists)):
        testCase = LineIDTestsScriptLists[i].replace(".py", "")
        print "\tDo LineID check " + testCase + " ..",
        sys.stdout.flush()
        cmdString = "cd " + LineIDTestsPathLists[i] + "; "
        cmdString += "python " + LineIDTestsScriptLists[i] + " > screen.out"
        os.system(cmdString)


        ## are results identical with previous results?
        if (os.path.isfile("comparison.txt")):
            print "done.  Results are  N O T  identical to previous results."
        else:
            print "done.  Results are  I D E N T I C A L  to previous results."


        ## remove log file    
        cmdString = "cd " + LineIDTestsPathLists[i] + "; rm -rf comparison.txt screen.out *.log *.last; cd ../../../../"
        os.system(cmdString)




