#!/usr/bin/python
# -*- coding: utf-8 -*-
##********************************************************************************************************************************************************
##
##  test-routine:   Check myXCLASSMapFit function with files in demo directory
##
##
##
##
##  Copyright (C) 2015 - 2016
##
##  I. Physikalisches Institut, University of Cologne
##
##
##
##  Who           When         What
##
##  T. Moeller    27.03.2015   initial version
##
##********************************************************************************************************************************************************


##********************************************************************* load packages ********************************************************************
import numpy                                                                                ## import numpy package
import os                                                                                   ## import os package
import sys                                                                                  ## import sys package
##--------------------------------------------------------------------------------------------------------------------------------------------------------


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## define current working directory
LocalPath = os.getcwd() + "/"


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## extend sys.path variable, if necessary
XCLASSBaseDir = LocalPath + "../../../../"
XCLASSBaseDir = os.path.normpath(XCLASSBaseDir) + "/"
CASAFlag = True
try:
    # import taskinit
    tasklist()
    import myXCLASSMapFit as task_myXCLASSMapFit
except:
    CASAFlag = False
    NewModulesPaths = [XCLASSBaseDir + "build_tasks/"]
    for NewModule in NewModulesPaths:
        already_included_flag = "false"
        for entries in sys.path:
            if (entries == NewModule):
                already_included_flag = "true"
                break
        if (already_included_flag == "false"):
            sys.path.append(NewModule)


    ## import module task_myXCLASSMapFit
    import task_myXCLASSMapFit


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## get command line argrument
UpdateFlag = False
if (len(sys.argv) > 1):                                                                     ## check, if command line arguments are defined
    for argument in sys.argv[1:]:                                                           ## loop over all command line arguments
        if (argument.lower() == "--update"):
            UpdateFlag = True
            break


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## general settings
CompareFlag = True
DiffTolerance = 1.e-3


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## define parameters for myXCLASSMapFit function
FreqMin = 0.0
FreqMax = 0.0
NumberIteration = 15
AlgorithmXMLFile = XCLASSBaseDir + "demo/myXCLASSMapFit/algorithm-settings.xml"
MolfitsFileName = XCLASSBaseDir + "demo/myXCLASSMapFit/CH3OH__new.molfit"
experimentalData = XCLASSBaseDir + "demo/myXCLASSMapFit/Orion.methanol.cbc.contsub.image.fits"
regionFileName = XCLASSBaseDir + "demo/myXCLASSMapFit/ds9_phys.reg"
# regionFileName = ""
TelescopeSize = 8.380979166667E+01
Inter_Flag = False
t_back_flag = True
tBack = 0.0
tslope = 0.0000000000E+00
nH_flag = True
N_H = 3.0000000000E+20
beta_dust = 1.4
kappa_1300 = 0.0
iso_flag = False
IsoTableFileName = ""
RestFreq = 0.0
vLSR = 0.0
Threshold = 1.4
UsePreviousResults = False
clusterdef = XCLASSBaseDir + "demo/myXCLASSMapFit/clusterdef.txt"


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## start myXCLASSMapFit function
JobDir = task_myXCLASSMapFit.myXCLASSMapFit(NumberIteration, AlgorithmXMLFile, MolfitsFileName, experimentalData, regionFileName, UsePreviousResults, \
                                            Threshold, FreqMin, FreqMax, TelescopeSize, Inter_Flag, t_back_flag, tBack, tslope, nH_flag, N_H, beta_dust, \
                                            kappa_1300, iso_flag, IsoTableFileName, RestFreq, vLSR, clusterdef)


##========================================================================================================================================================
##
## FOR TESTING: Compare result with previous results
##
##========================================================================================================================================================
if (CompareFlag):


    ## print what you do
    print "\n\nCompare result with previous results for .."


    ##----------------------------------------------------------------------------------------------------------------------------------------------------
    ## read in the different parameter maps and compare with previous results
    UnequalPointCounter = 0
    HDU = 0
    print_flag = "false"


    ## define names of files containing maps
    FileList = ["BestResult___chi2values.fits", "BestResult___parameter__N_tot___molecule__CH3OH_v=0____component__1.fits", \
                "BestResult___parameter__source_size___molecule__CH3OH_v=0____component__1.fits", \
                "BestResult___parameter__T_rot___molecule__CH3OH_v=0____component__1.fits", \
                "BestResult___parameter__V_off___molecule__CH3OH_v=0____component__1.fits", \
                "Orion.methanol.cbc.contsub.image___model-function-values.fits", \
                "BestResult___parameter__V_width___molecule__CH3OH_v=0____component__1.fits"]


    ## check maps
    for files in FileList:


        ## read in map form job directory
        DataCubeFile = JobDir + files
        ok, NumDimensionsLocal1, lengthLocal1, lengthFITSDATALocal1, CParameterLocal1, BParameterLocal1, ValueOfFirstPointListLocal1, fitsdataLocal1 \
        = task_myXCLASSMapFit.LoadFits(DataCubeFile, HDU, print_flag)


        ## read in "reference_run/BestResult___chi2values.fits
        DataCubeFile = LocalPath + "reference_run/" + files
        ok, NumDimensionsLocal2, lengthLocal2, lengthFITSDATALocal2, CParameterLocal2, BParameterLocal2, ValueOfFirstPointListLocal2, fitsdataLocal2 \
        = task_myXCLASSMapFit.LoadFits(DataCubeFile, HDU, print_flag)


        # Debug:
        #    print "NumDimensionsLocal1 = ", NumDimensionsLocal1
        #    print "NumDimensionsLocal2 = ", NumDimensionsLocal2
        #    print "lengthLocal1 = ", lengthLocal1
        #    print "lengthLocal2 = ", lengthLocal2
        #    print "lengthFITSDATALocal1 = ", lengthFITSDATALocal1
        #    print "lengthFITSDATALocal2 = ", lengthFITSDATALocal2
        #    print "CParameterLocal1 = ", CParameterLocal1
        #    print "CParameterLocal2 = ", CParameterLocal2
        #    print "BParameterLocal1 = ", BParameterLocal1
        #    print "BParameterLocal2 = ", BParameterLocal2
        #    print "ValueOfFirstPointListLocal1 = ", ValueOfFirstPointListLocal1
        #    print "ValueOfFirstPointListLocal2 = ", ValueOfFirstPointListLocal2
        #    print "fitsdataLocal1 = ", fitsdataLocal1
        #    print "fitsdataLocal2 = ", fitsdataLocal2


        ## compare data sets
        if (files == "Orion.methanol.cbc.contsub.image___model-function-values.fits"):
            for x in xrange(lengthLocal1[0]):
                for y in xrange(lengthLocal1[1]):
                    for z in xrange(lengthLocal1[2]):
                        if (lengthFITSDATALocal1 == lengthLocal1):
                            intensity1 = fitsdataLocal1[x, y, z]
                        else:
                            intensity1 = fitsdataLocal1[z, y, x]
                        if (lengthFITSDATALocal2 == lengthLocal2):
                            intensity2 = fitsdataLocal2[x, y, z]
                        else:
                            intensity2 = fitsdataLocal2[z, y, x]
                        if (abs(intensity1 - intensity2) > DiffTolerance):
                            UnequalPointCounter += 1

                            print "\t\tUnequal results:"
                            print "\t\tintensity1 = ", intensity1
                            print "\t\tintensity2 = ", intensity2
                            print "------------------------------------------------------------------"
        else:
            for x in xrange(lengthLocal1[0]):
                    for y in xrange(lengthLocal1[1]):
                        if (lengthFITSDATALocal1 == lengthLocal1):
                            intensity1 = fitsdataLocal1[x, y]
                        else:
                            intensity1 = fitsdataLocal1[y, x]
                        if (lengthFITSDATALocal2 == lengthLocal2):
                            intensity2 = fitsdataLocal2[x, y]
                        else:
                            intensity2 = fitsdataLocal2[y, x]

                        # Debug:
                        # print "x, y, abs(intensity1 - intensity2) = ", x, y, abs(intensity1 - intensity2)

                        if (abs(intensity1 - intensity2) > DiffTolerance):
                            UnequalPointCounter += 1

                            print "\t\tUnequal results:"
                            print "\t\tintensity1 = ", intensity1
                            print "\t\tintensity2 = ", intensity2
                            print "------------------------------------------------------------------"


    ## print something to screen
    print "\n\n\n\n"


    ## print final result of comparison
    if (not UpdateFlag):
        UpdateFlag = False
    if (UnequalPointCounter > 0):
        print "\n\n\n\tThe data sets are   N O T   identical!\n\n\n"
    else:
        print "\n\n\tResults are   I D E N T I C A L   to previous result!\n\n\n"
        UpdateFlag = True


        ## write status file for CASA
        if (CASAFlag):
            CASAFile = open("comparison.txt", 'w')
            CASAFile.write("identical\n")
            CASAFile.close()


## update reference directory
if (UpdateFlag):
    print "Update reference files ..",
    cmdString = "rm -rf " + LocalPath + "reference_run/*; cp -r " + JobDir + "/* " + LocalPath + "reference_run/; rm -rf " + JobDir
    os.system(cmdString)
    print "done!"



