#!/usr/bin/python
# -*- coding: utf-8 -*-
##********************************************************************************************************************************************************
##
##  test-routine:   Compare results from myXCLASS and myXCLASSFit functions
##
##
##
##
##  Copyright (C) 2015 - 2016
##
##  I. Physikalisches Institut, University of Cologne
##
##
##
##  Who           When         What
##
##  T. Moeller    21.03.2015   initial version
##
##********************************************************************************************************************************************************


##********************************************************************* load packages ********************************************************************
import numpy                                                                                ## import numpy package
import os                                                                                   ## import os package
import sys                                                                                  ## import sys package
import matplotlib                                                                           ## import matplotlib
import pylab                                                                                ## import pylab
##--------------------------------------------------------------------------------------------------------------------------------------------------------


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## define current working directory
LocalPath = os.getcwd() + "/"


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## extend sys.path variable, if necessary
XCLASSBaseDir = LocalPath + "../../../../"
XCLASSBaseDir = os.path.normpath(XCLASSBaseDir) + "/"
CASAFlag = True
try:
    # import taskinit
    tasklist()
    import myXCLASS as task_myXCLASS
    import myXCLASSFit as task_myXCLASSFit
    import MAGIX as task_MAGIX
    import LoadASCIIFile as task_LoadASCIIFile
except:
    CASAFlag = False
    NewModulesPaths = [XCLASSBaseDir + "build_tasks/"]
    for NewModule in NewModulesPaths:
        already_included_flag = "false"
        for entries in sys.path:
            if (entries == NewModule):
                already_included_flag = "true"
                break
        if (already_included_flag == "false"):
            sys.path.append(NewModule)


    ## import XCLASS, myXCLASSFit, MAGIX, and LoadASCIIFile modules
    import task_myXCLASS
    import task_myXCLASSFit
    import task_MAGIX
    import task_LoadASCIIFile


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## get command line argrument
UpdateFlag = False
if (len(sys.argv) > 1):                                                                     ## check, if command line arguments are defined
    for argument in sys.argv[1:]:                                                           ## loop over all command line arguments
        if (argument.lower() == "--update"):
            UpdateFlag = True
            break


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## general settings
DoPlotFlag = True
CompareFlag = True
DiffTolerance = 1.e-3


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## define some global parameters
ResultPath = "comparison/"
ExpXML = "exp__equal__stepsize__1MHz.xml"
MolfitsFileName = "Compare__myXCLASS+myXCLASSFit__1.molfit"


## create subdirectory for resulting files
os.system("rm -rf " + ResultPath + "; mkdir " + ResultPath)


## define some dummy parameters
TelescopeSize = 3.5
Inter_Flag = False
t_back_flag = True
tBack = 1.1
tslope = 0.0000000000E+00
nH_flag = True
N_H = 3.0000000000E+24
beta_dust = 2.0
kappa_1300 = 0.42
iso_flag = False
IsoTableFileName = ""
RestFreq = 0.0
vLSR = 0.0


##========================================================================================================================================================
##
## start myXCLASSFit function
##
##========================================================================================================================================================
NumberIteration = 1
AlgorithmXMLFile = ""
experimentalData = ExpXML


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## start myXCLASSFit function
print "Start myXCLASSFit function"
print "\n\n========================================================================================================================================="
newmolfit, modelmyXCLASSFit, JobDir = task_myXCLASSFit.myXCLASSFit(NumberIteration, AlgorithmXMLFile, MolfitsFileName, experimentalData, TelescopeSize, \
                                                                   Inter_Flag, t_back_flag, tBack, tslope, nH_flag, N_H, beta_dust, kappa_1300, \
                                                                   iso_flag, IsoTableFileName, RestFreq, vLSR)
cmdString = "rm -rf " + JobDir
os.system(cmdString)


##========================================================================================================================================================
##
## start myXCLASS function
##
##========================================================================================================================================================


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## get most of the input parameter from XML file
ExpFileList = task_MAGIX.GetXMLtag(ExpXML, "FileNamesExpFiles")
FreqMinList = task_MAGIX.GetXMLtag(ExpXML, "MinExpRange")
FreqMaxList = task_MAGIX.GetXMLtag(ExpXML, "MaxExpRange")
FreqStepList = task_MAGIX.GetXMLtag(ExpXML, "StepFrequency")
t_back_flagList = task_MAGIX.GetXMLtag(ExpXML, "t_back_flag")
tBackList = task_MAGIX.GetXMLtag(ExpXML, "BackgroundTemperature")
tslopeList = task_MAGIX.GetXMLtag(ExpXML, "TemperatureSlope")
N_HList = task_MAGIX.GetXMLtag(ExpXML, "HydrogenColumnDensity")
beta_dustList = task_MAGIX.GetXMLtag(ExpXML, "DustBeta")
kappa_1300List = task_MAGIX.GetXMLtag(ExpXML, "Kappa")
TelescopeSizeList = task_MAGIX.GetXMLtag(ExpXML, "TelescopeSize")
InterFlagList = task_MAGIX.GetXMLtag(ExpXML, "Inter_Flag")
IsotopologuesList = task_MAGIX.GetXMLtag(ExpXML, "Isotopologues")
IsoTableFileNameList = task_MAGIX.GetXMLtag(ExpXML, "IsoTableFileName")


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## call myXCLASS for each frequency range
for i in xrange(len(FreqMinList)):


    ## get name of current exp. data file
    HIFIBand = os.path.basename(ExpFileList[i])
    HIFIBand = HIFIBand.replace(".dat", "")


    ## get some parameters
    FreqMin = float(FreqMinList[i][1])
    FreqMax = float(FreqMaxList[i][1])
    FreqStep = float(FreqStepList[i][1])
    t_back_flag = t_back_flagList[i]
    tBack = float(tBackList[i][1])
    tslope = float(tslopeList[i][1])
    if (N_HList[i][1] != []):
        nH_flag = True
        N_H = float(N_HList[i][1])
        beta_dust = float(beta_dustList[i][1])
        kappa_1300 = float(kappa_1300List[i][1])
    else:
        nH_flag = False
        N_H = 0.0
        beta_dust = 0.0
        kappa_1300 = 0.0
    TelescopeSize = float(TelescopeSizeList[0])
    Inter_Flag = InterFlagList[0]
    IsotopologuesFlag = IsotopologuesList[0]
    if (IsotopologuesFlag != "n"):
        iso_flag = True
        IsoTableFileName = IsoTableFileNameList[0]
    else:
        iso_flag = False
        IsoTableFileName = ""

    # Debug:
    print "MolfitsFileName = ", MolfitsFileName
    print "FreqMin = ", FreqMin
    print "FreqMax = ", FreqMax
    print "FreqStep = ", FreqStep
    print "t_back_flag = ", t_back_flag
    print "tBack = ", tBack
    print "tslope = ", tslope
    print "nH_flag = ", nH_flag
    print "N_H = ", N_H
    print "beta_dust = ", beta_dust
    print "kappa_1300 = ", kappa_1300
    print "molfit file = ", MolfitsFileName
    print "TelescopeSize = ", TelescopeSize
    print "Inter_Flag = ", Inter_Flag
    print "iso_flag = ", iso_flag
    print "IsoTableFileName = ", IsoTableFileName
    print "\n\n========================================================================================================================================="


    ##----------------------------------------------------------------------------------------------------------------------------------------------------
    ## start myXCLASS function
    modelmyXCLASS, log, TransEnergies, IntOptical, JobDir = task_myXCLASS.myXCLASS(FreqMin, FreqMax, FreqStep, TelescopeSize, Inter_Flag, t_back_flag, \
                                                                                   tBack, tslope, nH_flag, N_H, beta_dust, kappa_1300, MolfitsFileName, \
                                                                                   iso_flag, IsoTableFileName, RestFreq, vLSR)
    cmdString = "rm -rf " + JobDir
    os.system(cmdString)


    ## import exp data
    FileName = ExpFileList[i]
    NumHeaderLines = 0
    expdata = task_LoadASCIIFile.LoadASCIIFile(FileName, NumHeaderLines, RestFreq, vLSR)


    ## determine difference function
    k = min(len(expdata), len(modelmyXCLASS))
    chi2data = numpy.zeros((k, 2), dtype=numpy.float32)
    for i in xrange(k):
        chi2data[i, 0] = expdata[i, 0]
        chi2data[i, 1] = (expdata[i, 1] - modelmyXCLASS[i, 1])


    ## create a plot if current molecule does not contribute to spectra
    #    fig = pylab.figure(figsize=(15, 10))
    #    fig.clear()
    #    pylab.subplots_adjust(hspace=0.45, wspace=0.2)
    #    layer = pylab.subplot(1,1,1)
    #    TitleString = os.path.splitext(os.path.basename(FileName))[0]
    #    layer.grid(True)
    #    layer.set_title(TitleString)
    #    layer.set_ylabel(r"T$_{mb}$ [K]")
    #    layer.set_xlabel("Rest Frequency [MHz]")
    #    layer.plot(expdata[:,0], expdata[:,1], '-', color='black', linewidth=3.0, label='exp. data', drawstyle='steps-mid')
    #    layer.set_xlim(expdata[0,0], expdata[-1,0])
    #    layer.plot(modelmyXCLASS[:, 0], modelmyXCLASS[:, 1], '-', color='red', linewidth=2.0, label = 'fit')
    #    layer.plot(chi2data[:, 0], chi2data[:, 1], '-', color='green', linewidth=1.0, label = 'data - fit')
    #    layer.legend()
    #    pylab.savefig(ResultPath + "/myXCLASS__result__" + str(i + 1) + ".png", dpi=300)
    #    pylab.draw()
    #    pylab.close(fig)


##========================================================================================================================================================
##
## Compare myXCLASS and myXCLASSFit functions
##
##========================================================================================================================================================


## print what you do
print "Compare myXCLASS and myXCLASSFit functions"
print "\n\n========================================================================================================================================="


## determine difference function
k = min(len(modelmyXCLASS), len(modelmyXCLASSFit))
chi2data = numpy.zeros((k, 2), dtype=numpy.float32)
for i in xrange(k):
    chi2data[i, 0] = modelmyXCLASS[i, 0]
    chi2data[i, 1] = (modelmyXCLASS[i, 1] - modelmyXCLASSFit[i, 1])

    # Debug:
    if (abs(modelmyXCLASS[i, 0] - modelmyXCLASSFit[i, 0]) > 1.e-6):
        print "Unequal data point:"
        print "\tmodelmyXCLASS[i, 0]    = ", modelmyXCLASS[i, 0]
        print "\tmodelmyXCLASSFit[i, 0] = ", modelmyXCLASSFit[i, 0]


##========================================================================================================================================================
##
## FOR TESTING: Create a plot
##
##========================================================================================================================================================
if (DoPlotFlag):
    print "\n\nCreate a plot ..",


    ## create a plot if current molecule does not contribute to spectra
    fig = pylab.figure(figsize=(15, 10))
    fig.clear()
    pylab.subplots_adjust(hspace=0.45, wspace=0.2)
    layer = pylab.subplot(1,1,1)
    TitleString = os.path.splitext(os.path.basename(FileName))[0]
    layer.grid(True)
    layer.set_title("Difference between myXCLASS and myXCLASSFit")
    layer.set_ylabel(r"T$_{mb}$ [K]")
    layer.set_xlabel("Rest Frequency [MHz]")
    layer.plot(modelmyXCLASS[:, 0], modelmyXCLASS[:, 1], '-', color='black', linewidth=3.0, label='myXCLASS', drawstyle='steps-mid')
    layer.set_xlim(modelmyXCLASS[0, 0], modelmyXCLASS[-1, 0])
    layer.plot(modelmyXCLASSFit[:, 0], modelmyXCLASSFit[:, 1], '-', color='red', linewidth=2.0, label = 'myXCLASSFit')
    layer.plot(chi2data[:, 0], chi2data[:, 1], '-', color='green', linewidth=1.0, label = 'myXCLASS - myXCLASSFit')
    layer.legend()
    pylab.savefig(ResultPath + "/Comparision__myXCLASS+myXCLASSFit-results.png", dpi=300)
    pylab.draw()
    pylab.close(fig)
    print "done!\n\n"


##========================================================================================================================================================
##
## FOR TESTING: Compare result with previous results
##
##========================================================================================================================================================
if (CompareFlag):
    print "\n\nCompare modelled spectra:"
    k = min(len(modelmyXCLASS), len(modelmyXCLASSFit))
    countDiff = 0
    for i in xrange(k):
        if (abs(modelmyXCLASS[i, 1] - modelmyXCLASSFit[i, 1]) > DiffTolerance):
            countDiff += 1
            print "\n\nDifference in modelled spectra at ", modelmyXCLASS[i, 0], " MHz."
            print "modelmyXCLASS[i, 1] = ", modelmyXCLASS[i, 1]
            print "modelmyXCLASSFit[i, 1] = ", modelmyXCLASSFit[i, 1]
            print "Difference = ", abs(modelmyXCLASS[i, 1] - modelmyXCLASSFit[i, 1])


    ## print result of comparison
    if (countDiff > 0):
        print "\n\n\n\tThe modeled spectra are   N O T   identical!\n\n\n"
    else:
        print "\n\n\tModeled spectra are   I D E N T I C A L  !\n\n\n"


        ## write status file for CASA
        if (CASAFlag):
            CASAFile = open("comparison.txt", 'w')
            CASAFile.write("identical\n")
            CASAFile.close()




