#!/usr/bin/python
# -*- coding: utf-8 -*-
##********************************************************************************************************************************************************
##
##  test-routine:   Check result of myXCLASSFit function for ArH+ with previous calculated results
##
##
##
##
##  Copyright (C) 2014 - 2016
##
##  I. Physikalisches Institut, University of Cologne
##
##
##
##  Who           When         What
##
##  T. Moeller    29.07.2014   initial version
##  T. Moeller    27.03.2015   improved version
##
##********************************************************************************************************************************************************


##********************************************************************* load packages ********************************************************************
import numpy                                                                                ## import numpy package
import os                                                                                   ## import os package
import sys                                                                                  ## import sys package
import matplotlib                                                                           ## import matplotlib
import pylab                                                                                ## import pylab
##--------------------------------------------------------------------------------------------------------------------------------------------------------


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## define current working directory
LocalPath = os.getcwd() + "/"


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## extend sys.path variable, if necessary
XCLASSBaseDir = LocalPath + "../../../../"
XCLASSBaseDir = os.path.normpath(XCLASSBaseDir) + "/"
CASAFlag = True
try:
    # import taskinit
    tasklist()
    import myXCLASSFit as task_myXCLASSFit
    import LoadASCIIFile as task_LoadASCIIFile
except:
    CASAFlag = False
    NewModulesPaths = [XCLASSBaseDir + "build_tasks/"]
    for NewModule in NewModulesPaths:
        already_included_flag = "false"
        for entries in sys.path:
            if (entries == NewModule):
                already_included_flag = "true"
                break
        if (already_included_flag == "false"):
            sys.path.append(NewModule)


    ## import task_myXCLASSFit and task_LoadASCIIFile packages
    import task_myXCLASSFit
    import task_LoadASCIIFile


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## get command line argrument
UpdateFlag = False
if (len(sys.argv) > 1):                                                                     ## check, if command line arguments are defined
    for argument in sys.argv[1:]:                                                           ## loop over all command line arguments
        if (argument.lower() == "--update"):
            UpdateFlag = True
            break


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## general settings
DoPlotFlag = True
CompareFlag = True
DiffTolerance = 1.e-3


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## loop over different cases


## define lists with different file names
MolfitFileList = ["SO2__dust-continuum-fit___no-background-defined.molfit", "SO2__dust-continuum-fit___T_dOff.molfit", \
                  "SO2__dust-continuum-fit___fit-all-dust-parameters.molfit"]
ObsXMLFileList = ["observation__all__no-background.xml", "observation__all__T_dOff.xml", "observation__all__fit-dust-parameters.xml"]


## clear output directory
ResultPath = "plot/"
os.system("rm -rf " + ResultPath + "; mkdir " + ResultPath)


## start fit for each case
UnequalPointCounter = 0
JobDirList = []
NumberCases = len(MolfitFileList)                                                           ## determine number of cases
for case in xrange(NumberCases):                                                            ## loop over all cases


    ## print what you do
    k = "=" * 175
    print "\n\n\n\n", k
    print "Fit case: ", (case + 1)
    print "\n\n"


    ## define parameters for myXCLASSFit function
    NumberIteration = 10
    TelescopeSize = 3.5
    Inter_Flag = True
    t_back_flag = True
    tBack = 1.1
    tslope = 0.0000000000E+00
    nH_flag = True
    N_H = 0.0000000000E+00
    beta_dust = 2.0
    kappa_1300 = 0.02
    iso_flag = False
    IsoTableFileName = ""
    RestFreq = 0.0
    vLSR = 0.0
    AlgorithmXMLFile = "LM.xml"
    MolfitsFileName = MolfitFileList[case]
    experimentalData = ObsXMLFileList[case]


    ##----------------------------------------------------------------------------------------------------------------------------------------------------
    ## start myXCLASSFit function
    newmolfit, modeldata, JobDir = task_myXCLASSFit.myXCLASSFit(NumberIteration, AlgorithmXMLFile, MolfitsFileName, experimentalData, TelescopeSize, \
                                                                Inter_Flag, t_back_flag, tBack, tslope, nH_flag, N_H, beta_dust, kappa_1300, iso_flag, \
                                                                IsoTableFileName, RestFreq, vLSR)
    JobDirList.append(JobDir)

    # Debug:
    #    print "modeldata = ", modeldata
    #    print "modeldata[0] = ", modeldata[0]
    #    print "modeldata[0, :] = ", modeldata[0][0, :]


    ## determine fit scenario
    CompareDir = MolfitsFileName.replace(".molfit", "")


    ##====================================================================================================================================================
    ##
    ## FOR TESTING: Create a plot
    ##
    ##====================================================================================================================================================
    if (DoPlotFlag):
        print "\n\nCreate a plot ..",


        ## create final plot
        fig = pylab.figure(figsize=(15, 10))
        fig.clear()
        pylab.subplots_adjust(hspace=0.1, wspace=0.2)


        ## import observational data and create first subplot
        FileName = LocalPath + "spw01.dat"
        NumHeaderLines = 2
        expdata = task_LoadASCIIFile.LoadASCIIFile(FileName, NumHeaderLines, RestFreq, vLSR)
        layer1 = pylab.subplot(2, 1, 1)
        layer1.grid(True)
        layer1.set_title("myXCLASSFit function:  dust continuum fit;   case:" + CompareDir)
        layer1.set_ylabel(r"T$_{mb}$ [K]")
        layer1.plot(expdata[:, 0], expdata[:, 1], '-', color='black', linewidth=3.0, label='obs. data', drawstyle='steps-mid')
        layer1.plot(modeldata[0][:, 0], modeldata[0][:, 1], '-', color='red', linewidth=2.0, label = 'fit')
        layer1.set_xlim(modeldata[0][0, 0], modeldata[0][-1, 0])
        layer1.xaxis.set_major_formatter(matplotlib.ticker.FormatStrFormatter('%.0f'))
        layer1.legend()


        ## import observational data and create second subplot
        FileName = LocalPath + "spw23.dat"
        NumHeaderLines = 2
        expdata = task_LoadASCIIFile.LoadASCIIFile(FileName, NumHeaderLines, RestFreq, vLSR)
        layer2 = pylab.subplot(2, 1, 2)
        layer2.grid(True)
        layer2.set_ylabel(r"T$_{mb}$ [K]")
        layer2.set_xlabel("Rest Frequency [MHz]")
        layer2.plot(expdata[:, 0], expdata[:, 1], '-', color='black', linewidth=3.0, label='obs. data', drawstyle='steps-mid')
        layer2.plot(modeldata[1][:, 0], modeldata[1][:, 1], '-', color='red', linewidth=2.0, label = 'fit')
        layer2.set_xlim(modeldata[1][0, 0], modeldata[1][-1, 0])
        layer2.xaxis.set_major_formatter(matplotlib.ticker.FormatStrFormatter('%.0f'))
        layer2.legend()


        ## save plot
        ExtFileName = CompareDir.replace(" ", "_")
        pylab.savefig(ResultPath + "/myXCLASSFit____dust-continuum-fit__" + ExtFileName + ".png", dpi=300)
        pylab.draw()
        pylab.close(fig)
        print "done!\n\n"


    ##====================================================================================================================================================
    ##
    ## FOR TESTING: Compare result with previous results
    ##
    ##====================================================================================================================================================
    if (CompareFlag):


        ## print what you do
        print "\n\nCompare result with previous results for " + CompareDir + " .."


        ## analyze both data files
        for jj in xrange(2):


            ##--------------------------------------------------------------------------------------------------------------------------------------------
            ## read in model data from test-run
            if (jj == 0):
                TestData = numpy.loadtxt(LocalPath + "reference_run/" + CompareDir + "/spw01.LM.out.dat")
            else:
                TestData = numpy.loadtxt(LocalPath + "reference_run/" + CompareDir + "/spw23.LM.out.dat")


            ##--------------------------------------------------------------------------------------------------------------------------------------------
            ## compare result of the ArH+ fit with test-run
            NumTestDataPoints = len(TestData)
            if (NumTestDataPoints != len(modeldata[jj])):
                print "\n\n\n\t\tThe data sets have unequal number of data points!"
                print "\t\tNumber of current data set:   ", len(modeldata[jj])
                print "\t\tNumber of reference data set: ", NumTestDataPoints
                print "\n\n\n\n"
                sys.exit(0)
            for i in xrange(NumTestDataPoints):
                TestLine = TestData[i]
                CurrentFitLine = modeldata[jj][i]

                # Debug:
                # print "TestLine       = ", TestLine
                # print "CurrentFitLine = ", CurrentFitLine
                # print "------------------------------------------------------------------"


                if (abs(TestLine[0] - CurrentFitLine[0]) > DiffTolerance or abs(TestLine[1] - CurrentFitLine[1]) > DiffTolerance):
                    UnequalPointCounter += 1

                    print "\t\tUnequal results:"
                    print "\t\tTestLine       = ", TestLine
                    print "\t\tCurrentFitLine = ", CurrentFitLine
                    print "------------------------------------------------------------------"


        ## print result of comparison
        if (not UpdateFlag):
            UpdateFlag = False
        if (UnequalPointCounter > 0):
            print "\n\n\n\tThe data sets are   N O T   identical!\n\n\n"
        else:
            print "\n\n\tResults are   I D E N T I C A L   to previous result!\n\n\n"
            UpdateFlag = True


    ## print something to screen
    print "\n\n\n\n"



## print final result of comparison
if (CompareFlag):
    if (UnequalPointCounter > 0):
        print "\n\n\n\tThe data sets are   N O T   identical!\n\n\n"
    else:
        print "\n\n\tResults are   I D E N T I C A L   to previous result!\n\n\n"


        ## write status file for CASA
        if (CASAFlag):
            CASAFile = open("comparison.txt", 'w')
            CASAFile.write("identical\n")
            CASAFile.close()


## update reference directory
if (UpdateFlag):
    print "Update reference files ..",
    for case in xrange(NumberCases):                                                        ## loop over all cases
        JobDir = JobDirList[case]
        MolfitsFileName = MolfitFileList[case]
        CompareDir = MolfitsFileName.replace(".molfit", "")
        cmdString = "rm -f " + LocalPath + "reference_run/" + CompareDir + "/*; "
        cmdString += "cp " + JobDir + "/* " + LocalPath + "reference_run/" + CompareDir + "/; "
        cmdString += "rm -rf " + JobDir
        os.system(cmdString)
    print "done!"



