#!/usr/bin/python
# -*- coding: utf-8 -*-
##********************************************************************************************************************************************************
##
##  test-routine:   Check result of myXCLASSFit function for example described in the manual with previous calculated results (with SA)
##
##
##
##
##  Copyright (C) 2015 - 2016
##
##  I. Physikalisches Institut, University of Cologne
##
##
##
##  Who           When         What
##
##  T. Moeller    19.06.2015   initial version
##
##********************************************************************************************************************************************************


##********************************************************************* load packages ********************************************************************
import numpy                                                                                ## import numpy package
import os                                                                                   ## import os package
import sys                                                                                  ## import sys package
import matplotlib                                                                           ## import matplotlib
import pylab                                                                                ## import pylab
##--------------------------------------------------------------------------------------------------------------------------------------------------------


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## define current working directory
LocalPath = os.getcwd() + "/"


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## extend sys.path variable, if necessary
XCLASSBaseDir = LocalPath + "../../../../"
XCLASSBaseDir = os.path.normpath(XCLASSBaseDir) + "/"
try:
    # import taskinit
    tasklist()
    import myXCLASSFit as task_myXCLASSFit
    import LoadASCIIFile as task_LoadASCIIFile
except:
    NewModulesPaths = [XCLASSBaseDir + "build_tasks/"]
    for NewModule in NewModulesPaths:
        already_included_flag = "false"
        for entries in sys.path:
            if (entries == NewModule):
                already_included_flag = "true"
                break
        if (already_included_flag == "false"):
            sys.path.append(NewModule)


    ## import task_myXCLASSFit and task_LoadASCIIFile packages
    import task_myXCLASSFit
    import task_LoadASCIIFile


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## get command line argrument
UpdateFlag = False
if (len(sys.argv) > 1):                                                                     ## check, if command line arguments are defined
    for argument in sys.argv[1:]:                                                           ## loop over all command line arguments
        if (argument.lower() == "--update"):
            UpdateFlag = True
            break


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## general settings
DoPlotFlag = True
CompareFlag = False
DiffTolerance = 1.e-3


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## define parameters for myXCLASSFit function
NumberIteration = 1
AlgorithmXMLFile = LocalPath + "algorithm-settings.xml"
MolfitsFileName = XCLASSBaseDir + "demo/myXCLASSFit/CH3OH__old.molfit"
experimentalData = XCLASSBaseDir + "demo/myXCLASSFit/band1b.dat"
TelescopeSize = 3.5
Inter_Flag = False
t_back_flag = True
tBack = 1.1
tslope = 0.0000000000E+00
nH_flag = True
N_H = 3.0000000000E+24
beta_dust = 2.0
kappa_1300 = 0.02
iso_flag = False
IsoTableFileName = ""
RestFreq = 0.0
vLSR = 0.0
newmolfit, modeldata, JobDir = task_myXCLASSFit.myXCLASSFit(NumberIteration, AlgorithmXMLFile, MolfitsFileName, experimentalData, TelescopeSize, \
                                                            Inter_Flag, t_back_flag, tBack, tslope, nH_flag, N_H, beta_dust, kappa_1300, iso_flag, \
                                                            IsoTableFileName, RestFreq, vLSR)
if (len(numpy.asarray(modeldata).shape) == 2):
    modeldata = [modeldata]


##========================================================================================================================================================
##
## FOR TESTING: Create a plot
##
##========================================================================================================================================================
if (DoPlotFlag):
    print "\n\nCreate a plot ..\n\n"


    ## import observational data
    FileName = XCLASSBaseDir + "demo/myXCLASSFit/band1b.dat"
    NumHeaderLines = 0
    expdata = task_LoadASCIIFile.LoadASCIIFile(FileName, NumHeaderLines, RestFreq, vLSR)


    ## create final plot
    ResultPath = "plot/"
    os.system("rm -rf " + ResultPath + "; mkdir " + ResultPath)
    fig = pylab.figure(figsize=(15, 10))
    fig.clear()
    colorindex = ['r', 'g', 'b', 'y', 'm', 'r']
    pylab.subplots_adjust(hspace=0.2, wspace=0.2)
    layer = pylab.subplot(1, 1, 1)
    layer.grid(True)
    layer.set_title("myXCLASSFit function:  demo-from-manual with PSO")
    layer.set_ylabel(r"T$_{mb}$ [K]")
    layer.set_xlabel("Rest Frequency [MHz]")
    layer.plot(expdata[:, 0], expdata[:, 1], '-', color='black', linewidth=3.0, label='obs. data', drawstyle='steps-mid')
    for i in xrange(len(modeldata)):
        layer.plot(modeldata[i][:, 0], modeldata[i][:, 1], '-', color=colorindex[i], linewidth=2.0, label = "fit (best site " + str(i + 1) + ")")
    layer.set_xlim(modeldata[0][0, 0], modeldata[0][-1, 0])
    layer.xaxis.set_major_formatter(matplotlib.ticker.FormatStrFormatter('%.5e'))
    layer.legend()
    pylab.savefig(ResultPath + "/myXCLASSFit____demo-from-manual__with_PSO.png", dpi=300)
    pylab.draw()
    pylab.close(fig)


##========================================================================================================================================================
##
## FOR TESTING: Compare result with previous results
##
##========================================================================================================================================================
if (CompareFlag):
    print "\n\nCompare result with previous results .."


    ##----------------------------------------------------------------------------------------------------------------------------------------------------
    ## read in model data from test-run
    TestData = numpy.loadtxt(LocalPath + "reference_run/ASCIIdata.PSO__site_1.out.dat")


    ##----------------------------------------------------------------------------------------------------------------------------------------------------
    ## compare result of the ArH+ fit with test-run
    modeldataLocal = modeldata[0]
    NumTestDataPoints = len(TestData)
    if (NumTestDataPoints != len(modeldataLocal)):
        print "\n\n\n\t\tThe data sets have unequal number of data points!"
        print "\t\tNumber of current data set:   ", len(modeldataLocal)
        print "\t\tNumber of reference data set: ", NumTestDataPoints
        print "\n\n\n\n"
        sys.exit(0)
    UnequalPointCounter = 0
    for i in xrange(NumTestDataPoints):
        TestLine = TestData[i]
        CurrentFitLine = modeldataLocal[i]

        # Debug:
        # print "TestLine       = ", TestLine
        # print "CurrentFitLine = ", CurrentFitLine
        # print "------------------------------------------------------------------"


        if (abs(TestLine[0] - CurrentFitLine[0]) > DiffTolerance or abs(TestLine[1] - CurrentFitLine[1]) > DiffTolerance):
            UnequalPointCounter += 1

            print "\t\tUnequal results:"
            print "\t\tTestLine       = ", TestLine
            print "\t\tCurrentFitLine = ", CurrentFitLine
            print "------------------------------------------------------------------"


    ## print result of comparison
    if (UnequalPointCounter > 0):
        print "\n\n\n\tThe data sets are   N O T   identical!\n\n\n"
    else:
        print "\n\n\tResults are   I D E N T I C A L   to previous result!\n\n\n"
else:
    print "\n\n\tN O   comparison!\n\n\n"


## update reference directory
if (UpdateFlag):
    print "Update reference files ..",
    cmdString = "rm -f " + LocalPath + "reference_run/*; cp " + JobDir + "/* " + LocalPath + "reference_run/; rm -rf " + JobDir
    os.system(cmdString)
    print "done!"



