#!/usr/bin/python
# -*- coding: utf-8 -*-
##********************************************************************************************************************************************************
##
##  test-routine:   Check result of myXCLASSFit function for example described in the manual with previous calculated results
##
##
##
##
##  Copyright (C) 2015 - 2016
##
##  I. Physikalisches Institut, University of Cologne
##
##
##
##  Who           When         What
##
##  T. Moeller    19.06.2015   initial version
##
##********************************************************************************************************************************************************


##********************************************************************* load packages ********************************************************************
import numpy                                                                                ## import numpy package
import os                                                                                   ## import os package
import sys                                                                                  ## import sys package
import matplotlib                                                                           ## import matplotlib
import pylab                                                                                ## import pylab
##--------------------------------------------------------------------------------------------------------------------------------------------------------


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## define current working directory
LocalPath = os.getcwd() + "/"


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## extend sys.path variable, if necessary
XCLASSBaseDir = LocalPath + "../../../../"
XCLASSBaseDir = os.path.normpath(XCLASSBaseDir) + "/"
CASAFlag = True
try:
    # import taskinit
    tasklist()
    import myXCLASSFit as task_myXCLASSFit
    import LoadASCIIFile as task_LoadASCIIFile
except:
    CASAFlag = False
    NewModulesPaths = [XCLASSBaseDir + "build_tasks/"]
    for NewModule in NewModulesPaths:
        already_included_flag = "false"
        for entries in sys.path:
            if (entries == NewModule):
                already_included_flag = "true"
                break
        if (already_included_flag == "false"):
            sys.path.append(NewModule)


    ## import task_myXCLASSFit and task_LoadASCIIFile packages
    import task_myXCLASSFit
    import task_LoadASCIIFile


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## get command line argrument
UpdateFlag = False
if (len(sys.argv) > 1):                                                                     ## check, if command line arguments are defined
    for argument in sys.argv[1:]:                                                           ## loop over all command line arguments
        if (argument.lower() == "--update"):
            UpdateFlag = True
            break


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## general settings
DoPlotFlag = True
CompareFlag = True
DiffTolerance = 1.e-3


## create plot directory
ResultPath = "plot/"
os.system("rm -rf " + ResultPath + "; mkdir " + ResultPath)


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## define list of molfit files
MolfitFileList = ["CH3OH__new.molfit", "CH3OH__new__nH+kappa+beta.molfit", "CH3OH__new__Tdoff+Tdslope.molfit", \
                  "CH3OH__new__Tdoff+Tdslope+nH+kappa+beta.molfit", "CH3OH__old.molfit", "CH3OH__old__nH+kappa+beta.molfit", \
                  "CH3OH__old__Tdoff+Tdslope.molfit", "CH3OH__old__Tdoff+Tdslope+nH+kappa+beta.molfit"]
UnequalPointCounter = 0
NumMolfitFiles = len(MolfitFileList)
JobDir1 = ""
for jj in xrange(NumMolfitFiles):


    ## print what you do
    k = "=" * 175
    print "\n\n\n" + k
    print "Use molfit file: " + MolfitFileList[jj]
    print "\n\n"


    ## define parameters for myXCLASSFit function
    NumberIteration = 60
    AlgorithmXMLFile = ""
    MolfitsFileName = XCLASSBaseDir + "demo/myXCLASSFit/" + MolfitFileList[jj]
    experimentalData = XCLASSBaseDir + "demo/myXCLASSFit/band1b.dat"
    TelescopeSize = 3.5
    Inter_Flag = False
    t_back_flag = True
    tBack = 1.1
    tslope = 0.0000000000E+00
    nH_flag = True
    N_H = 3.0000000000E+24
    beta_dust = 2.0
    kappa_1300 = 0.02
    iso_flag = False
    IsoTableFileName = ""
    RestFreq = 0.0
    vLSR = 0.0
    newmolfit, modeldata, JobDir = task_myXCLASSFit.myXCLASSFit(NumberIteration, AlgorithmXMLFile, MolfitsFileName, experimentalData, TelescopeSize, \
                                                                Inter_Flag, t_back_flag, tBack, tslope, nH_flag, N_H, beta_dust, kappa_1300, iso_flag, \
                                                                IsoTableFileName, RestFreq, vLSR)

    if (MolfitFileList[jj] == "CH3OH__new.molfit"):
        JobDir1 = JobDir
    else:
        cmdString = "rm -rf " + JobDir
        os.system(cmdString)


    ##====================================================================================================================================================
    ##
    ## FOR TESTING: Create a plot
    ##
    ##====================================================================================================================================================
    if (DoPlotFlag):
        print "\n\nCreate a plot ..\n\n"


        ## import observational data
        FileName = XCLASSBaseDir + "demo/myXCLASSFit/band1b.dat"
        NumHeaderLines = 0
        expdata = task_LoadASCIIFile.LoadASCIIFile(FileName, NumHeaderLines, RestFreq, vLSR)


        ## create final plot
        fig = pylab.figure(figsize=(15, 10))
        fig.clear()
        pylab.subplots_adjust(hspace=0.2, wspace=0.2)
        layer = pylab.subplot(1, 1, 1)
        layer.grid(True)
        MolfitFormat = MolfitFileList[jj]
        MolfitFormat = MolfitFormat.replace("CH3OH__", "")
        MolfitFormat = MolfitFormat.replace(".molfit", "")
        layer.set_title("myXCLASSFit function:  demo-from-manual, molfit file: " + MolfitFormat)
        layer.set_ylabel(r"T$_{mb}$ [K]")
        layer.set_xlabel("Rest Frequency [MHz]")
        layer.plot(expdata[:, 0], expdata[:, 1], '-', color='black', linewidth=3.0, label='obs. data', drawstyle='steps-mid')
        layer.plot(modeldata[:, 0], modeldata[:, 1], '-', color='red', linewidth=2.0, label = 'fit')
        layer.set_xlim(modeldata[0, 0], modeldata[-1, 0])
        layer.xaxis.set_major_formatter(matplotlib.ticker.FormatStrFormatter('%.5e'))
        layer.legend()
        pylab.savefig(ResultPath + "/myXCLASSFit____demo-from-manual__" + MolfitFormat + ".png", dpi=300)
        pylab.draw()
        pylab.close(fig)


    ##====================================================================================================================================================
    ##
    ## FOR TESTING: Compare result with previous results
    ##
    ##====================================================================================================================================================
    if (CompareFlag):
        print "\n\nCompare result with previous results .."


        ##------------------------------------------------------------------------------------------------------------------------------------------------
        ## read in model data from test-run
        TestData = numpy.loadtxt(LocalPath + "reference_run/ASCIIdata.LM.out.dat")


        ##------------------------------------------------------------------------------------------------------------------------------------------------
        ## compare result of the ArH+ fit with test-run
        NumTestDataPoints = len(TestData)
        if (NumTestDataPoints != len(modeldata)):
            print "\n\n\n\t\tThe data sets have unequal number of data points!"
            print "\t\tNumber of current data set:   ", len(modeldata)
            print "\t\tNumber of reference data set: ", NumTestDataPoints
            print "\n\n\n\n"
            sys.exit(0)
        for i in xrange(NumTestDataPoints):
            TestLine = TestData[i]
            CurrentFitLine = modeldata[i]

            # Debug:
            # print "TestLine       = ", TestLine
            # print "CurrentFitLine = ", CurrentFitLine
            # print "------------------------------------------------------------------"


            if (abs(TestLine[0] - CurrentFitLine[0]) > DiffTolerance or abs(TestLine[1] - CurrentFitLine[1]) > DiffTolerance):
                UnequalPointCounter += 1

                print "\t\tUnequal results:"
                print "\t\tTestLine       = ", TestLine
                print "\t\tCurrentFitLine = ", CurrentFitLine
                print "------------------------------------------------------------------"


        ## print result of comparison
        if (UnequalPointCounter > 0):
            print "\n\n\n\tThe data sets are not identical!\n\n\n"
        else:
            print "\n\n\tResults are identical to previous result!\n\n\n"


## print result of comparison
if (not UpdateFlag):
    UpdateFlag = False
if (UnequalPointCounter > 0):
    print "\n\n\n\tThe data sets are   N O T   identical!\n\n\n"
else:
    print "\n\n\tResults are   I D E N T I C A L   to previous results!\n\n\n"
    UpdateFlag = True


## write status file for CASA
if (CASAFlag):
    CASAFile = open("comparison.txt", 'w')
    CASAFile.write("identical\n")
    CASAFile.close()


## update reference directory
if (UpdateFlag and JobDir1 != ""):
    print "Update reference files ..",
    cmdString = "rm -f " + LocalPath + "reference_run/*; cp " + JobDir1 + "/* " + LocalPath + "reference_run/; rm -rf " + JobDir1
    os.system(cmdString)
    print "done!"



