#!/usr/bin/python
# -*- coding: utf-8 -*-
##********************************************************************************************************************************************************
##
##  test-routine:   Calculate example run with and without isotopologues, plot result and compare run with previous results
##
##
##
##
##  Copyright (C) 2015 - 2016
##
##  I. Physikalisches Institut, University of Cologne
##
##
##
##  Who           When         What
##
##  T. Moeller    19.06.2015   initial version
##
##********************************************************************************************************************************************************


##********************************************************************* load packages ********************************************************************
import numpy                                                                                ## import numpy package
import os                                                                                   ## import os package
import sys                                                                                  ## import sys package
import matplotlib                                                                           ## import matplotlib
import pylab                                                                                ## import pylab
##--------------------------------------------------------------------------------------------------------------------------------------------------------


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## define current working directory
LocalPath = os.getcwd() + "/"


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## extend sys.path variable, if necessary
XCLASSBaseDir = LocalPath + "../../../../"
XCLASSBaseDir = os.path.normpath(XCLASSBaseDir) + "/"
CASAFlag = True
try:
    # import taskinit
    tasklist()
    import myXCLASS as task_myXCLASS
    import LoadASCIIFile as task_LoadASCIIFile
    import myXCLASSPlot as task_myXCLASSPlot
except:
    CASAFlag = False
    NewModulesPaths = [XCLASSBaseDir + "build_tasks/"]
    for NewModule in NewModulesPaths:
        already_included_flag = "false"
        for entries in sys.path:
            if (entries == NewModule):
                already_included_flag = "true"
                break
        if (already_included_flag == "false"):
            sys.path.append(NewModule)


    ## import task_myXCLASS, task_LoadASCIIFile, and task_myXCLASSPlot packages
    import task_myXCLASS
    import task_LoadASCIIFile
    import task_myXCLASSPlot


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## get command line argruments
UpdateFlag = False
if (len(sys.argv) > 1):                                                                     ## check, if command line arguments are defined
    for argument in sys.argv[1:]:                                                           ## loop over all command line arguments
        if (argument.lower() == "--update"):
            UpdateFlag = True
            break


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## general settings
DoPlotFlag = True
CompareFlag = True
DiffTolerance = 1.e-3


## call myXCLASS function
FreqMin = 258000.0
FreqMax = 259850.0
FreqStep = 5.0000000000E-01
TelescopeSize = 300.0
Inter_Flag = False
t_back_flag = True
tBack = 140.0
tslope = 0.0000000000E+00
nH_flag = True
N_H = 3.0000000000E+24
beta_dust = 0.0
kappa_1300 = 0.002
MolfitsFileName = LocalPath + "SO2__example.molfit"
RestFreq = 0.0
vLSR = 0.0


## call myXCLASS function with isotopologues
iso_flag = True
IsoTableFileName = LocalPath + "iso_names.txt"
modeldataWithISO, log, TransEnergies, IntOpt, JobDir1 = task_myXCLASS.myXCLASS(FreqMin, FreqMax, FreqStep, TelescopeSize, Inter_Flag, t_back_flag, \
                                                                               tBack, tslope, nH_flag, N_H, beta_dust, kappa_1300, MolfitsFileName, \
                                                                               iso_flag, IsoTableFileName, RestFreq, vLSR)
## call myXCLASS function without isotopologues
iso_flag = False
modeldataNoISO, log, TransEnergies, IntOpt, JobDir2 = task_myXCLASS.myXCLASS(FreqMin, FreqMax, FreqStep, TelescopeSize, Inter_Flag, t_back_flag, tBack, \
                                                                             tslope, nH_flag, N_H, beta_dust, kappa_1300, MolfitsFileName, iso_flag, \
                                                                             IsoTableFileName, RestFreq, vLSR)


##========================================================================================================================================================
##
## FOR TESTING: Create a plot
##
##========================================================================================================================================================
if (DoPlotFlag):
    print "\n\nCreate a plot ..\n\n"


    ## create final plot
    ResultPath = "plot/"
    os.system("rm -rf " + ResultPath + "; mkdir " + ResultPath)
    fig = pylab.figure(figsize=(20, 10))
    fig.clear()
    pylab.subplots_adjust(left=0.05, right=0.99,hspace=0.45, wspace=0.2)
    layer = pylab.subplot(1,1,1)
    layer.grid(True)
    layer.set_title("myXCLASS function:  Example with and without isotopologues")
    layer.set_ylabel(r"T$_{mb}$ [K]")
    layer.set_xlabel("Rest Frequency [MHz]")
    layer.plot(modeldataWithISO[:, 0], modeldataWithISO[:, -1], '-', color='red', linewidth=4.0, label = 'fit with iso')
    layer.plot(modeldataNoISO[:, 0], modeldataNoISO[:, -1], '-', color='green', linewidth=2.0, label = 'fit no iso')
    layer.set_xlim(FreqMin, FreqMax)
    layer.legend()
    pylab.savefig(ResultPath + "/myXCLASS____example_with_and_without_isotopologues.png", dpi=300)
    pylab.draw()
    pylab.close(fig)


##========================================================================================================================================================
##
## FOR TESTING: Compare result with previous results
##
##========================================================================================================================================================
if (CompareFlag):
    print "\n\nCompare result with previous results .."
    TestCases = ["NoISO", "WithISO"]
    for case in TestCases:


        ## get modeled data
        print "\n\n\n\tCheck results ",
        if (case == "NoISO"):
            modeldata = modeldataNoISO
            JobDir = JobDir2
            print "WITHOUT ",
        else:
            modeldata = modeldataWithISO
            JobDir = JobDir1
            print "WITH ",
        print "isotopologues .."


        ##------------------------------------------------------------------------------------------------------------------------------------------------
        ## read in model data from test-run
        TestData = numpy.loadtxt(LocalPath + "reference_run/" + case + "/xclass_spectrum_output.dat")


        ##------------------------------------------------------------------------------------------------------------------------------------------------
        ## compare result of the ArH+ fit with test-run
        NumTestDataPoints = len(TestData)
        if (NumTestDataPoints != len(modeldata)):
            print "\n\n\n\t\tThe data sets have unequal number of data points!"
            print "\t\tNumber of current data set:   ", len(modeldata)
            print "\t\tNumber of reference data set: ", NumTestDataPoints
            print "\n\n\n\n"
            sys.exit(0)
        UnequalPointCounter = 0
        for i in xrange(NumTestDataPoints):
            TestLine = TestData[i]
            CurrentFitLine = modeldata[i]

            # Debug:
            # print "TestLine       = ", TestLine
            # print "CurrentFitLine = ", CurrentFitLine
            # print "------------------------------------------------------------------"


            if (abs(TestLine[0] - CurrentFitLine[0]) > DiffTolerance or abs(TestLine[1] - CurrentFitLine[1]) > DiffTolerance):
                UnequalPointCounter += 1

                print "\t\tUnequal results:"
                print "\t\tTestLine       = ", TestLine
                print "\t\tCurrentFitLine = ", CurrentFitLine
                print "------------------------------------------------------------------"


        ## print result of comparison
        if (UnequalPointCounter > 0):
            print "\n\n\n\tThe data sets are  N O T  identical!\n\n\n"
        else:
            print "\n\n\tResults are  I D E N T I C A L  to previous result!\n\n\n"


        ## write status file for CASA
        if (CASAFlag):
            CASAFile = open("comparison.txt", 'w')
            CASAFile.write("identical\n")
            CASAFile.close()


## update reference directory
if (UpdateFlag):
    print "Update reference files ..",
    cmdString = "rm -f " + LocalPath + "reference_run/" + "NoISO" + "/*; cp " + JobDir2 + "/* " + LocalPath + "reference_run/" + "NoISO" + "/; "
    cmdString += "rm -f " + LocalPath + "reference_run/" + "WithISO" + "/*; cp " + JobDir1 + "/* " + LocalPath + "reference_run/" + "WithISO" + "/; "
    cmdString += "rm -rf " + JobDir1 + " " + JobDir2
    os.system(cmdString)
    print "done!"

