#!/usr/bin/python
# -*- coding: utf-8 -*-
##********************************************************************************************************************************************************
##
##  test-routine:   Perform different tests for several XCLASS functions
##
##
##
##
##  Copyright (C) 2014 - 2016
##
##  I. Physikalisches Institut, University of Cologne
##
##
##
##  Who           When         What
##
##  T. Moeller    29.07.2014   initial version
##  T. Moeller    27.03.2015   improved version
##  T. Moeller    04.05.2016   improved version
##
##********************************************************************************************************************************************************


##********************************************************************* load packages ********************************************************************
import numpy                                                                                ## import numpy package
import os                                                                                   ## import os package
import sys                                                                                  ## import sys package
##--------------------------------------------------------------------------------------------------------------------------------------------------------


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## define current working directory
LocalPath = os.getcwd() + "/"


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## define test directories
TestDirectoryList = ["MAGIX/test__MAGIX____demo", \
                     "MAGIX/test__MAGIX____gDL", \
                     "myXCLASS/test___ArH+_check", \
                     "myXCLASS/test___demo-from-manual", \
                     "myXCLASS/test___different_molfit-formats", \
                     "myXCLASS/test___multiple_molecule_definitions", \
                     "myXCLASS/test___no-iso_and_with-iso", \
                     "myXCLASSFit/test___ArH+_fit", \
                     "myXCLASSFit/test___demo-from-manual", \
                     "myXCLASSFit/test___demo-from-manual___Bees", \
                     "myXCLASSFit/test___demo-from-manual___Genetic", \
                     "myXCLASSFit/test___demo-from-manual___Genetic+LM+Error", \
                     "myXCLASSFit/test___demo-from-manual___MCMC", \
                     "myXCLASSFit/test___demo-from-manual___NS", \
                     "myXCLASSFit/test___demo-from-manual___PSO", \
                     "myXCLASSFit/test___demo-from-manual___SA", \
                     "myXCLASSFit/test___dust-continuum-fit", \
                     "myXCLASSFit/test___myXCLASS+myXCLASSFit____Compare", \
                     "myXCLASSMapFit/test__myXCLASSMapFit____demo", \
                     "LineIdentification/test__LineIdentification____demo"]

TestScriptList = ["test__MAGIX____demo.py", \
                  "test__MAGIX____gDL.py", \
                  "test__myXCLASS____ArH+_check.py", \
                  "test__myXCLASS____demo-from-manual.py", \
                  "test__myXCLASS____different_molfit-formats.py", \
                  "test__myXCLASS____multiple_molecule_definitions.py", \
                  "test__myXCLASS____no-iso_and_with-iso.py", \
                  "test__myXCLASSFit____ArH+_fit.py", \
                  "test__myXCLASSFit____demo-from-manual.py", \
                  "test__myXCLASSFit____demo-from-manual__Bees.py", \
                  "test__myXCLASSFit____demo-from-manual__Genetic.py", \
                  "test__myXCLASSFit____demo-from-manual__Genetic+LM+Error.py", \
                  "test__myXCLASSFit____demo-from-manual__MCMC.py", \
                  "test__myXCLASSFit____demo-from-manual__NS.py", \
                  "test__myXCLASSFit____demo-from-manual__PSO.py", \
                  "test__myXCLASSFit____demo-from-manual__SA.py", \
                  "test__myXCLASSFit____dust-continuum-fit.py", \
                  "test___myXCLASS+myXCLASSFit____Compare.py", \
                  "test__myXCLASSMapFit____demo.py", \
                  "test__LineIdentification____demo.py"]


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## get command line argruments
UpdateFlag = ""
if (len(sys.argv) > 1):                                                                     ## check, if command line arguments are defined
    for argument in sys.argv[1:]:                                                           ## loop over all command line arguments
        if (argument.lower() == "--update"):
            UpdateFlag = argument.lower()


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## do tests
counter = (-1)
for testDir in TestDirectoryList:
    counter += 1


    ## print what you do
    print "Execute test function " + testDir + " .. ",
    sys.stdout.flush()


    ## execute test functions
    cmdString = "cd " + testDir + "/; "
    cmdString += "python " + TestScriptList[counter] + " " + UpdateFlag + " > screen.out; "
    cmdString += "cd ../../;"
    os.system(cmdString)


    ## read in screen file
    ScreenFile = open(testDir + "/screen.out")
    ScreenFileContents = ScreenFile.readlines()
    ScreenFile.close()

    
    ## is the test case done sucessfully?
    OKFlag = 0
    for line in ScreenFileContents:
        if (line.find("I D E N T I C A L") > (-1)):
            OKFlag = 1
            break
        elif (line.find("N O   comparison!") > (-1)):
            OKFlag = 2
            break

    if (OKFlag == 1):
        print "done!    Results are  I D E N T I C A L  to previous result!"
    elif (OKFlag == 0):
        print "done!    The data sets are  N O T  identical!"
    else:
        print "done!"


