#!/usr/bin/python
# -*- coding: utf-8 -*-
##********************************************************************************************************************************************************
##
##  test-routine:   Check MAGIX function with generalized Drude-Lorentz model
##
##
##
##
##  Copyright (C) 2015 - 2016
##
##  I. Physikalisches Institut, University of Cologne
##
##
##
##  Who           When         What
##
##  T. Moeller    26.03.2015   initial version
##
##********************************************************************************************************************************************************


##********************************************************************* load packages ********************************************************************
import numpy                                                                                ## import numpy package
import os                                                                                   ## import os package
import sys                                                                                  ## import sys package
import matplotlib
import pylab
##--------------------------------------------------------------------------------------------------------------------------------------------------------


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## define current working directory
LocalPath = os.getcwd() + "/"


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## extend sys.path variable, if necessary
XCLASSBaseDir = LocalPath + "../../../../"
XCLASSBaseDir = os.path.normpath(XCLASSBaseDir) + "/"
CASAFlag = True
try:
    # import taskinit
    tasklist()
    import MAGIX as task_MAGIX
    import LoadASCIIFile as task_LoadASCIIFile
except:
    CASAFlag = False
    NewModulesPaths = [XCLASSBaseDir + "build_tasks/"]
    for NewModule in NewModulesPaths:
        already_included_flag = "false"
        for entries in sys.path:
            if (entries == NewModule):
                already_included_flag = "true"
                break
        if (already_included_flag == "false"):
            sys.path.append(NewModule)


    ## import module task_MAGIX
    import task_MAGIX
    import task_LoadASCIIFile


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## get command line argrument
UpdateFlag = False
if (len(sys.argv) > 1):                                                                     ## check, if command line arguments are defined
    for argument in sys.argv[1:]:                                                           ## loop over all command line arguments
        if (argument.lower() == "--update"):
            UpdateFlag = True
            break


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## general settings
DoPlotFlag = True
CompareFlag = True
DiffTolerance = 1.e-3


## define parameters for line ID
MAGIXExpXML = LocalPath + "Reflectance_Data.xml"
MAGIXInstanceXML = LocalPath + "parameters.xml"
MAGIXFitXML = LocalPath + "algorithm-settings.xml"
MAGIXRegXML = XCLASSBaseDir + "programs/MAGIX/Fit-Functions/Drude-Lorentz_general/xml/Generalized_Drude-Lorentz__sym__freq-damping+Rp.xml"
MAGIXOption = ""


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## start line identification routine
JobDir = task_MAGIX.MAGIX(MAGIXExpXML, MAGIXInstanceXML, MAGIXFitXML, MAGIXRegXML, MAGIXOption)


##========================================================================================================================================================
##
## FOR TESTING: Create a plot
##
##========================================================================================================================================================
if (DoPlotFlag):
    print "\n\nCreate a plot ..\n\n"


    ## create final plot
    ResultPath = "plot/"
    os.system("rm -rf " + ResultPath + "; mkdir " + ResultPath)
    fig = pylab.figure(figsize=(15, 10))
    fig.clear()
    pylab.subplots_adjust(hspace=0.1, wspace=0.2)
    RestFreq = 0.0
    vLSR = 0.0


    ## import observational and modeled data
    FileName = JobDir + "Reflectance_Polarization_00__010K.dat"
    NumHeaderLines = 0
    expdata = task_LoadASCIIFile.LoadASCIIFile(FileName, NumHeaderLines, RestFreq, vLSR)
    FileName = JobDir + "Reflectance_Polarization_00__010K.LM.out.dat"
    NumHeaderLines = 0
    modeldata = task_LoadASCIIFile.LoadASCIIFile(FileName, NumHeaderLines, RestFreq, vLSR)


    ## create first subplot
    layer = pylab.subplot(3, 1, 1)
    layer.grid(True)
    layer.set_title("MAGIX function:  generalized Drude-Lorentz function check")
    layer.set_ylabel(r"Reflectance")
    layer.plot(expdata[:, 0], expdata[:, 2], '-', color='black', linewidth=3.0, label='obs. data', drawstyle='steps-mid')
    layer.plot(modeldata[:, 0], modeldata[:, 2], '-', color='red', linewidth=2.0, label = 'fit')
    layer.set_xlim(modeldata[0, 0], modeldata[-1, 0])
    layer.xaxis.set_major_formatter(matplotlib.ticker.FormatStrFormatter('%.5e'))
    layer.legend()


    ## import observational and modeled data
    FileName = JobDir + "Reflectance_Polarization_30__010K.dat"
    NumHeaderLines = 0
    expdata = task_LoadASCIIFile.LoadASCIIFile(FileName, NumHeaderLines, RestFreq, vLSR)
    FileName = JobDir + "Reflectance_Polarization_30__010K.LM.out.dat"
    NumHeaderLines = 0
    modeldata = task_LoadASCIIFile.LoadASCIIFile(FileName, NumHeaderLines, RestFreq, vLSR)


    ## create second subplot
    layer = pylab.subplot(3, 1, 2)
    layer.grid(True)
    layer.set_ylabel(r"Reflectance")
    layer.plot(expdata[:, 0], expdata[:, 2], '-', color='black', linewidth=3.0, label='obs. data', drawstyle='steps-mid')
    layer.plot(modeldata[:, 0], modeldata[:, 2], '-', color='red', linewidth=2.0, label = 'fit')
    layer.set_xlim(modeldata[0, 0], modeldata[-1, 0])
    layer.xaxis.set_major_formatter(matplotlib.ticker.FormatStrFormatter('%.5e'))
    layer.legend()


    ## import observational and modeled data
    FileName = JobDir + "Reflectance_Polarization_90__010K.dat"
    NumHeaderLines = 0
    expdata = task_LoadASCIIFile.LoadASCIIFile(FileName, NumHeaderLines, RestFreq, vLSR)
    FileName = JobDir + "Reflectance_Polarization_90__010K.LM.out.dat"
    NumHeaderLines = 0
    modeldata = task_LoadASCIIFile.LoadASCIIFile(FileName, NumHeaderLines, RestFreq, vLSR)


    ## create third subplot
    layer = pylab.subplot(4, 1, 4)
    layer.grid(True)
    layer.set_ylabel(r"Reflectance")
    layer.set_xlabel("Rest Frequency [MHz]")
    layer.plot(expdata[:, 0], expdata[:, 2], '-', color='black', linewidth=3.0, label='obs. data', drawstyle='steps-mid')
    layer.plot(modeldata[:, 0], modeldata[:, 2], '-', color='red', linewidth=2.0, label = 'fit')
    layer.set_xlim(modeldata[0, 0], modeldata[-1, 0])
    layer.xaxis.set_major_formatter(matplotlib.ticker.FormatStrFormatter('%.5e'))
    layer.legend()


    ## save plot
    pylab.savefig(ResultPath + "/MAGIX____check.png", dpi=300)
    pylab.draw()
    pylab.close(fig)


##========================================================================================================================================================
##
## FOR TESTING: Compare result with previous results
##
##========================================================================================================================================================
if (CompareFlag):
    print "\n\nCompare result with previous results .."
    ModelFileList = ["Reflectance_Polarization_00__010K.LM.out.dat", "Reflectance_Polarization_30__010K.LM.out.dat", \
                     "Reflectance_Polarization_90__010K.LM.out.dat"]


    UnequalPointCounter = 0
    for ModelFiles in ModelFileList:


        ##------------------------------------------------------------------------------------------------------------------------------------------------
        ## read in model data from test-run
        TestData = numpy.loadtxt(LocalPath + "reference_run/" + ModelFiles)
        modeldata = numpy.loadtxt(JobDir + "/" + ModelFiles)


        ##------------------------------------------------------------------------------------------------------------------------------------------------
        ## compare result of the ArH+ fit with test-run
        NumTestDataPoints = len(TestData)
        if (NumTestDataPoints != len(modeldata)):
            print "\n\n\n\t\tThe data sets have unequal number of data points!"
            print "\t\tNumber of current data set:   ", len(modeldata)
            print "\t\tNumber of reference data set: ", NumTestDataPoints
            print "\n\n\n\n"
            sys.exit(0)
        for i in xrange(NumTestDataPoints):
            TestLine = TestData[i]
            CurrentFitLine = modeldata[i]

            # Debug:
            # print "TestLine       = ", TestLine
            # print "CurrentFitLine = ", CurrentFitLine
            # print "------------------------------------------------------------------"


            if (abs(TestLine[0] - CurrentFitLine[0]) > DiffTolerance or abs(TestLine[1] - CurrentFitLine[1]) > DiffTolerance):
                UnequalPointCounter += 1

                print "\t\tUnequal results:"
                print "\t\tTestLine       = ", TestLine
                print "\t\tCurrentFitLine = ", CurrentFitLine
                print "------------------------------------------------------------------"


    ## print result of comparison
    if (not UpdateFlag):
        UpdateFlag = False
    if (UnequalPointCounter > 0):
        print "\n\n\n\tThe data sets are  N O T  identical!\n\n\n"
    else:
        print "\n\n\tResults are  I D E N T I C A L  to previous result!\n\n\n"
        UpdateFlag = True


        ## write status file for CASA
        if (CASAFlag):
            CASAFile = open("comparison.txt", 'w')
            CASAFile.write("identical\n")
            CASAFile.close()


    ## update reference directory
    if (UpdateFlag):
        print "Update reference files ..",
        cmdString = "rm -f " + LocalPath + "reference_run/*; cp " + JobDir + "/* " + LocalPath + "reference_run/; rm -rf " + JobDir
        os.system(cmdString)
        print "done!"
        UpdateFlag = False


## update reference directory
if (UpdateFlag):
    print "Update reference files ..",
    cmdString = "rm -f " + LocalPath + "reference_run/*; cp " + JobDir + "/* " + LocalPath + "reference_run/; rm -rf " + JobDir
    os.system(cmdString)
    print "done!"



