#!/usr/bin/python
# -*- coding: utf-8 -*-
##********************************************************************************************************************************************************
##
##  test-routine:   Check result of LineID function
##
##
##
##
##  Copyright (C) 2016
##
##  I. Physikalisches Institut, University of Cologne
##
##
##
##  Who           When         What
##
##  T. Moeller    29.07.2014   initial version
##  T. Moeller    24.02.2016   improved version
##
##********************************************************************************************************************************************************


##********************************************************************* load packages ********************************************************************
import numpy                                                                                ## import numpy package
import os                                                                                   ## import os package
import sys                                                                                  ## import sys package
import matplotlib                                                                           ## import matplotlib
import pylab                                                                                ## import pylab
##--------------------------------------------------------------------------------------------------------------------------------------------------------


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## define current working directory
LocalPath = os.getcwd() + "/"


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## extend sys.path variable, if necessary
XCLASSBaseDir = LocalPath + "../../../../"
XCLASSBaseDir = os.path.normpath(XCLASSBaseDir) + "/"
CASAFlag = True
try:
    # import taskinit
    tasklist()
    import LineIdentification as task_LineIdentification
except:
    CASAFlag = False
    NewModulesPaths = [XCLASSBaseDir + "build_tasks/"]
    for NewModule in NewModulesPaths:
        already_included_flag = "false"
        for entries in sys.path:
            if (entries == NewModule):
                already_included_flag = "true"
                break
        if (already_included_flag == "false"):
            sys.path.append(NewModule)


    ## import task_myXCLASS and task_LoadASCIIFile packages
    import task_LineIdentification


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## get command line argrument
UpdateFlag = False
if (len(sys.argv) > 1):                                                                     ## check, if command line arguments are defined
    for argument in sys.argv[1:]:                                                           ## loop over all command line arguments
        if (argument.lower() == "--update"):
            UpdateFlag = True
            break


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## general settings
CompareFlag = True
DiffTolerance = 1.e-2


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## define parameters for line ID
MaxOverestimationHeight = 500.0
Tolerance = 65.0
Noise = 0.5
SourceName = ""
StrongMoleculeList = []
DefaultMolfitFile = XCLASSBaseDir + "demo/LineIdentification/demo__default.molfit"
AlgorithmXMLFileSMF =  XCLASSBaseDir + "demo/LineIdentification/algorithm-settings___LM.xml"
AlgorithmXMLFileOverAll = XCLASSBaseDir + "demo/LineIdentification/algorithm-settings___LM__Final.xml"
experimentalData = LocalPath + "demo.xml"
EstimateParamFlag = True


## not necessary, if xml file is used
NumberIteration = 10                                                                        ## define number of iterations for LM algorithm
vLSR = 0.0
TelescopeSize = 1.0
Inter_Flag = False
tBack = 1.0
tSlope = 1.0
N_H = 1.0
beta_dust = 1.0
kappa_1300 = 1.0
MinColumnDensityEmis = 1.e1
MinColumnDensityAbs = 1.e1
clusterdef = ""


## reduce number of molecules to speed up identification process for testing
SelectedMolecules = ["HCCCN;v=0;", "CH3OH;v=0;", "C2H5OH;v=0;", "CH3CN;v=0;", "SO;v=0;", "SO2;v=0;"]


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## start line identification routine
IdentifiedLines, JobDir = task_LineIdentification.LineIdentification(Noise, MaxOverestimationHeight, SourceName, DefaultMolfitFile, Tolerance, \
                                                                     SelectedMolecules, StrongMoleculeList, MinColumnDensityEmis, MinColumnDensityAbs, \
                                                                     NumberIteration, AlgorithmXMLFileSMF, AlgorithmXMLFileOverAll, experimentalData, \
                                                                     vLSR, TelescopeSize, Inter_Flag, tBack, tSlope, N_H, beta_dust, kappa_1300, \
                                                                     clusterdef)


##========================================================================================================================================================
##
## FOR TESTING: Compare result with previous results
##
##========================================================================================================================================================
if (CompareFlag):
    print "\n\nCompare result with previous results .."


    ##----------------------------------------------------------------------------------------------------------------------------------------------------
    ## read in model data from reference and current run
    TestData = numpy.loadtxt(LocalPath + "reference_run/all/SyntheticData.LM.out.dat")
    modeldata = numpy.loadtxt(JobDir + "all/SyntheticData.LM.out.dat")


    ##----------------------------------------------------------------------------------------------------------------------------------------------------
    ## compare result of the ArH+ fit with test-run
    NumTestDataPoints = len(TestData)
    if (NumTestDataPoints != len(modeldata)):
        print "\n\n\n\t\tThe data sets have unequal number of data points!"
        print "\t\tNumber of current data set:   ", len(modeldata)
        print "\t\tNumber of reference data set: ", NumTestDataPoints
        print "\n\n\n\n"
        sys.exit(0)
    UnequalPointCounter = 0
    for i in xrange(NumTestDataPoints):
        TestLine = TestData[i]
        CurrentFitLine = modeldata[i]

        # Debug:
        # print "TestLine       = ", TestLine
        # print "CurrentFitLine = ", CurrentFitLine
        # print "------------------------------------------------------------------"


        if (abs(TestLine[0] - CurrentFitLine[0]) > DiffTolerance or abs(TestLine[1] - CurrentFitLine[1]) > DiffTolerance):
            UnequalPointCounter += 1

            print "\t\tUnequal results:"
            print "\t\tTestLine       = ", TestLine
            print "\t\tCurrentFitLine = ", CurrentFitLine
            print "------------------------------------------------------------------"


    ## print result of comparison
    UpdateFlag = False
    if (UnequalPointCounter > 0):
        print "\n\n\n\tThe data sets are   N O T   identical!\n\n\n"
    else:
        print "\n\n\tResults are   I D E N T I C A L   to previous result!\n\n\n"
        UpdateFlag = True


        ## write status file for CASA
        if (CASAFlag):
            CASAFile = open("comparison.txt", 'w')
            CASAFile.write("identical\n")
            CASAFile.close()


## update reference directory
if (UpdateFlag):
    print "Update reference files ..",
    cmdString = "rm -fr " + LocalPath + "reference_run/*; cp -r " + JobDir + "/* " + LocalPath + "reference_run/; rm -rf " + JobDir
    os.system(cmdString)
    print "done!"

