#!/usr/bin/python
# -*- coding: utf-8 -*-
##********************************************************************************************************************************************************
##
##  Generate synthetic spectrum
##
##
##
##
##  Copyright (C) 2014 - 2016
##
##  I. Physikalisches Institut, University of Cologne
##
##
##  Produced for Line ID function test
##
##
##
##  Who           When         What
##
##  T. Moeller    06.05.2014   initial version
##
##********************************************************************************************************************************************************


##********************************************************************* load packages ********************************************************************
import numpy                                                                                ## import numpy package
import numpy                                                                                ## import numpy package
import os                                                                                   ## import os package
import sys                                                                                  ## import sys package
import matplotlib
# matplotlib.rcParams['backend'] = 'Agg'                                                      ## disable GUI window
import pylab
##--------------------------------------------------------------------------------------------------------------------------------------------------------


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## extend sys.path variable, if necessary
NewModulesPaths = ["/home/moeller/ALMA/CASA/myXCLASS-CASA-Interface/NR-version/Linux/developer/build_tasks/"]
for NewModule in NewModulesPaths:
    already_included_flag = "false"
    for entries in sys.path:
        if (entries == NewModule):
            already_included_flag = "true"
            break
    if (already_included_flag == "false"):
        sys.path.append(NewModule)


## import module task_LineIdentification
import task_myXCLASS


## define current working directory
RootDir = os.getcwd() + "/"


## use myXLCASS to generate spectrum
FreqMin = 342281.0
FreqMax = 349243.0
FreqStep = 1.0
TelescopeSize = 350.0
Inter_Flag = False
t_back_flag = True
tBack = 1.0
tslope = 0.0
nH_flag = True
N_H = 1.4e+23
beta_dust = 1.4
kappa_1300 = 0.0
MolfitsFileName = RootDir + "all.molfit"
iso_flag = False
IsoTableFileName = "demo/myXCLASS/iso_names.txt"
RestFreq = 0.0
vLSR = 0.0

modeldata, log, trans, IntOptical, JobDir = task_myXCLASS.myXCLASS(FreqMin, FreqMax, FreqStep, TelescopeSize, Inter_Flag, t_back_flag, tBack, \
                                                                   tslope, nH_flag, N_H, beta_dust, kappa_1300, MolfitsFileName, iso_flag, \
                                                                   IsoTableFileName, RestFreq, vLSR)
# Debug:
# print "trans = ", trans


## save generated spectrum to file
numpy.savetxt(RootDir + "SyntheticData.dat", modeldata, delimiter='\t')


## copy to parent directory
cmdstring = "cp " + RootDir + "SyntheticData.dat ../"
os.system(cmdstring)


## produce plots for each spectra
fig = pylab.figure(figsize=(29, 12))
fig.clear()
pylab.subplots_adjust(left=0.04, right=0.99, top=0.96, bottom=0.06, hspace=0.45, wspace=0.2)
layer = pylab.subplot(1, 1, 1)
tl = pylab.title("synthetic spectrum")
layer.grid(True)
layer.set_ylabel(r"T$_{mb}$ [K]")
layer.set_xlabel("Rest Frequency [MHz]")
if (trans != []):
    for lines in trans:
        if (not lines[0].strip().startswith("%")):
            layer.axvline(x=float(lines[0]), color='blue', linewidth=1, linestyle='--')
layer.plot(modeldata[:, 0], modeldata[:, 1], '-', color='black', linewidth=3.0, label = 'generate spectrum')
layer.set_xlim(modeldata[0, 0], modeldata[-1, 0])
layer.set_ylim(-2.0, numpy.max(modeldata[:, 1]) * 1.03)
layer.legend()
pylab.savefig(RootDir + "Synthetic_spectrum__1.png", dpi=100)
pylab.draw()


