!*********************************************************************************************************************************************************
!>  Module:  GlobalVariables
!>
!>
!>  This module contains some global variables which are used in several other routine
!>  Copyright (C) 2012 - 2016  Thomas Moeller
!>
!>  I. Physikalisches Institut, University of Cologne
!>
!>
!>
!>  The following subroutines and functions are included in this module:
!>
!>      - subroutine strlen:                        subroutine to determine last non blank and non char(0) character of string st
!>
!>
!>
!>  Versions of the program:
!>
!>  Who           When        What
!>
!>  T. Moeller    30.05.2012  Initial version
!>
!>
!>
!>
!>  License:
!>
!>    GNU GENERAL PUBLIC LICENSE
!>    Version 3, 29 June 2007
!>    (Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>)
!>
!>
!>    This program is free software: you can redistribute it and/or modify
!>    it under the terms of the GNU General Public License as published by
!>    the Free Software Foundation, either version 3 of the License, or
!>    (at your option) any later version.
!>
!>    This program is distributed in the hope that it will be useful,
!>    but WITHOUT ANY WARRANTY; without even the implied warranty of
!>    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!>    GNU General Public License for more details.
!>
!>    You should have received a copy of the GNU General Public License
!>    along with this program.  If not, see <http://www.gnu.org/licenses/>.
!>
!---------------------------------------------------------------------------------------------------------------------------------------------------------
Module GlobalVariables

    use iso_fortran_env                                                                     !< only available for fortran 2003 and later
    use myXCLASSCore

    implicit none

    !< parameters read from molfit file
    integer, parameter :: MaxNumMol = 1000                                                  !< define max. number of molecules
    integer, parameter :: MaxNumComp = 1000                                                 !< define max. number of components
    character(len=4096) :: InstanceFileName                                                 !< path and file name of the instance file
    character(len=40), dimension(MaxNumMol) :: NameMolecule                                 !< name of the current molecule

    !< variables for rad-trans parameter
    integer :: NumberMoleculeRadTrans                                                       !< number of entries in table RadTrans
    integer, allocatable, dimension(:) :: UpperStateDegeneracy                              !< upper state degeneracy
    real*8, allocatable, dimension(:) :: lFreq                                              !< frequencies of transition
    real*8, allocatable, dimension(:) :: lFreqErr                                           !< uncertainty of frequencies of transition
    real*8, allocatable, dimension(:) :: lElt                                               !< energies of lower states
    real*8, allocatable, dimension(:) :: icatMol                                            !< intensity of the transitions
    real*8, allocatable, dimension(:) :: EinsteinA                                          !< Einstein A coefficients
    logical :: use_intensity_flag                                                           !< flag for using intensity instead of Einstein A coefficient
    logical :: nHFlagCommLine                                                               !< flag indicating that dust parameters are globally definied
end Module GlobalVariables
!*********************************************************************************************************************************************************
