#! /bin/bash
#
#
# install MAGIX in the current directory
#   Copyright (C) 2012 - 2016  Thomas Moeller
#
#  I. Physikalisches Institut, University of Cologne
#
#
# Usage:
#
# - Compile only the MPI versions:    "install.sh --mpi" or "install.sh --MPI" or "install.sh mpi" or "install.sh MPI"
# - Compile only the SMP versions:    "install.sh --smp" or "install.sh --SMP" or "install.sh smp" or "install.sh SMP"
# - Compile default version with MPI and myXCLASS version with SMP:
#                                     "install.sh --mpi+smp" or "install.sh --MPI+SMP" or "install.sh mpi+smp" or "install.sh MPI+SMP"
# - Compile default version with SMP and myXCLASS version with MPI:
#                                     "install.sh --smp+mpi" or "install.sh --SMP+MPI" or "install.sh smp+mpi" or "install.sh SMP+MPI"
# - Compile default version with MPI and myXCLASS version for GPU (requires PGI Fortran compiler and Nvidia graphic card):
#                                     "install.sh --mpi+gpu" or "install.sh --MPI+GPU" or "install.sh mpi+gpu" or "install.sh MPI+GPU"
# - Compile default version with SMP and myXCLASS version for GPU (requires PGI Fortran compiler and Nvidia graphic card):
#                                     "install.sh --smp+gpu" or "install.sh --SMP+GPU" or "install.sh smp+gpu" or "install.sh SMP+GPU"
#
#
#
#  Versions of the program:
#
#  Who           When        What
#
#  T. Moeller    08/03/2012  Initial version
#
#
#
#  License:
#
#    GNU GENERAL PUBLIC LICENSE
#    Version 3, 29 June 2007
#    (Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>)
#
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#*********************************************************************************************************************************************************


#---------------------------------------------------------------------------------------------------------------------------------------------------------
# depending on the command line arguments, compile algorithms with mpi, smp or gpu or combination of that techniques
defaultParallel="defaultsmp"
myxclassParallel="myxclasssmp"
if [ "$1" = "--mpi" -o "$1" = "--MPI" -o "$1" = "mpi" -o "$1" = "MPI" ]; then
    defaultParallel="defaultmpi"
    myxclassParallel="myxclassmpi"
elif [ "$1" = "--smp" -o "$1" = "--SMP" -o "$1" = "smp" -o "$1" = "SMP" ]; then
    defaultParallel="defaultsmp"
    myxclassParallel="myxclasssmp"
elif [ "$1" = "--mpi+smp" -o "$1" = "--MPI+SMP" -o "$1" = "mpi+smp" -o "$1" = "MPI+SMP" ]; then
    defaultParallel="defaultmpi"
    myxclassParallel="myxclasssmp"
elif [ "$1" = "--smp+mpi" -o "$1" = "--SMP+MPI" -o "$1" = "smp+mpi" -o "$1" = "SMP+MPI" ]; then
    defaultParallel="defaultsmp"
    myxclassParallel="myxclassmpi"

elif [ "$1" = "--mpi+gpu" -o "$1" = "--MPI+GPU" -o "$1" = "mpi+gpu" -o "$1" = "MPI+GPU" ]; then
    defaultParallel="defaultmpi"
    myxclassParallel="myxclassgpu"
elif [ "$1" = "--smp+mpi" -o "$1" = "--SMP+GPU" -o "$1" = "smp+gpu" -o "$1" = "SMP+GPU" ]; then
    defaultParallel="defaultsmp"
    myxclassParallel="myxclassgpu"
fi

# Debug
# echo 'defaultParallel = '$defaultParallel
# echo 'myxclassParallel = '$myxclassParallel


#---------------------------------------------------------------------------------------------------------------------------------------------------------
# compile all FORTRAN-algorithms
echo "Compile all FORTRAN-algorithms ... "
cd Modules/Levenberg-Marquardt/
make $defaultParallel
make $myxclassParallel
cd ../Simulated-Annealing/
make $defaultParallel
make $myxclassParallel
cd ../PSO/
make $defaultParallel
make $myxclassParallel
cd ../Bees/
make $defaultParallel
make $myxclassParallel
cd ../Nested-Sampling/
make $defaultParallel
make $myxclassParallel
cd ../Genetic/
make $defaultParallel
make $myxclassParallel
cd ../Model-Function_Call/
make $defaultParallel
make $myxclassParallel
cd ..
cd ..
echo "Compile all FORTRAN-algorithms ... done!"


#---------------------------------------------------------------------------------------------------------------------------------------------------------
# compile model function
echo "Compile model function ... "
cd Fit-Functions/Drude-Lorentz_conv/
make all
cd ../..
echo "Compile model function ... done!"

