#!/usr/bin/python
# -*- coding: utf-8 -*-
##********************************************************************************************************************************************************
##
##  This module converts a fits file to an ASCII file using pyfits
##  Copyright (C) 2009 - 2016  Thomas Moeller
##
##  I. Physikalisches Institut, University of Cologne
##
##
##
##  Versions of the program:
##
##  Who           When         What
##
##  T. Moeller    14.02.2013   initial version
##
##
##
##  License:
##
##    GNU GENERAL PUBLIC LICENSE
##    Version 3, 29 June 2007
##    (Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>)
##
##
##    This program is free software: you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation, either version 3 of the License, or
##    (at your option) any later version.
##
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with this program.  If not, see <http://www.gnu.org/licenses/>.
##
##********************************************************************************************************************************************************


##******************************************************************** load packages *********************************************************************
import numpy                                                                                ## import numpy package
import os.path                                                                              ## load package for file management
import os                                                                                   ## import os package
import string                                                                               ## load string package
import shutil                                                                               ## import shutil package
import sys                                                                                  ## import sys package


## import pyfits package via astropy
try:
    import astropy.io.fits as pyfits
except ImportError:
    import pyfits
##--------------------------------------------------------------------------------------------------------------------------------------------------------


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## get OnlyYColumn
OnlyYColumn = sys.argv[1]


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## set print flag
printflag = "false"


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## get FitsFilename
## if FitsFilename ends with .dat the output file is written in fits format
## else
## if FitsFilename ends with .fits the output file is written in dat format
FitsFilename = sys.argv[2]                                                                  ## get fits file name
if not FitsFilename.endswith(".dat"):
    if not FitsFilename.endswith(".fits"):
        print " "
        print "\t   Error in fits2dat subroutine!"
        print "\t     The selected file ",FitsFilename
        print "\t     is neither a fits nor a dat-file!"
        print "\t     Please correct registration file!"
        print " "
        sys.exit(0)


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## check, if filename exists
if (os.path.exists(FitsFilename) and os.path.isfile(FitsFilename)):


    ##--------------------------------------------------------------------------------------------------------------------------------------------------------
    ## open fits-file using pyfits
    hdulist = pyfits.open(FitsFilename)                                                     ## open fits file
    fitsdata = hdulist[0].data                                                              ## read fits data
    dimension = fitsdata.shape                                                              ## determine length in each dimension
    NumDimensions = len(dimension)                                                          ## determine dimension of fits file

    # Debug:
    # print "dimension = ", dimension


    ##--------------------------------------------------------------------------------------------------------------------------------------------------------
    ## open dat-file name
    CurrentPath = os.getcwd() + "/"
    DatFilename = FitsFilename.replace(".fits", ".dat")                                     ## define dat-file name
    DatFilename = DatFilename.strip()
    if (DatFilename == ""):
        print "\n\n\n\t Error in subroutine fits2dat.py:"
        print "\t\t The given file name is empty. DatFilename = ", DatFilename
        print "\n\n"
        sys.exit(0)
    else:
        if (DatFilename[0] == "/"):
            DatFile = open(DatFilename, "w")                                                ## open dat-file name without extended file name
        else:
            DatFile = open(CurrentPath + DatFilename, "w")                                  ## open dat-file name with extended file name


    ##--------------------------------------------------------------------------------------------------------------------------------------------------------
    ## read header information
    ## get number of axes
    try:
        NAXIS = pyfits.getval(FitsFilename, 'NAXIS', 0)
    except KeyError, err:
        NAXIS = 1

    # Debug:
    # print 'NAXIS = ',NAXIS


    ## read further header information
    crpix = []
    crval = []
    cdelt = []
    length = []
    NumDimensions = 0
    for i in xrange(NAXIS):                                                                 ## loop over all axis
        try:
            lenAxis = pyfits.getval(FitsFilename, 'NAXIS' + str(i + 1), 0)                  ## read CRPIX
        except KeyError, err:
            lenAxis = 1
        if (lenAxis > 0):                                                                   ## read only those entries with more than 1 point
            length.append(lenAxis)
            NumDimensions += 1

            try:
                crpixValue = pyfits.getval(FitsFilename, 'CRPIX' + str(i + 1), 0)           ## read CRPIX
            except KeyError, err:
                crpixValue = 1
            crpix.append(crpixValue)

            try:
                crpvalValue = pyfits.getval(FitsFilename, 'CRVAL' + str(i + 1), 0)          ## read CRVAL
            except KeyError, err:
                crpvalValue = 1
            crval.append(crpvalValue)

            try:
                cdeltValue = pyfits.getval(FitsFilename, 'CDELT' + str(i + 1), 0)           ## read CDELT
            except KeyError, err:
                cdeltValue = 1
            cdelt.append(cdeltValue)

    length = fitsdata.shape

    # Debug:
    # print 'length = ',length
    # print 'crpix = ',crpix
    # print 'crval = ',crval
    # print 'cdelt = ',cdelt
    # print "lenAxis = ", lenAxis


    ##--------------------------------------------------------------------------------------------------------------------------------------------------------
    ## write data to dat file depending on the dimension of the fits file
    if (NumDimensions == 1):
        ValueOfFirstPoint1 = crval[0] - ((crpix[0] - 1) * cdelt[0])                         ## calculate value at first pixel of axis 1

        for x in xrange(length[0]):
            if (OnlyYColumn == "y"):
                line = "%.16e" % fitsdata[x]
            else:
                line = "%.16e %.16e" % (ValueOfFirstPoint1 + (x * cdelt[0]), fitsdata[x])
            DatFile.write(line + "\n")

    elif (NumDimensions == 2):
        ValueOfFirstPoint1 = crval[0] - ((crpix[0] - 1) * cdelt[0])                         ## calculate value at first pixel of axis 1

        for x in xrange(length[0]):
            ValueOfFirstPoint2 = crval[1] - ((crpix[1] - 1) * cdelt[1])                     ## calculate value at first pixel of axis 2

            for y in xrange(length[1]):
                if (OnlyYColumn == "y"):
                    line = "%.16e" % fitsdata[x,y]
                else:
                    line = "%.16e %.16e %.16e" % (ValueOfFirstPoint1 + (x * cdelt[0]), ValueOfFirstPoint2 + (y * cdelt[1]), fitsdata[x,y])
                DatFile.write(line + "\n")

    elif (NumDimensions == 3):
        ValueOfFirstPoint1 = crval[0] - ((crpix[0] - 1) * cdelt[0])                         ## calculate value at first pixel of axis 1

        for x in xrange(length[0]):
            ValueOfFirstPoint2 = crval[1] - ((crpix[1] - 1) * cdelt[1])                     ## calculate value at first pixel of axis 2

            for y in xrange(length[1]):
                ValueOfFirstPoint3 = crval[2] - ((crpix[2] - 1) * cdelt[2])                 ## calculate value at first pixel of axis 3

                for z in xrange(length[2]):
                    if (OnlyYColumn == "y"):
                        line = "%.16e" % fitsdata[x,y,z]
                    else:
                        line = "%.16e %.16e %.16e %.16e" % (ValueOfFirstPoint1 + (x * cdelt[0]), ValueOfFirstPoint2 + (y * cdelt[1]), \
                                                                                    ValueOfFirstPoint3 + (z * cdelt[2]), fitsdata[x,y,z])
                    DatFile.write(line + "\n")

    elif (NumDimensions == 4):
        ValueOfFirstPoint1 = crval[0] - ((crpix[0] - 1) * cdelt[0])                         ## calculate value at first pixel of axis 1

        for x in xrange(length[0]):
            ValueOfFirstPoint2 = crval[1] - ((crpix[1] - 1) * cdelt[1])                     ## calculate value at first pixel of axis 2

            for y in xrange(length[1]):
                ValueOfFirstPoint3 = crval[2] - ((crpix[2] - 1) * cdelt[2])                 ## calculate value at first pixel of axis 3

                for z in xrange(length[2]):
                    ValueOfFirstPoint4 = crval[3] - ((crpix[3] - 1) * cdelt[3])             ## calculate value at first pixel of axis 4

                    for t in xrange(length[3]):

                        # Debug:
                        # print "ValueOfFirstPoint1 = ", ValueOfFirstPoint1
                        # print "ValueOfFirstPoint2 = ", ValueOfFirstPoint2
                        # print "ValueOfFirstPoint3 = ", ValueOfFirstPoint3
                        # print "ValueOfFirstPoint4 = ", ValueOfFirstPoint4
                        # print "ValueOfFirstPoint1 + (x * cdelt[0]) = ", ValueOfFirstPoint1 + (x * cdelt[0])
                        # print "ValueOfFirstPoint2 + (y * cdelt[1]) = ", ValueOfFirstPoint2 + (y * cdelt[1])
                        # print "ValueOfFirstPoint3 + (z * cdelt[2]) = ", ValueOfFirstPoint3 + (z * cdelt[2])
                        # print "ValueOfFirstPoint4 + (t * cdelt[3]) = ", ValueOfFirstPoint4 + (t * cdelt[3])
                        # print "x, y, z, t = ", x, y, z, t
                        # print "fitsdata[x,y,z,t] = ", fitsdata[x,y,z,t]
                        # print "fitsdata = ", fitsdata

                        if (OnlyYColumn == "y"):
                            line = "%.16e" % fitsdata[x,y,z,t]
                        else:
                            line = "%.16e %.16e %.16e %.16e %.16e" % (ValueOfFirstPoint1 + (x * cdelt[0]), ValueOfFirstPoint2 + (y * cdelt[1]), \
                                                    ValueOfFirstPoint3 + (z * cdelt[2]), ValueOfFirstPoint4 + (t * cdelt[3]), fitsdata[x, y, z, t])
                        DatFile.write(line + "\n")

else:
    ##----------------------------------------------------------------------------------------------------------------------------------------------------
    ## open dat-file name
    CurrentPath = os.getcwd() + "/"
    DatFilename = FitsFilename.replace(".fits", ".dat")                                     ## define dat-file name
    DatFilename = DatFilename.strip()
    if (DatFilename == ""):
        print "\n\n\n\t Error in subroutine fits2dat.py:"
        print "\t\t The given file name is empty. DatFilename = ", DatFilename
        print "\n\n"
        sys.exit(0)
    else:
        if (DatFilename[0] == "/"):
            DatFile = open(DatFilename, "w")                                                ## open dat-file name without extended file name
        else:
            DatFile = open(CurrentPath + DatFilename, "w")                                  ## open dat-file name with extended file name
    DatFile.write("\n")                                                                     ## write dummy line


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## close dat file
DatFile.close()


##
##
## program finished
##
##



