!*********************************************************************************************************************************************************
!>  Module:  Variables
!>
!>
!>  This module contains some global variables which are used in several other modules
!>  Copyright (C) 2009 - 2016  Thomas Moeller
!>
!>  I. Physikalisches Institut, University of Cologne
!>
!>
!>
!>  Versions of the program:
!>
!>  Who           When        What
!>
!>  T. Moeller    30/11/2009  Initial version
!>
!>
!>
!>  License:
!>
!>    GNU GENERAL PUBLIC LICENSE
!>    Version 3, 29 June 2007
!>    (Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>)
!>
!>
!>    This program is free software: you can redistribute it and/or modify
!>    it under the terms of the GNU General Public License as published by
!>    the Free Software Foundation, either version 3 of the License, or
!>    (at your option) any later version.
!>
!>    This program is distributed in the hope that it will be useful,
!>    but WITHOUT ANY WARRANTY; without even the implied warranty of
!>    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!>    GNU General Public License for more details.
!>
!>    You should have received a copy of the GNU General Public License
!>    along with this program.  If not, see <http://www.gnu.org/licenses/>.
!>
!---------------------------------------------------------------------------------------------------------------------------------------------------------
Module Variables

    implicit none
    integer, parameter :: logchannel = 11                                                   !< channel for the log file
    integer, parameter :: paramchannel = 12                                                 !< channel for the parameter file
    integer, parameter :: tempChannel = 13                                                  !< channel for the temporary files
    integer, parameter :: scratchChannel1 = 15                                              !< channel for the scratch files
    integer, parameter :: scratchChannel2 = 16                                              !< channel for the scratch files
    integer, parameter :: DataForFitFunctionChannel = 8000                                  !< channel for the input data of the fit functions
    integer, parameter :: ReadDataForFitFunctionChannel = 6000                              !< channel for reading data from the external program
    integer, parameter :: InputFileChannel = 4000                                           !< channel for input files
    integer, parameter :: Chi2Channel = 7000                                                !< channel for file including all chi**2 values

    integer :: QualityLimit                                                                 !< defines which positions should be used
    integer :: NumberExpFiles                                                               !< Number of Experimental Files
    integer :: modelnumber                                                                  !< model number
    integer :: NumberLinesChi2                                                              !< total number of entries within chi**2 file
    integer :: MaxColX                                                                      !< number of x columns of experimental data
    integer :: MaxColY                                                                      !< number of y columns of experimental data
    integer :: parameternumber                                                              !< number of model parameters
    integer :: NumberInputFiles                                                             !< number of input files for the external program
    integer :: NumberOutputFiles                                                            !< number of output files for the external program
    integer :: ParallelizationFlag                                                          !< number of used processors
    integer :: JobID                                                                        !< job-ID number
    integer :: MaxInputLines                                                                !< max number of lines in all input files
    integer :: MaxParameter                                                                 !< max number of parameters in a line of an input file
    integer :: ExternalThreadNumber                                                         !< contains the current thread number
    integer :: CurrentNumberLinesCalcReduction                                              !< current number of lines of CalculatedParameterSets array
    integer :: CurrentExpFile                                                               !< current index of exp-file
    integer :: CurrentYColumn                                                               !< current index of y-column
    integer :: NumberFreeParameter                                                          !< total number of free parameter
    integer :: MaxExpLength                                                                 !< max. number of exp. data points in a exp. file
    integer :: MaxNumberRanges                                                              !< max. number data ranges in a exp. file
    integer :: ParallezitionMethod                                                          !< kind of parallelization
    integer :: myrankOfMPI                                                                  !< only used for MPI version, copy of current thread number
    integer :: TotalNumberOfThreads                                                         !< total number of all available MPI threads
    integer, allocatable, dimension(:) :: lengthexpdata                                     !< number of lines of each experimental data
    integer, allocatable, dimension(:) :: NumberXColumns                                    !< number of 'x'-columns of each experimental data
    integer, allocatable, dimension(:) :: NumberYColumns                                    !< number of 'y'-columns of each experimental data
    integer, allocatable, dimension(:) :: NumberHeaderLines                                 !< number of header lines for each output file
    integer, allocatable, dimension(:) :: OutputFileFormat                                  !< format of the output file
    integer, allocatable, dimension(:) :: NumberRanges                                      !< number of ranges for each experimental file
    integer, allocatable, dimension(:) :: ConverterInfit                                    !< array for converting between total and effective param list

    real*8, parameter :: ParameterEqualityLimit = 1.d-6                                     !< limit for comparision of two parameters: below this limit
                                                                                            !< two parameters are equal
    real*8 :: ochisq                                                                        !< value of chi**2 of the last iteration
    real*8, allocatable, dimension(:) :: ValueEmptyOutputFile                               !< values of output array if output file is empty
    real*8, allocatable, dimension(:) :: LSRAdjustement                                     !< factor for LSRAdjustment
    real*8, allocatable, dimension(:) :: chisqValues                                        !< values of chi**2 ordered concerning thread number
    real*8, allocatable, dimension(:, :) :: BestSitesParamSet                               !< parameter set with best chi2
    real*8, allocatable, dimension(:, :) :: paramset                                        !< array containing the parameters
    real*8, allocatable, dimension(:, :, :, :) :: AtOnceFunction                            !< working array containing all fit function values
    real*8, allocatable, dimension(:, :, :, :) :: AtOnceGradient                            !< working array containing all gradient values of fit function
    real*8, allocatable, dimension(:, :) :: FirstPointExpData                               !< first point of each exp. data file
    real*8, allocatable, dimension(:, :) :: LastPointExpData                                !< last point of each exp. data file
    real*8, allocatable, dimension(:, :, :) :: expdatax                                     !< experimental data x
    real*8, allocatable, dimension(:, :, :) :: expdatay                                     !< experimental data y
    real*8, allocatable, dimension(:, :, :) :: expdatae                                     !< error of the experimental data
    real*8, allocatable, dimension(:, :, :) :: CalculatedParameterSets                      !< used for reduction of external model function call
    real*8, allocatable, dimension(:, :, :) :: MinRange                                     !< array containing lower ranges
    real*8, allocatable, dimension(:, :, :) :: MaxRange                                     !< array containing upper ranges
    real*8, allocatable, dimension(:, :, :, :) :: BestSitesModelValues                      !< array containing model function values of best position
    real*8, allocatable, dimension(:, :, :, :) :: BestSitesChi2Values                       !< array containing chi2 values of best position
    real*8, allocatable, dimension(:, :, :, :) :: ModelFunction                             !< contains the model function for all frequency ranges

    character(len=10) :: NaNReplaceString                                                   !< string which is used instead of NaN
    character(len=8192) :: currentpath                                                      !< contains the current working directory
    character(len=8192) :: StandardWorkingDirectory                                         !< standard magix working directory
    character(len=8192) :: TempDirectory                                                    !< magix temp directory
    character(len=512), allocatable, dimension(:) :: FitParameterName                       !< array containing the name of the fit parameters
    character(len=512), allocatable, dimension(:) :: FitParameterValue                      !< array containing the values of the fit parameters as string
    character(len=512), allocatable, dimension(:) :: CharacterForComments                   !< character indicating comments in the output file(s)
    character(len=512), allocatable, dimension(:) :: CharacterSeperatingColumns             !< character separating columns in the output file
    character(len=512), allocatable, dimension(:) :: ResamplingMethod                       !< method used for resampling
    character(len=512), allocatable, dimension(:) :: InterpolationMethod                    !< method used for interpolation

    logical :: RenormalizedChi2                                                             !< flag for using renormalized chi**2
    logical :: initflag                                                                     !< flag is true during initialization of the fit algorithm
    logical :: printflag                                                                    !< flag for screen output .true. (=yes) or .false. (=no)
    logical :: Gradientflag                                                                 !< flag for determine gradient of fit function
    logical :: PlotIterationFlag                                                            !< flag for ploting for each iteration step
    logical :: WriteChi2Flag                                                                !< flag for writing chi**2 values with corresponding parameter
                                                                                            !< set to file
    logical :: UseCalculationReduction                                                      !< flag for reduction of external model function call
    logical :: LastAlgorithmFlag                                                            !< flag for removing temp files from registration process
    logical :: AllInOneOutputFile                                                           !< flag for reading all model function values from one output
                                                                                            !< file
    logical :: NumOutputFilesEqualNumExpFiles                                               !< flag that model function reproduces exactly the exp. data
                                                                                            !< files, i.e. the number of output files is equal to the
                                                                                            !< number of exp. data files. 1st ouput file describes first
                                                                                            !< exp. data file etc.
    logical :: DontStoreModelFuncValuesFlag                                                 !< flag indicates if model function is stored for each
                                                                                            !< function call or not
    logical, allocatable, dimension(:) :: OnlyYColumn                                       !< flag for only y-column
    logical, allocatable, dimension(:) :: LSRAdjustementFitFlag                             !< flag for fitting lsr adjustement parameter
    logical, allocatable, dimension(:) :: NormalizationFlag                                 !< flag for normalize model function
    logical, allocatable, dimension(:) :: ExpData_reversed_flag                             !< flag for reversed order of exp. file
end Module Variables

