#!/usr/bin/python
# -*- coding: utf-8 -*-
##********************************************************************************************************************************************************
##
##  script for starting new myXCLASS Version
##  Copyright (C) 2012 - 2014  Thomas Moeller
##
##  I. Physikalisches Institut, University of Cologne
##
##
##
##
##
##
##  usage of the script:
##
##  start_myXCLASS.py \
##
##  (Additionally to the name of the xclass start script (start_myXCLASS.py) the command line has to include some additional parameters which are
##  explained in the next lines):
##
##
##  for performing modelling of the data with given parameter set (key-word: model):
##
##  "model " + pid + " " + NumFiles + " " + Numreange + " " + FreqMin[i][j] + " " + FreqMax[i][j] + " " + StepFreq[i][j] + " " + tBack[i][j]
##   + " " + tSlope[i][j] + " " + telescopeSize + nh + " " + DustBeta + " " + iso + " " + ModelParamFile
##
##  (The result of the modelling is stored in one final output file "model.dat".)
##
##
##
##  Versions of the program:
##
##  Who           When        What
##
##  T. Moeller    13.09.2012  Initial version
##
##
##
##  License:
##
##    GNU GENERAL PUBLIC LICENSE
##    Version 3, 29 June 2007
##    (Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>)
##
##
##    This program is free software: you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation, either version 3 of the License, or
##    (at your option) any later version.
##
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with this program.  If not, see <http://www.gnu.org/licenses/>.
##
##--------------------------------------------------------------------------------------------------------------------------------------------------------


##******************************************************************** load packages *********************************************************************
import sys                                                                                  ## load sys package
import os                                                                                   ## load os package
import string                                                                               ## load string package
##--------------------------------------------------------------------------------------------------------------------------------------------------------


##========================================================================================================================================================
## beginning of script



## read input parameters
try:
    myXCLASSInterfaceWorkingDir = sys.argv[1]
except IndexError:
    myXCLASSInterfaceWorkingDir = ""

# Debug:
# print 'mode: ',mode


## get working directory of MAGIX
#myXCLASSInterfaceWorkingDir = os.environ.get('myXCLASSInterfaceWorkingDir','')


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## check, if compiled myNewXCLASS version exsits in source directory and compile otherwise
myNewXCLASSSourcePath = myXCLASSInterfaceWorkingDir + "programs/myXCLASS/src/"             ## define source directory of new myXCLASS version
myNewXCLASSExe = "myNewXCLASS.exe"                                                          ## define name of executable
filename = myNewXCLASSSourcePath + myNewXCLASSExe                                           ## define full path and file name of executable

# Debug:
# print "filename = ", filename


## copy compiled new myXCLASS version FROM source directory
command_string = "cp " + filename + " ."
os.system(command_string)


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## open second input file and read in all import parameters
SecondInputFile = open("myNewXCLASS_additional.in", 'r')                                    ## open temp-file for each input file
NumFiles = int(SecondInputFile.readline())                                                  ## get number of experimental data files

# Debug:
# print 'iso = ',iso
# print 'NumFiles = ',NumFiles


## read iso flag
iso_flag = SecondInputFile.readline()                                                       ## read iso_flag
iso_flag = iso_flag.strip()
if (iso_flag == "y"):
    iso_flag = "t"
else:
    iso_flag = "f"


## read IsoTableFileName
IsoTableFileName = SecondInputFile.readline()                                               ## read file name of a ASCII file including the iso ratios
IsoTableFileName = IsoTableFileName.strip()                                                 ## between certain molecules
if (iso_flag != "f"):
    if (IsoTableFileName != ""):
        if not (os.path.exists(IsoTableFileName)):
            if (os.path.exists(myXCLASSInterfaceWorkingDir + "/" + IsoTableFileName)):
                IsoTableFileName = myXCLASSInterfaceWorkingDir + "/" + IsoTableFileName
            else:
                print " "
                print " "
                print "\t         Error in start script for the new myXCLASS program!"
                print "\t           The given iso-table file is not found."
                print "\t           Please check setting in the import xml file and restart MAGIX!"
                print " "
                print "\t         MAGIX is aborted!"
                sys.exit(0)


## read NumberProcessors
NumberProcessors = SecondInputFile.readline()                                               ## read number of processors which should be used by myXCLASS
NumberProcessors = str(int(NumberProcessors.strip()))


## read dbFilename
dbFilename = SecondInputFile.readline()                                                     ## read path and file name of sqlite3 database
dbFilename = dbFilename.strip()


## read further parameters
modelCounter = 0
NumOutputFiles = 0                                                                          ## reset counter for output files
for nf in xrange(NumFiles):                                                                 ## loop over all files
    NumOutputFiles += 1                                                                     ## increase counter for output files

    # Debug:
    # print 'Model file index = (',nf,"/",NumFiles,")"


    ## read name of observation file
    csoFile = SecondInputFile.readline()                                                    ## read name of observation file
    csoFile = csoFile.strip()


    ## get absolute path of observation file
    #ScreenOutput = os.path.abspath(csoFile)


    ## read number of ranges
    NumRange = int(SecondInputFile.readline())                                              ## get number of experimental data files

    # Debug:
    # print 'csoFile = ',csoFile
    # print 'NumRange = ',NumRange


    ## read parameters for each range
    FreqMinRange = []
    FreqMaxRange = []
    StepFreqRange = []
    t_back_flag = []
    tBackRange = []
    tSlopeRange = []
    nH_flag = []
    nHColumn = []
    DustBeta = []
    kappa = []
    for nr in xrange(NumRange):
        RangeLine = SecondInputFile.readline()
        RangeLineElements = RangeLine.split()
        i = 0
        for Elements in RangeLineElements:
            value = Elements.strip()
            i +=1

            ## FreqMin, FreqMax, FreqStep 
            if (i == 1):
                FreqMinRange.append(value)                                                  ## read start of the nrth-range
            elif (i == 2):
                FreqMaxRange.append(value)                                                  ## read end of the nrth-range
            elif (i == 3):
                StepFreqRange.append(value)                                                 ## read stepsize of the nrth-range


            ## background temperature and temperature slope
            elif (i == 4):
                tBackRange.append(value)                                                    ## read background temperature of the nrth-range
                if (float(value) == -9999.0):                                               ## a value less then zero indicate that background temp. and slope
                    t_back_flag.append("f")                                                 ## are given in the molfit file for each component
                else:
                    t_back_flag.append("t")                                                 ## otherwise global values are given here
            elif (i == 5):
                tSlopeRange.append(value)                                                   ## read temperature slope of the nrth-range


            ## Hydrogen column density, dust beta, kappa
            elif (i == 6):
                nHColumn.append(value)                                                      ## read Hydrogen column density of the nrth-range
                if (float(value) == -9999.0):                                               ## a value less then zero indicate that background temp. and slope
                    nH_flag.append("f")                                                     ## are given in the molfit file for each component
                else:
                    nH_flag.append("t")                                                     ## otherwise global values are given here
            elif (i == 7):
                DustBeta.append(value)                                                      ## read dust beta of the nrth-range
            elif (i == 8):
                kappa.append(value)                                                         ## read kappa of the nrth-range


    ## read size of telescope
    telescopeSize = SecondInputFile.readline()                                              ## read size of telescope for the nfth observation file
    telescopeSize = telescopeSize.strip()
    telsize = float(telescopeSize)                                                          ## set iso-flag
    telsize = str(abs(telsize))

    # Debug:
    # print 'FreqMin = ',FreqMinRange
    # print 'FreqMax = ',FreqMaxRange
    # print 'StepFreq = ',StepFreqRange
    # print 'telescopeSize = ',telescopeSize
    # print 't_back_flag = ', t_back_flag
    # print 'tBack = ',tBackRange
    # print 'tSlope = ',tSlopeRange
    # print 'nH_flag = ', nH_flag
    # print 'nHColumn = ',nHColumn
    # print 'DustBeta = ',DustBeta
    # print 'kappa = ',kappa
    # print 'iso_flag = ', iso_flag
    # print 'IsoTableFileName = ', IsoTableFileName
    # print 'NumberProcessors = ', NumberProcessors
    # print 'dbFilename = ', dbFilename
    # sys.exit(0)


    ##----------------------------------------------------------------------------------------------------------------------------------------------------
    ## calculate model for each range and append all model.dat files to one final ascii-file
    CounterRanges = 0
    for j in xrange(NumRange):
        CounterRanges += 1


        ##------------------------------------------------------------------------------------------------------------------------------------------------
        ## define command string including all parameters for the current observation file (i) and the current range (j)
        ##                          freq. min, freq. max, stepsize freq., telescope size, flag for background temperature
        ##                          background temperature, temperature slope,
        ##                          nH_flag, nHColumn, DustBeta, kappa
        commandLineParameters = " " + FreqMinRange[j] + " " + FreqMaxRange[j] + " " + StepFreqRange[j] + " " + telsize + " " + t_back_flag[j]


        ## check background temperature flag
        if (t_back_flag[j] == "t"):
            commandLineParameters +=  " " + tBackRange[j]+ " " + tSlopeRange[j]


        ## check H column density flag
        if (nH_flag[j] == "t"):
            commandLineParameters +=  " " + nH_flag[j] + " " + nHColumn[j] + " " + DustBeta[j] + " " + kappa[j]
        else:
            commandLineParameters +=  " " + nH_flag[j]


        ## add name of molfits file and iso-flag
        commandLineParameters += " " + "myNewXCLASS.in" + " " + iso_flag


        ## check H column density flag
        if (iso_flag == "t"):
            # commandLineParameters +=  " " + IsoTableFileName
            commandLineParameters +=  " myXClass_isoratios.dat"


        ## add name of molfits file and iso-flag
        commandLineParameters += " " + NumberProcessors + " " + dbFilename

        # Debug:
        # print 'commandLineParameters = ', commandLineParameters


        ##------------------------------------------------------------------------------------------------------------------------------------------------
        ## remove old model output and old inp file
        command_string = "rm -rf model.dat"
        os.system(command_string)
        # command_string = "rm -rf cmdline.parm"
        # os.system(command_string)


        ##------------------------------------------------------------------------------------------------------------------------------------------------
        ## using the following line the start program should work on a MAC as well ;-)
        # command_string = "echo " + commandLineParameters + " > cmdline.parm"
        # os.system(command_string)


        ##------------------------------------------------------------------------------------------------------------------------------------------------
        ## start new myXCLASS program to determine model function
        command_string = "./" + myNewXCLASSExe + " " + commandLineParameters + " > myNewXCLASS_screen.output "  #2>&1"
        os.system(command_string)

        # Debug:
        # print 'command_string = ', command_string
        # sys.exit(0)

        # command_string = "rm -rf cmdline.parm"
        # os.system(command_string)


        ##------------------------------------------------------------------------------------------------------------------------------------------------
        # check if model output file exists and expand name of the model output file with output counter
        dateiname = "xclass_spectrum_output.dat"
        if (os.path.exists(dateiname)):
            modelCounter += 1
            command_string = "mv  xclass_spectrum_output.dat model" + str(CounterRanges) + ".dat"
            os.system(command_string)
        else:
            print " "
            print " "
            print "\t         Error in start script for the new myXCLASS program!"
            print "\t           No output file was created for the given parameter file"
            print "\t           Please check parameter set and restart MAGIX!"
            print " "
            print "\t         MAGIX is aborted!"
            sys.exit(0)


        ##------------------------------------------------------------------------------------------------------------------------------------------------
        ## remove older model.dat file
        command_string = "rm -rf xclass_spectrum_output.dat"
        os.system(command_string)


    ##----------------------------------------------------------------------------------------------------------------------------------------------------
    ## append all model output files to one final ascii file
    if (modelCounter > 1):
        AppendCommandString = "cat"
        for i in xrange(NumRange):
            AppendCommandString += " model" + str(i + 1) + ".dat"
        AppendCommandString += " >> model_" + str(NumOutputFiles) + ".dat"
    else:
        AppendCommandString = "mv -f model*.dat model_" + str(NumOutputFiles) + ".dat"
    os.system(AppendCommandString)


    ##----------------------------------------------------------------------------------------------------------------------------------------------------
    ## clean up the directory: remove xclass script, input file and temp output files
    # command_string = "rm -rf myNewXCLASS.in"
    # os.system(command_string)
    # for i in xrange(NumRange):
    #     command_string = "rm -rf model" + str(i + 1) + ".dat"
    #     os.system(command_string)


##--------------------------------------------------------------------------------------------------------------------------------------------------------
## move screen output-file to working directory
# Debug:
# dateiname = "myNewXCLASS_mod_" + pid + ".output"
# if (os.path.exists(dateiname)):
#     command_string = "mv -f myNewXCLASS_data_" + pid + ".output " + workingdir + "/"
#     os.system(command_string)




