#!/usr/bin/python
# -*- coding: utf-8 -*-
##********************************************************************************************************************************************************
##
##  This module sends the query string to the sqlite3 database
##  Copyright (C) 2012 - 2016  Thomas Moeller
##
##  I. Physikalisches Institut, University of Cologne
##
##
##
##  The following functions are included in this module:
##
##      - function DatabaseQuery:                       function sends the query string to the sqlite3 database
##
##
##
##  Versions of the program:
##
##  Who           When         What
##
##  T. Moeller    25.07.2013   initial version
##
##
##
##  License:
##
##    GNU GENERAL PUBLIC LICENSE
##    Version 3, 29 June 2007
##    (Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>)
##
##
##    This program is free software: you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation, either version 3 of the License, or
##    (at your option) any later version.
##
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with this program.  If not, see <http://www.gnu.org/licenses/>.
##
##********************************************************************************************************************************************************


##********************************************************************* load packages ********************************************************************
import numpy                                                                                ## import numpy package
import os                                                                                   ## import os package
import sys                                                                                  ## import sys package
import string                                                                               ## import string package
import random                                                                               ## import random package
import datetime                                                                             ## import datetime package
import sqlite3                                                                              ## import sqlite3 package
##--------------------------------------------------------------------------------------------------------------------------------------------------------


##--------------------------------------------------------------------------------------------------------------------------------------------------------
##
## This function sends the query string to the sqlite3 database
##
def DatabaseQuery(QueryString):
    """

This function sends the given query string to the myXCLASS database.


input parameters:
-----------------

- QueryString:          the query string



output parameters:
------------------

- Contents:             screen output



Example:
--------

QueryString = "select PF_Name from Partitionfunctions"
Contents = DatabaseQuery()


    """


    ##====================================================================================================================================================
    ## connect to the sqlite3 database
    print " "
    print " "
    print "Reading data from sqlite3 database ..",
    sys.stdout.flush()


    ######################################################################################################################################################
    ## DO NOT EDIT OR REMOVE THE FOLLOWING LINE !!!!
    dbFilename = "/home/moeller/ALMA/CASA/myXCLASS-CASA-Interface/No-NR-version/Linux/XCLASS-Interface/Database/cdms_sqlite.db"
    ######################################################################################################################################################

    try:
        conn = sqlite3.connect(dbFilename)

        # Debug:
        # print " "
        # print "Connection to sqlite3 database %s established." % dbFilename
    except sqlite3.Error, e:
        print " "
        print "Can not connect to sqlite3 databse %s." % dbFilename
        print "Error: %d: %s" % (e.args[0], e.args[1])
        sys.exit(1)


    ##----------------------------------------------------------------------------------------------------------------------------------------------------
    ## read data from database
    cursor = conn.cursor()
    cursor.execute(QueryString)
    conn.commit()
    rows = cursor.fetchall()
    Contents = rows
    conn.close()


    ## finished
    print "done!"


    ## print to screen
    print " "
    print "Screen output:"
    for row in rows:                                                                        ## loop over all entries of the database
        print row


    ##====================================================================================================================================================
    ## define return variables
    return Contents
##--------------------------------------------------------------------------------------------------------------------------------------------------------

