#!/usr/bin/perl

#script to estimate the  parameters Teff, log g, Fe/H, micro
print "Usage: automoog_simple.pl EWs_file(.iron) EWs_file(all .moog) sun.par \n";
#
$obsfile=$ARGV[0];
$obsfileall=$ARGV[1];

if (! $obsfile ) {
   print "Usage: automoog_simple.pl EWs_file(.iron) EWs_file(all .moog) sun.par\n";
   exit;
}
$automoogpar="automoog.par";

open( INPAR,    $automoogpar)      || die;
while (<INPAR>) {
(@aryin ) = split;
}
close (INPAR);



$DIR=$aryin[0];
$DIR1=$aryin[1];
$DIRATMO=$aryin[2];
$error=$aryin[3];


#first iteration, with p=0.5
system "$DIR1/driver.pl $obsfile sun.par 0.5";


$input= "$DIR/${obsfile}.input";
open( IN,    $input )      || die;

# read the convergenge point, obtained starting from solar parameteres
$_ = <IN>;
my (@ary1 ) = split;
my $teff0  = $ary1[0];
my $logg0  = $ary1[1];
my $feh0   = $ary1[2];
my $micro0 = $ary1[3]; 
close(IN);

print "First step Teff: $teff0  Log g: $logg0  [Fe/H] $feh0 Micro $micro0\n";


#second step, starting from the first convergence point
$out1="${obsfile}.step1";
open (OUT1, ">$out1");
print OUT1 <<EOI;
$teff0 $logg0 $feh0 $micro0
EOI

#second iteration p=0.4
system "$DIR1/driver.pl $obsfile  ${obsfile}.step1 0.4";

$input1= "${DIR}/${obsfile}.input";
open( IN1,    $input1 )      || die;

# read the convergenge point, obtained starting from solar parameteres
$_ = <IN1>;
my (@ary2 ) = split;
my $teff01  = $ary2[0];
my $logg01  = $ary2[1];
my $feh01   = $ary2[2];
my $micro01 = $ary2[3]; 
close(IN1);

print "Second step: Teff: $teff01  Log g: $logg01  [Fe/H] $feh01 Micro $micro01\n";

my $delta_teff1= abs($teff - $teff1);
my $delta_logg1= abs($logg - $logg1);


$out2="${obsfile}.step2";
open (OUT1, ">$out2");
print OUT1 <<EOI;
$teff01 $logg01 $feh01 $micro01
EOI

#iteration 2
system "$DIR1/driver.pl $obsfile  ${obsfile}.step2 0.3";

$input2= "${DIR}/${obsfile}.input";
open( IN2,    $input2 )      || die;
# read the convergenge point, obtained starting from solar parameteres
$_ = <IN2>;
my (@ary3 ) = split;
my $teff02  = $ary3[0];
my $logg02  = $ary3[1];
my $feh02   = $ary3[2];
my $micro02 = $ary3[3]; 
close(IN2);

print "Second step: Teff: $teff02  Log g: $logg02  [Fe/H] $feh02 Micro $micro02\n";

$out3="${obsfile}.step3";
open (OUT3, ">$out3");
print OUT3 <<EOI;
$teff02 $logg02 $feh02 $micro02
EOI

system "$DIR1/driver.pl $obsfile  ${obsfile}.step3 0.25";

$input3= "${DIR}/${obsfile}.input";
open( IN3,    $input3 )      || die;
# read the convergenge point, obtained starting from solar parameteres
$_ = <IN3>;
my (@ary4 ) = split;
my $teff03  = $ary4[0];
my $logg03  = $ary4[1];
my $feh03   = $ary4[2];
my $micro03 = $ary4[3]; 
close(IN3);

print "Third step: Teff: $teff03  Log g: $logg03  [Fe/H] $feh03 Micro $micro03\n";

$out4="${obsfile}.step4";
open (OUT4, ">$out4");
print OUT4 <<EOI;
$teff03 $logg03 $feh03 $micro03
EOI

system "$DIR1/driver.pl $obsfile  ${obsfile}.step4 0.20";

$input4= "${DIR}/${obsfile}.input";
open( IN4,    $input4 )      || die;
# read the convergenge point, obtained starting from solar parameteres
$_ = <IN4>;
my (@ary5 ) = split;
my $teff04  = $ary5[0];
my $logg04  = $ary5[1];
my $feh04   = $ary5[2];
my $micro04 = $ary5[3]; 
close(IN4);

print "Forth step: Teff: $teff04  Log g: $logg04  [Fe/H] $feh04 Micro $micro04\n";

$out5="${obsfile}.step5";
open (OUT5, ">$out5");
print OUT5 <<EOI;
$teff04 $logg04 $feh04 $micro04
EOI

system "$DIR1/driver.pl $obsfile  ${obsfile}.step5 0.18";

$input5= "${DIR}/${obsfile}.input";
open( IN5,    $input5 )      || die;
# read the convergenge point, obtained starting from solar parameteres
$_ = <IN5>;
my (@ary6 ) = split;
my $teff05  = $ary6[0];
my $logg05  = $ary6[1];
my $feh05   = $ary6[2];
my $micro05 = $ary6[3]; 
close(IN5);

print "Fifth step: Teff: $teff05  Log g: $logg05  [Fe/H] $feh05 Micro $micro05\n";

$out6="${obsfile}.step6";
open (OUT6, ">$out6");
print OUT6 <<EOI;
$teff05 $logg05 $feh05 $micro05
EOI

system "$DIR1/driver.pl $obsfile  ${obsfile}.step6 0.15";

$input6= "${DIR}/${obsfile}.input";
open( IN6,    $input6 )      || die;
# read the convergenge point, obtained starting from solar parameteres
$_ = <IN6>;
my (@ary7 ) = split;
my $teffs  = $ary7[0];
my $loggs  = $ary7[1];
my $fehs   = $ary7[2];
my $micros = $ary7[3]; 
close(IN6);



print "First step Teff: $teff0  Log g: $logg0  [Fe/H] $feh0 Micro $micro0\n";
print "Second step: Teff: $teff01  Log g: $logg01  [Fe/H] $feh01 Micro $micro01\n";
print "Third step: Teff: $teff02  Log g: $logg02  [Fe/H] $feh02 Micro $micro02\n";
print "Forth step: Teff: $teff03  Log g: $logg03  [Fe/H] $feh03 Micro $micro03\n";
print "Fifth step: Teff: $teff04  Log g: $logg04  [Fe/H] $feh04 Micro $micro04\n";
print "Sixth step: Teff: $teff05  Log g: $logg05  [Fe/H] $feh05 Micro $micro05\n";

print "Six steps done: staring from sun.par --> $teffs $loggs $fehs $micros\n";

#estimating the errors

#starting for upper Teff. log. xi

$teff1=$teffs-150;
$teff2=$teffs+150;
$logg1=$loggs-0.2;
$logg2=$loggs+0.2;
#there are no models with logg > 5, thus
if ($logg2 > 5) {$logg2=5};
$micro1=$micros-0.15;
$micro2=$micros+0.15;


$out10="${obsfile}.lower";
open (OUT10, ">$out10");
print OUT10 <<EOI;
$teff1 $logg1 $fehs $micro1
EOI


system "$DIR1/driver.pl $obsfile  ${obsfile}.lower $error";
system "mv $DIR/${obsfile}.input $DIR/${obsfile}.lower.input";



$out11="${obsfile}.upper";
open (OUT11, ">$out11");
print OUT11 <<EOI;
$teff2 $logg2 $fehs $micro2
EOI

system "$DIR1/driver.pl $obsfile  ${obsfile}.upper $error";
system "mv $DIR/${obsfile}.input $DIR/${obsfile}.upper.input";

system "mv $DIR1/slope_out2 $DIR/";

$slope="${DIR}/slope_out2";
open( SLOPE,    $slope)      || die;
$_ = <SLOPE>;
(@arys ) = split;
$fedisp    = $arys[1];
close (SLOPE);


$upper="$DIR/${obsfile}.upper.input";
open( UPPER,    $upper)      || die;
$_ = <UPPER>;
(@aryu ) = split;
$teffu    = $aryu[0];
$loggu    = $aryu[1];
$fehu     = $aryu[2];
$microu   = $aryu[3];
close (UPPER);

$lower="$DIR/${obsfile}.lower.input";
open( LOWER,    $lower)      || die;
$_ = <LOWER>;
(@aryl ) = split;
$teffl    = $aryl[0];
$loggl    = $aryl[1];
$fehl     = $aryl[2];
$microl   = $aryl[3];
close (LOWER);


$errteff=(abs($teffs-$teffl)+abs($teffs-$teffu))/2;
$errlogg=(abs($loggs-$loggl)+abs($loggs-$loggu))/2;
$errmicro=(abs($micros-$microl)+abs($micros-$microu))/2;
$errfeh=(abs($fehs-$fehl)+abs($fehs-$fehu))/2;

$out13="$DIR/${obsfile}.input";
open (OUT13, ">$out13");
print OUT13 <<EOI;
$teffs $loggs $fehs $micros
EOI



$inputfile="${DIR}/$obsfile.input";
$inputfiles="${DIR}/$obsfile.solar.input";



open (OUT15, ">$inputfile");
printf OUT15 " %4.0f %3.2f %3.2f %3.2f\n", $teffs,  $loggs,  $fehs,  $micros;



##########################################
#this part runs with the complete list of elements
#other abundances

#prepare the dirs for INPUT and OUTPUT files



$obsfilenew="obs_sigma_all.dat";


print "moog file $obsfileall\n";

$filetemp="${DIR1}/myfile2";
$filetemp1="${DIR1}/myfile3";
$filetemp2="${DIR1}/myfile4";
$filetemp3="${DIR1}/myfile5";
$filetemp4="${DIR1}/myfile6";
$filetemp5="${DIR1}/myfile7";
#remove the first line from EW file
system "awk 'FNR>1' $obsfileall > $filetemp\n";
#remove the last line from EW file
system "grep -v moog1a $filetemp > $filetemp1\n";
#remove iron lines
system "grep -v 26.0 $filetemp1 > $filetemp2\n";
#remove iron 2 lines
system "grep -v 26.1 $filetemp2 > $filetemp3\n";
#cat the iron file
system "cat $filetemp3 $obsfile > $filetemp4\n";
#add  new line at the end
system "echo ' ' >> $filetemp4\n";
#sort to put the new line at the beginning
system "sort -k 2 $filetemp4 -o $filetemp5\n";
#
system "mv $filetemp5 $obsfileall\n";
system "rm myfile*\n";
#now the file is ready for moog
if (! $obsfileall ) {
   exit;
}
#to avoid problems with EW which are exactly equals to atomic numbers

#remove blanks at the end of each row 
system "sed  's/[ \t]*\$//' $obsfileall > myfile\n";
#add 1 at the end of each row
system "sed  's/\$/1/' myfile > myfile1\n";
system "mv myfile1 $obsfileall\n";




#first run the model atmo
$input="${DIR}/$obsfile.input";
print "input for Model atmo: $input\n";
#marcs models
system "${DIRATMO}/marcs_auto_sp.pl $input\n";
system "${DIRATMO}/interpol_perl.com\n";
#Na1 11.0
#Mg1 12.0
#Al1 13.0
#Si1 14.0
#Ca1 20.0
#Sc1 21.0
#Sc2 21.1
#Ti1 22.0
#Ti2 22.1
#V1  23.0
#Cr1 24.0
#Cr2 24.1
#Mn1 25.0
#Fe1 26.0
#Fe2 26.1
#Co1 27.0
#Ni1 28.0
#Cu1 29.0
#Zn1 30.0
#Sr1 38.0
#Y1  39.0
#Y2  39.1
#Zr1 40.0
#Zr2 40.1
#Ce2 58.1
#Nd2 60.1
#La2 57.1
#Ba2 56.1
#Nb1 41.1
#Mo1 42.1
#divide the file by elements to perform the sclipping on each element
#elements on which perform the sclipping
#here elements can be added
@i = ('3.0','11.0','12.0','13.0','14.0','20.0','21.0','21.1','22.0','22.1','23.0','24.0','24.1','25.0','27.0','28.0','29.0','30.0','38.0','39.0','39.1','40.0','40.1','41.1','42.2','56.1','57.1','62.1','63.1');
foreach $item (@i)
{
system "grep '$item ' $obsfileall > obsfile$item\n";
#add  new line at the end
system "echo ' ' >> obsfile$item\n";
#sort to put the new line at the beginning
system "sort -k 2 obsfile$item -o obsfile$item\n";

#preparing the input file for MOOG
system "rm ./something2.par";
$out1="./something2.par";
open (OUT1, ">$out1");
print OUT1 <<EOI;
abfind
standard_out   'out1'
summary_out    'out2'
model_in       '${DIR1}/RESULTS'
lines_in       'obsfile$item'
atmosphere      0
molecules       1
lines           1
terminal        'x11'
freeform        1
flux/int        0
plot            0
damping         1
obspectrum      0
plotpars        1
6290.0 6310.0 0.40  1.03
0.0    0.000  0.000 1.00
g      0.25   0.00  0.00  0.00 0.00
EOI
#running MOOG
system "./MOOG\n";
print "Running MOOG\n";



# read  out2 and gives  slopes of  correlations, average Fe and FeII abundances, and sigmas   
system "${DIR1}/read_final.pl out2";
#sigmaclipping
print "Now processing element with atommic number $item\n";
system "./sclipping_final.pl obsfile$item obsfilenew$item\n";



}
#divide the file by elements to perform the sclipping on each element
#elements on which perform the sclipping
@i = ('26.0');
foreach $item (@i)
{
system "grep '$item ' $obsfileall > obsfile$item\n";
#add  new line at the end
system "echo ' ' >> obsfile$item\n";
#sort to put the new line at the beginning
system "sort -k 2 obsfile$item -o obsfile$item\n";

#preparing the input file for MOOG
system "rm ./something2.par";
$out1="./something2.par";
open (OUT1, ">$out1");
print OUT1 <<EOI;
abfind
standard_out   'out1'
summary_out    'out2'
model_in       '${DIR1}/RESULTS'
lines_in       'obsfile$item'
atmosphere      0
molecules       1
lines           1
terminal        'x11'
freeform        1
flux/int        0
plot            0
damping         1
obspectrum      0
plotpars        1
6290.0 6310.0 0.40  1.03
0.0    0.000  0.000 1.00
g      0.25   0.00  0.00  0.00 0.00
EOI
#running MOOG
system "./MOOG\n";
print "Running MOOG\n";

#prepare a file with info to produce MOOG-like plots
system "grep - $DIR1/out2 > $DIR/test\n";
system "grep -v a  $DIR/test > $DIR/test1\n";
#remove the first line 
system "awk 'FNR>1' $DIR/test1 > $DIR/${obsfile}.formoog\n";


system "rm $DIR/test*\n";

# read  out2 and gives  slopes of  correlations, average Fe and FeII abundances, and sigmas   
system "${DIR1}/read_final.pl out2";
#sigmaclipping
print "Now processing element with atommic number $item\n";
system "./sclipping_$item.pl obsfile$item obsfilenew$item\n";

#add  new line at the end
system "echo ' ' >> obsfilenew$item\n";
#sort to put the new line at the beginning
system "sort -k 2 obsfilenew$item -o obsfilenew$item\n";

#preparing the input file for MOOG
system "rm ./something2.par";
$out1="./something2.par";
open (OUT1, ">$out1");
print OUT1 <<EOI;
abfind
standard_out   'out1'
summary_out    'out2'
model_in       '${DIR1}/RESULTS'
lines_in       'obsfilenew$item'
atmosphere      0
molecules       1
lines           1
terminal        'x11'
freeform        1
flux/int        0
plot            0
damping         1
obspectrum      0
plotpars        1
6290.0 6310.0 0.40  1.03
0.0    0.000  0.000 1.00
g      0.25   0.00  0.00  0.00 0.00
EOI
#running MOOG
system "./MOOG\n";
print "Running MOOG\n";
system "grep - $DIR1/out2 > $DIR/test\n";
system "grep -v a  $DIR/test > $DIR/test1\n";
#remove the first line 
system "awk 'FNR>1' $DIR/test1 > $DIR/${obsfile}.formoog.sigma\n";


system "rm $DIR/test*\n";


}
@i = ('26.1');
foreach $item (@i)
{
system "grep '$item ' $obsfileall > obsfile$item\n";
#add  new line at the end
system "echo ' ' >> obsfile$item\n";
#sort to put the new line at the beginning
system "sort -k 2 obsfile$item -o obsfile$item\n";

#preparing the input file for MOOG
system "rm ./something2.par";
$out1="./something2.par";
open (OUT1, ">$out1");
print OUT1 <<EOI;
abfind
standard_out   'out1'
summary_out    'out2'
model_in       '${DIR1}/RESULTS'
lines_in       'obsfile$item'
atmosphere      0
molecules       1
lines           1
terminal        'x11'
freeform        1
flux/int        0
plot            0
damping         1
obspectrum      0
plotpars        1
6290.0 6310.0 0.40  1.03
0.0    0.000  0.000 1.00
g      0.25   0.00  0.00  0.00 0.00
EOI
#running MOOG
system "./MOOG\n";
print "Running MOOG\n";

#prepare a file with info to produce MOOG-like plots
system "grep - $DIR1/out2 > $DIR/test\n";
system "grep -v a  $DIR/test > $DIR/test1\n";
#remove the first line 
system "awk 'FNR>1' $DIR/test1 > $DIR/${obsfile}.formoogfe2\n";


system "rm $DIR/test*\n";




# read  out2 and gives  slopes of  correlations, average Fe and FeII abundances, and sigmas   
system "${DIR1}/read_final.pl out2";
#sigmaclipping
print "Now processing element with atommic number $item\n";
system "./sclipping_$item.pl obsfile$item obsfilenew$item\n";

#add  new line at the end
system "echo ' ' >> obsfilenew$item\n";
#sort to put the new line at the beginning
system "sort -k 2 obsfilenew$item -o obsfilenew$item\n";

#preparing the input file for MOOG
system "rm ./something2.par";
$out1="./something2.par";
open (OUT1, ">$out1");
print OUT1 <<EOI;
abfind
standard_out   'out1'
summary_out    'out2'
model_in       '${DIR1}/RESULTS'
lines_in       'obsfilenew$item'
atmosphere      0
molecules       1
lines           1
terminal        'x11'
freeform        1
flux/int        0
plot            0
damping         1
obspectrum      0
plotpars        1
6290.0 6310.0 0.40  1.03
0.0    0.000  0.000 1.00
g      0.25   0.00  0.00  0.00 0.00
EOI
#running MOOG
system "./MOOG\n";
print "Running MOOG\n";
system "grep - $DIR1/out2 > $DIR/test\n";
system "grep -v a  $DIR/test > $DIR/test1\n";
#remove the first line 
system "awk 'FNR>1' $DIR/test1 > $DIR/${obsfile}.formoogfe2.sigma\n";


system "rm $DIR/test*\n";





}

#this files contains the EWs of all elements after a 2sclipping

system "cat obsfilenew??.? > obsfilenew.dat";
#preparing the input file for the last run of MOOG
#add  new line at the end
system "echo ' ' >> obsfilenew.dat\n";
#sort to put the new line at the beginning
system "sort -k 2 obsfilenew.dat -o obsfilenew.dat\n";

system "rm ./something2.par";
$out1="./something2.par";
open (OUT1, ">$out1");
print OUT1 <<EOI;
abfind
standard_out   'out1'
summary_out    'out2'
model_in       '${DIR1}/RESULTS'
lines_in       'obsfilenew.dat'
atmosphere      0
molecules       1
lines           1
terminal        'x11'
freeform        1
flux/int        0
plot            0
damping         1
obspectrum      0
plotpars        1
6290.0 6310.0 0.40  1.03
0.0    0.000  0.000 1.00
g      0.25   0.00  0.00  0.00 0.00
EOI
#running MOOG
system "./MOOG\n";
print "Running MOOG\n";


 
#final files in the OUTPUT dir
system "cp  $DIR1/out2 $DIR/${obsfile}.moog.out2\n";
system "cp  $DIR1/out1 $DIR/${obsfile}.moog.out1\n";
system "cp  $DIR1/obsfilenew.dat $DIR/${obsfile}.finalew\n";
system "rm  $DIR1/obsfile* \n";

#extract final abundances and elements name
system "grep Abu $DIR/${obsfile}.moog.out2 > $DIR/${obsfile}.moog.abu.label\n";
#system "rm $DIR/${obsfile}.moog.abu.value\n";
system "grep average  $DIR/${obsfile}.moog.out2 >> $DIR/${obsfile}.moog.abu.value\n";
system "paste $DIR/${obsfile}.moog.abu.label $DIR/${obsfile}.moog.abu.value > $DIR/${obsfile}.moog.abu.all\n";

#line by line differential analysis
system "grep - $DIR/${obsfile}.moog.out2 > $DIR/test\n";
system "grep -v a  $DIR/test > $DIR/test1\n";
#remove the first line 
system "awk 'FNR>1' $DIR/test1 > $DIR/${obsfile}.moog.abu.lines\n";


system "rm $DIR/test*\n";

$finalabu="$DIR/${obsfile}.moog.abu.all";
open( FINALABU,    $finalabu)      || die;
$_ = <FINALABU>;
(@aryf ) = split;
$el      = $aryf[4];
$ion     = $aryf[5];
$abu     = $aryf[13];
$sigma   = $aryf[17];
close (FINALABU);

#print "el\n";


$finalabu="$DIR/${obsfile}.moog.abu.all";
system "sed 's/)/ /' $DIR/${obsfile}.moog.abu.all >   $DIR/${obsfile}.moog.abu.all.1 \n";
system "sed 's/Fe/AFe/' $DIR/${obsfile}.moog.abu.all.1 >   $DIR/${obsfile}.moog.abu.all.2 \n";
system "sort -k 5 $DIR/${obsfile}.moog.abu.all.2 -o $DIR/${obsfile}.moog.abu.all.1\n";
$finalabu1="$DIR/${obsfile}.moog.abu.all.1";
open( FINALABU,    $finalabu1)      || die;
while (<FINALABU>) {
(@aryf ) = split;
push @el, $aryf[4];
push @ion, $aryf[5];
push @inabu, $aryf[9];
push @abu, $aryf[13];
push @sigma, $aryf[17];
push @nlines, $aryf[20];
push @shift, $aryf[9]-7.45;
$shiftiron=@shift[0];
#print "$shiftiron\n";
push @abusun, @aryf[13]+$shiftiron-@aryf[9];
}
close (FINALABU);


#@abusun1 = sprintf("%3.2f %3.2f", @abusun);
my $format =   ("%3.2f " x @abusun);
my $format1 =   ("%3.2f " x @abusunfe);
## print "the format is <<$format>>\n"; # for debugging
#printf $format, @abusunfe;

$finalabu="${DIR}/$obsfile.abu.end";
open (OUT16, ">$finalabu");
#printf OUT13 " %s %s %3.2f %3.2f \n",@el, @ion, @abu, @sigma ;
print OUT16 <<EOI;
@el 
@ion 
EOI
    printf OUT16 $format, @abu;
print OUT16 <<EOI;

@sigma
@nlines
EOI

$finalfile="${DIR}/$obsfile.end";




open (OUT14, ">$finalfile");
printf OUT14 " %s %4.0f %2.0f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f %3.2f\n",$obsfile, $teffs, $errteff, $loggs, $errlogg, @abusun[0], $errfeh, $fedisp, $micros, $errmicro;

system "(cd OUTPUT; echo '$obsfile' | sm -m plot.m)";


system "rm $DIR/$obsfile.moog.abu*\n";
system "rm $obsfile.step*\n";
system "rm $DIR/$obsfile.formoog*\n";
system "rm $DIR/$obsfile.*upper*\n";
system "rm $DIR/$obsfile.*lower*\n";
system "rm $DIR/$obsfile.*sigma*\n";
system "rm $DIR/$obsfile*input\n";

