plot

	erase 
	dev x11 -bg white
	ctype black

	define root?{star name (for which the analysis has been completed with automoog_simple.pl}
   
	local define print_noheader 1

   
    
	device postencap $root.ps
	#device x11 -bg white
	#file with the input grid (produced by automoog.pl)
    	data $!root.formoog.sigma
	read {EP 2}
	read {EW 4}
	read {lambda 1}
	read {fei 6} 	
	data $!root.formoogfe2.sigma
	read {EPfe2 2}
	read {EWfe2 4}
	read {lambdafe2 1}
	read {fe2 6}


	set ew=LG(EW/lambda)

	#file before sigmaclipping
  	data $!root.formoog
	read {EP1 2}
	read {EW1 4}
	read {lambda1 1}
	read {fei1 6}

	data $!root.formoogfe2
	read {EP1fe2 2}
	read {EW1fe2 4}
	read {lambda1fe2 1}
	read {fe21 6}


	set ew1=LG(EW1/lambda1)

	
	window 1 4 1 4

	#first panel EP (effective temperature)
	limits EP fei1
	box 1 2 0 0 

	xlabel E.P. (eV)
	ylabel log (FeI)
	ctype red 
	ptype 30 3
	points EP fei
	ctype black
	expand 1.5
	ptype 30 0
	points EP1 fei1 
	expand 1 
	
	ltype 3
	ctype blue
	lsq EP fei
	set x={-3 7000}
	set y=$a*x+$b
	connect x y
	ltype 4
	ctype magenta
	stats fei mean sigma kurtosis 
	set y=$mean+0*x
	connect x y
	ltype 0
	ctype black

	window 1 4 1 3

	#second panel ew (microturbolence)
	limits ew fei1
	box 1 2 0 0 

	xlabel log (EW/lambda)
	ylabel log (FeI)
	ctype red 
	ptype 30 3
	points ew fei
	ctype black
	expand 1.5
	ptype 30 0
	points ew1 fei1 
	expand 1 
	
	ltype 3
	ctype blue
	lsq ew fei
	set x={-3 7000}
	set y=$a*x+$b
	connect x y
	ltype 4
	ctype magenta
	set y=$mean+0*x
	connect x y
	ltype 0
	ctype black

	window 1 4 1 2

	#third panel lambda (measurement quality)
	limits lambda fei1
	box 1 2 0 0 

	xlabel lambda (A)
	ylabel log (FeI)
	ctype red 
	ptype 30 3
	points lambda fei
	ctype black
	expand 1.5
	ptype 30 0
	points lambda1 fei1 
	expand 1 

	ltype 3
	ctype blue
	lsq lambda fei
	set x={-3 7000}
	set y=$a*x+$b
	connect x y
	ltype 4
	ctype magenta
	set y=$mean+0*x
	connect x y
	ltype 0
	ctype black
	
	window 1 4 1 1
	#forth panel lambda (iron 2)
	limits lambda fei1
	box 1 2 0 0 

	xlabel lambda (A)
	ylabel log (FeII)
	ctype red 
	ptype 30 3
	#points lambda fei
	ctype black
	expand 1.5
	ptype 30 0
	#points lambda1 fei1 
	expand 2 

	ctype green 
	ptype 30 3
	points lambdafe2 fe2
	ctype blue
	expand 1.5
	ptype 30 0
	points lambda1fe2 fe21 
	expand 1 
	ctype magenta
	stats fei mean sigma kurtosis 
	set y=$mean+0*x
	connect x y
	ltype 0
	ctype black

	ctype black
	

	window 1 1 1 1


	data $!root.end
	read {teff 2}
	read {logg 4}
	read {feh 6}
	read {xi 9}

	define Teff (teff[0])
	define Logg (logg[0])
	define FEH  (feh[0])
	define Xi   (xi[0])
	
	relocate 0 1.

	label Star name: $root Teff: $Teff log g: $Logg [Fe/H]:$FEH xi: $Xi
	

	
