function subzero,inputarray
;+
; NAME:
;	SUBZERO
;
; PURPOSE:
;	This function replaces zero or subzero elements of the input array
;	by the mean of the neighbouring points.
;
; CALLING SEQUENCE:
;	Result = SUBZERO(Inputarray)
;
; INPUTS:
;	Inputarray:   Array to be treated.
;
; OUTPUTS:
;	This function returns the array containing no zero or subzero elements.
;
; EXAMPLE:
;       outputarray = subzero(inputarray)
;
; MODIFICATION HISTORY:
; 	Written by:	Natascha Rudolf, October 2013.
;-
; Copyright (C) 2013 Natascha Rudolf
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
; The above copyright notice and this permission notice shall be included in all
; copies or substantial portions of the Software.
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE.
;-
; does the array have (sub-)zero points
x=inputarray
ind=where(x le 0)
; if yes replace them by the mean of the neighbouring points
if not (n_elements(ind) eq 1 and ind[0] eq -1) then begin
    for i=0,n_elements(ind)-1 do begin
        ; point is first of array
        if ind[i] eq 0 then begin
	    x[ind[i]]=x[ind[i]+1]
	    continue
	endif
	; point is last of array
        if ind[i] eq (n_elements(inputarray)-1) then begin
	    x[ind[i]]=x[ind[i]-1]
	    continue
	endif
        x[ind[i]]=(x[ind[i]-1]+x[ind[i]+1])/2
    endfor
endif
return,x
end