pro recrfittellres,wave,data,error,range,gdasdata,obsaltitude,params,waveresult,result,cleaned,cleanederror,silent=silent
;+
; NAME:
;	RECRFITTELLRES
;
; PURPOSE:
;	This procedure recreates the output of FITTELL for the parameters specified.
;
; CALLING SEQUENCE:
;	RECRFITTELLRES,Wave,Data,Error,Range,Gdasdata,Obsaltitude,Params,Waveresult,Result,Cleaned,Cleanederror
;
; INPUTS:
;	Wave:		Wavelength array of observed spectrum
;	Data:		Flux array of observed spectrum
;	Error:		Error of flux measurements
;	Range:		Wavelength range of fit as two-element array in the form [start,end]
;	Gdasdata:	Scalar string containing absolute path to GDAS file
;	Obsaltitude:	Altitude angle observation was taken at in deg
;	Params:		Fitted parameters ([smoothing_FWHM,velocity_shift,
;			slope_of_straight,intercept_of_straight,water_abundance,
;			methane_abundance,carbondioxide_abundance,oxygen_abundance])
;	
; KEYWORD PARAMETERS:
;	SILENT:		Set this keyword to suppress informational messages
;
; OUTPUTS:
;	Waveresult:	Wavelength array of the fitted part
;	Result:		Model fitted with all parameters (to be compared to observation)
;	Cleaned:	Telluric line removed spectrum.
;	Cleanederror:	Error of flux measurements divided by transmission model.
;
; EXAMPLE:
;       RECRFITTELLRES,Wave,Data,Error,[9000.,9300.],'/here/lies/the/Gdasdata',87.2,Params,Waveresult,Result,Cleaned,Cleanederror
;
; MODIFICATION HISTORY:
; 	Written by:	Natascha Rudolf, October 2013.
;-
; Copyright (C) 2013 Natascha Rudolf
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
; The above copyright notice and this permission notice shall be included in all
; copies or substantial portions of the Software.
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE.
;-
; define index of region of fit
induse=where(wave ge range[0] and wave le range[1])
wavuse=wave[induse]
datuse=data[induse]
erruse=error[induse]
datuse=subzero(datuse) ; remove subzero points (if any)

; remove telluric lines from observed spectrum and return telluric spectrum of complete range if exclude was set
waveresult=wavuse
result=tell(waveresult,params,gdasdata=gdasdata,obsaltitude=obsaltitude,silent=silent)
modell=tellwithout(waveresult,params,gdasdata=gdasdata,obsaltitude=obsaltitude,silent=silent)
cleaned=datuse/modell
cleanederror=erruse/modell
end