! Code Aspects, version 2.0.
! Michel Fioc, 2014-4-15. 

module mod_read_catalog

  use mod_types, only: real_type
  implicit none
  real(kind=real_type) :: area_S_u, area_S_p ! Variables used in `example_read`.
  private
  public :: read_catalog, area_S_u, area_S_p

contains
!======================================================================

  subroutine read_catalog(file_name, n, area_S, coord)

! Read the area covered by catalog in file `file_name`, and the cardinal 
! number, the coordinates and the positional uncertainties of the sources 
! it contains.
    use mod_types, only: coord_struct
    use mod_files
    implicit none
    character(len=*), intent(in) :: file_name
    integer, intent(out) :: n
    real(kind=real_type), intent(out) :: area_S
    type(coord_struct), dimension(:), pointer :: coord
!......................................................................
    integer :: unit, i, ios
    type(coord_struct) :: coord_add
!______________________________________________________________________

    unit = new_unit()
    open(unit=unit, file=file_name)
    call skip_comments(unit)
    read(unit, *) n, area_S
    
    if (associated(coord)) deallocate(coord)
    allocate(coord(n))
    
    do i = 1, n ! Sources must be ordered by increasing right ascension. 
       read(unit, *, iostat = ios) coord(i)%alpha, coord(i)%delta, &
            coord(i)%semi_axis_a, coord(i)%semi_axis_b, coord(i)%beta
       if (ios < 0) then ! Erroneous number of sources.
          write(*,"(3a,i0,a,i0,a/a)") "File """, trim(file_name), &
               """: the real number of sources is ", i, ", not ", n, ".", &
               "Stopped."
          stop
       endif
       if (ios > 0) then ! Wrong input.
          write(*,"(3a/a)") "Error while reading file """, trim(file_name), &
               """.", "Stopped."
          stop
       endif
       if (i >= 2) then
          if (coord(i)%alpha < coord(i-1)%alpha) then
             write(*,"(3a)") "File """, trim(file_name), &
                  """: sources are not ordered by increasing &
                  &right ascension. Stopped."
             write(*,*) i
             stop
          endif
       endif
    enddo

! Check the number of sources (try to read another line):
    read(unit, *, iostat = ios) coord_add%alpha, coord_add%delta, &
         coord_add%semi_axis_a, coord_add%semi_axis_b, coord_add%beta
    if (ios == 0) then 
       write(*,"(3a,i0,a)") "Warning: file """, trim(file_name), &
            """ contains more than ", n, " sources."
    endif
    close(unit)
    
  end subroutine read_catalog

end module mod_read_catalog
  
