/*==================================================================
** NAME         :gsc_dec.c     ** Version 2 (GSC 1.1) **
** TYPE         :main
** DESCRIPTION  :decode GSC records encoded as c[12]
**              :
** INPUT        :encoded region, stdin or command line
**              :
** OUTPUT       :decoded region, stdout
**              :
** AUTHOR       :a.p.martinez
** DATE         :09/92
**		Adapted Tubo-C: F. Ochsenbein, April 1996
*=================================================================*/

#include <gsc.h>

static char usage[] = "\
Usage: decode [-help] [gsc_bin_file]...\0\
       Several files may be decoded\
";

main(argc,argv)
        int argc; char **argv;
{
	unsigned char c[12];
	char *ptr;
	int n=0,fp=0;
	HEADER h;
	GSCREC r;

	while (--argc > 0) {
		++argv;
		if (**argv == '-') switch(argv[0][1]) {
		case 'h': case 'H': case '?':
			puts(usage); puts(usage+1+strlen(usage));
			exit(0);
		default:
			fprintf(stderr, "****Bad option: %s\n", *argv);
			puts(usage);
			exit(1);
		}

		fp = open(*argv, O_BINARY);
		if(fp < 0) { perror(*argv); exit(1); }
		if (n) puts("");	/* Empty line between files */
		n++;

		/* Print the Header line of the GSC binary file	*/
		ptr = get_header(fp,&h);
		if (!ptr) {
			fprintf(stderr, "****Bad GSC binary file: %s\n", *argv);
			exit(1);
		}
		puts(ptr);

		/* Display the decoded contents of the GSC binary file */
		while(read(fp,c,12) == 12)
			decode_c(c,&h,&r),
			prtgsc(-1,0,&r);
	}

	/* Do the job on the stdin if no file specified */
	if (n) exit(0);

	/* Print the Header line of the GSC binary file	*/
	ptr = get_header(fp,&h);
	if (!ptr) {
		fprintf(stderr, "****Bad GSC header in %s\n", "stdin");
		exit(1);
	}
	puts(ptr);

	/* Display the decoded contents of the GSC binary file */
	while(read(fp,c,12) == 12)
		puts(decode_c(c,&h,&r));

	exit(0);
}
